/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.Observer;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowController;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class VoJobQueue
implements Runnable,
Observer {
    private volatile Thread refreshThread;
    private ArrayList voJobQue = new ArrayList();
    private ArrayList coliJobQue = new ArrayList();
    final VibManager vibManager;
    private volatile boolean isStopped = false;

    public VoJobQueue(VibManager vibManager) {
        this.vibManager = vibManager;
    }

    @Override
    public void run() {
        this.serviceVoQueues();
    }

    public void start() {
        this.refreshThread = new Thread((Runnable)this, "VoJobQueue");
        this.isStopped = false;
        this.refreshThread.start();
    }

    public void halt() {
        this.isStopped = true;
        if (this.refreshThread != null && this.refreshThread.isAlive()) {
            Trace.observation(this, "Stop of refresh thread pending...");
        }
    }

    public int getVoQueueLength() {
        return this.voJobQue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllVos(List list) {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            this.voJobQue.addAll(list);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewableObject popNextInVoQue() {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            ViewableObject viewableObject = null;
            if (!this.voJobQue.isEmpty()) {
                viewableObject = (ViewableObject)this.voJobQue.get(0);
                this.voJobQue.remove(0);
            }
            return viewableObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewableObject popNextInColiQue() {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            ViewableObject viewableObject = null;
            if (!this.coliJobQue.isEmpty()) {
                viewableObject = (ViewableObject)this.coliJobQue.get(0);
                this.coliJobQue.remove(0);
            }
            return viewableObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInColiQue(ViewableObject viewableObject) {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            if (this.coliJobQue.isEmpty()) {
                Trace.observation(this, "Coli Job Queue is busy");
            }
            if (this.coliJobQue.contains(viewableObject)) {
                this.coliJobQue.remove(viewableObject);
            }
            ArrayList<ViewableObject> arrayList = new ArrayList<ViewableObject>();
            arrayList.add(viewableObject);
            arrayList.addAll(this.coliJobQue);
            this.coliJobQue = arrayList;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfEmpty() throws InterruptedException {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            if (this.voJobQue.isEmpty()) {
                this.wait(2000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVoJobQueueEmpty() {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            return this.voJobQue.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prioritise(ViewableObject viewableObject) {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            ArrayList<ViewableObject> arrayList;
            if (this.voJobQue.contains(viewableObject)) {
                Trace.observation(this, " VO Job Prioritising" + viewableObject.getFullName());
                this.voJobQue.remove(viewableObject);
                arrayList = new ArrayList<ViewableObject>();
                arrayList.add(viewableObject);
                arrayList.addAll(this.voJobQue);
                this.voJobQue = arrayList;
                this.notifyAll();
            }
            if (this.coliJobQue.contains(viewableObject)) {
                Trace.observation(this, " Coli Job Prioritising" + viewableObject.getFullName());
                this.coliJobQue.remove(viewableObject);
                arrayList = new ArrayList();
                arrayList.add(viewableObject);
                arrayList.addAll(this.coliJobQue);
                this.coliJobQue = arrayList;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInQueue(ViewableObject viewableObject) {
        VoJobQueue voJobQueue = this;
        synchronized (voJobQueue) {
            if (this.voJobQue.isEmpty()) {
                Trace.observation(this, "Vo Job Queue is busy");
            }
            if (this.voJobQue.contains(viewableObject)) {
                this.prioritise(viewableObject);
            } else {
                Trace.observation(this, " VO Job queued" + viewableObject.getFullName());
                ArrayList<ViewableObject> arrayList = new ArrayList<ViewableObject>();
                arrayList.add(viewableObject);
                arrayList.addAll(this.voJobQue);
                this.voJobQue = arrayList;
                this.notifyAll();
            }
        }
    }

    public MainWindowController getMainWindowController() {
        return this.vibManager.getMainWindowController();
    }

    private void serviceVoQueues() {
        while (!this.isStopped) {
            this.serviceTheNextOneInQueue();
        }
        Trace.observation(this, "Refresh thread stopped");
    }

    private void serviceTheNextOneInQueue() {
        try {
            this.waitIfEmpty();
            ViewableObject viewableObject = this.popNextInVoQue();
            if (viewableObject != null) {
                this.orderMoRefresh(viewableObject);
                if (this.voJobQue.isEmpty()) {
                    Trace.observation(this, "VO Queue is empty");
                    this.vibManager.reportVoQueueIsEmpty();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.warning(this, "The refresh thread is dead");
            this.isStopped = true;
        }
    }

    private void orderMoRefresh(ViewableObject viewableObject) {
        if (viewableObject != null) {
            Trace.observation(this, " VO Job: performing MO refresh job on " + viewableObject.getFullName());
            this.vibManager.doRefreshMoAttributes(viewableObject);
            viewableObject.notifyAllVoListeners(2);
        }
    }

    public void orderStopMoRefresh() {
        Trace.observation(this, "Removing all refresh jobs from VoJobQueue");
        Iterator iterator = this.voJobQue.iterator();
        while (iterator.hasNext()) {
            VoData voData = (VoData)iterator.next();
            if (!voData.isReasonRefresh()) continue;
            iterator.remove();
        }
    }

    @Override
    public void done() {
    }
}

