/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty;

import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.Condition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.DynamicVariables;

public class StringCompareCondition
implements Condition {
    private final COMPARISON type;
    private final String var;
    private final String str;

    public StringCompareCondition(String string, String string2, COMPARISON cOMPARISON) {
        this.var = string;
        this.str = string2;
        this.type = cOMPARISON;
    }

    @Override
    public boolean evaluate(DynamicVariables dynamicVariables) {
        boolean bl = false;
        if (this.var == null) {
            Trace.warning(this, " Variable \"null\" NOT found among variables in DynamicVariables");
            return false;
        }
        String string = dynamicVariables.get(this.var);
        if (string == null) {
            Trace.warning(this, " Variable " + this.var + " NOT found among variables in DynamicVariables");
            return false;
        }
        if (this.type == null) {
            Trace.warning(this, " Comparison type = null is not supported in class " + this.getClass().getName());
            return false;
        }
        if (this.type.equals((Object)COMPARISON.EQUALS) && string.equals(this.str)) {
            bl = true;
        } else if (this.type.equals((Object)COMPARISON.CONTAINS) && string.indexOf(this.str) >= 0) {
            bl = true;
        } else if (this.type.equals((Object)COMPARISON.STARTS_WITH) && string.startsWith(this.str)) {
            bl = true;
        } else if (this.type.equals((Object)COMPARISON.ENDS_WITH) && string.endsWith(this.str)) {
            bl = true;
        }
        return bl;
    }

    public static enum COMPARISON {
        EQUALS,
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH;

    }
}

