/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.service;

import java.awt.Image;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements Configuration {
    private String myHost = null;
    private Properties myProperties = null;
    private Map<String, String> myConfigFiles = null;
    private Map<String, Tool> myToolList = null;
    private Image iconImage = null;
    private String iconToPassOn = null;
    public static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";

    public ConfigurationImpl(String host, Properties props) {
        this.myHost = host;
        this.myProperties = props;
        this.myConfigFiles = new HashMap<String, String>();
        this.myToolList = new HashMap<String, Tool>();
        this.iconToPassOn = props.getProperty("TOOL_ICON");
        IconHelper helper = new IconHelper();
        this.iconImage = helper.getIconImage(this.iconToPassOn);
    }

    @Override
    public String getCustomApplName() {
        return this.myProperties.getProperty("CUSTOM_APPL_NAME", "the property CUSTOM_APPL_NAME is not defined");
    }

    @Override
    public String getHost() {
        return this.myHost;
    }

    @Override
    public List<Tool> getHyperTools() {
        return this.getToolsList("HYPER_TOOL_KEYS");
    }

    @Override
    public List<String> getLdns() {
        LinkedList<String> ldnList = new LinkedList<String>();
        String aLdns = this.myProperties.getProperty("LDNs");
        if (System.getProperty("LdnToShow") != null) {
            aLdns = System.getProperty("LdnToShow");
        }
        if (aLdns == null) {
            return ldnList;
        }
        String[] ldnsArray = aLdns.split(";");
        ldnList.addAll(Arrays.asList(ldnsArray));
        return ldnList;
    }

    @Override
    public String getManagerTitle() {
        return this.myProperties.getProperty("MANAGER_TITLE", "the property MANAGER_TITLE is not defined");
    }

    @Override
    public Tool getMoSearchTool() {
        String moSearchConfig = this.myProperties.getProperty("MOSEARCH_CONFIG", "MOSEARCH_CONFIG is not defined");
        String moSearchName = this.myProperties.getProperty("MOSEARCH_NAME", "MOSEARCH_NAME is not defined");
        String moSearchKey = "not defined";
        Tool moSearchTool = new Tool(moSearchKey, moSearchConfig, moSearchName);
        this.myConfigFiles.put(moSearchName, moSearchConfig);
        this.myToolList.put(moSearchName, moSearchTool);
        return moSearchTool;
    }

    @Override
    public Tool getNodeServicesTool() {
        String nodeServConfig = this.myProperties.getProperty("NODESERVICES_CONFIG", "NODESERVICES_CONFIG is not defined");
        String nodeServName = this.myProperties.getProperty("NODESERVICES_NAME", "NODESERVICES_NAME is not defined");
        String nodeServKey = "not defined";
        Tool nodeServTool = new Tool(nodeServKey, nodeServConfig, nodeServName);
        this.myConfigFiles.put(nodeServName, nodeServConfig);
        this.myToolList.put(nodeServName, nodeServTool);
        return nodeServTool;
    }

    @Override
    public Tool getPreferencesTool() {
        Tool userPrefServTool = null;
        String MISSING = "MISSING";
        String userPrefConfig = this.myProperties.getProperty("PREFERENCESERVICE_CONFIG", "MISSING");
        if (!userPrefConfig.equals("MISSING")) {
            String userPrefName = this.myProperties.getProperty("PREFERENCESERVICE_NAME", "EM User Preferences");
            String prefServKey = "not defined";
            userPrefServTool = new Tool(prefServKey, userPrefConfig, userPrefName);
            this.myConfigFiles.put(userPrefName, userPrefConfig);
            this.myToolList.put(userPrefConfig, userPrefServTool);
        }
        String moPropCfg = this.myProperties.getProperty("MOPROPERTIES_CONFIG", "/cello/emas/mopropcfg.xml");
        this.myConfigFiles.put("Create CV...", moPropCfg);
        this.myConfigFiles.put("Put to FTP...", moPropCfg);
        this.myConfigFiles.put("Get from FTP...", "/cello/emas/cvgetfromftpcfg.xml");
        this.myConfigFiles.put("Restore CV...", "/cello/emas/cvrestorecfg.xml");
        this.myConfigFiles.put("MOPROPERTIES", moPropCfg);
        return userPrefServTool;
    }

    @Override
    public String getSelectedActionName() {
        if (this.myProperties == null) {
            return null;
        }
        String aActionName = this.myProperties.getProperty("MOACTION");
        return aActionName;
    }

    @Override
    public Image getIconImage() {
        return this.iconImage;
    }

    @Override
    public String getIconToPassOn() {
        return this.iconToPassOn;
    }

    @Override
    public Tool getHyperTool(String name) {
        return this.getTool(name);
    }

    @Override
    public String getLdn() {
        return null;
    }

    @Override
    public String getMoClassToSearchFor() {
        return null;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public Tool getTool(String key) {
        Tool aTool = this.myToolList.get(key);
        return aTool;
    }

    @Override
    public boolean isLdnSelector() {
        return false;
    }

    @Override
    public Properties getProperties() {
        return this.myProperties;
    }

    @Override
    public String getConfigurationFile(String toolName) {
        String configFileName = this.myConfigFiles.get(toolName);
        return configFileName;
    }

    @Override
    public List<Tool> getCvHyperTools() {
        return this.getToolsList("SWE_CV_HYPER_TOOL_KEYS");
    }

    @Override
    public List<Tool> getUpHyperTools() {
        return this.getToolsList("SWE_UP_HYPER_TOOL_KEYS");
    }

    private List<Tool> getToolsList(String toolKey) {
        LinkedList<Tool> hyperToolList = new LinkedList<Tool>();
        String strHyperTools = this.myProperties.getProperty(toolKey);
        if (strHyperTools == null) {
            return hyperToolList;
        }
        String[] hyperKeyArray = strHyperTools.split(";");
        for (int i = 0; i < hyperKeyArray.length; ++i) {
            String nameKey = hyperKeyArray[i] + "_NAME";
            String hyperToolName = this.myProperties.getProperty(nameKey, nameKey + " is not defined");
            String configKey = hyperKeyArray[i] + "_CONFIG";
            String hyperToolConfigFile = this.myProperties.getProperty(configKey, configKey + " is not defined");
            Tool hyperTool = new Tool(hyperKeyArray[i], hyperToolConfigFile, hyperToolName);
            hyperToolList.add(hyperTool);
            if (!this.myConfigFiles.containsKey(hyperToolName)) {
                this.myConfigFiles.put(hyperToolName, hyperToolConfigFile);
            }
            this.myToolList.put(hyperToolName, hyperTool);
        }
        return hyperToolList;
    }

    @Override
    public String getToolName(String toolName) {
        String nameKey = toolName + "_NAME";
        String configFileTag = toolName + "_CONFIG";
        String hyperToolName = this.myProperties.getProperty(nameKey, nameKey + " is not defined");
        String configFileName = this.myProperties.getProperty(configFileTag, configFileTag + " is not defined");
        Tool hyperTool = new Tool(nameKey, configFileName, hyperToolName);
        if (!this.myConfigFiles.containsKey(hyperToolName)) {
            this.myConfigFiles.put(hyperToolName, configFileName);
        }
        this.myToolList.put(hyperToolName, hyperTool);
        return hyperToolName;
    }

    @Override
    public Properties getSupersedingProperties() {
        Properties tempProp = new Properties();
        String strSupersedingList = this.myProperties.getProperty(SUPERSEDING_PARAMETER_LIST);
        if (strSupersedingList != null) {
            tempProp.put(SUPERSEDING_PARAMETER_LIST, strSupersedingList);
            String[] supersedingListArray = strSupersedingList.split(";");
            for (int i = 0; i < supersedingListArray.length; ++i) {
                String supersedingName = supersedingListArray[i];
                String supersedingValue = this.myProperties.getProperty(supersedingName);
                if (null == supersedingValue) continue;
                tempProp.put(supersedingName, supersedingValue);
            }
        }
        return tempProp;
    }
}

