/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.swe.view.gui.TimeConverter;

public class ColumnHeaderListener
extends MouseAdapter {
    protected static final String COLUMNWIDTH_PREFERENCE_KEY = "cpp_swembed_columnwidth_";
    protected static final String COLUMNSORTINDEX_PREFERENCE_KEY = "cpp_swembed_sortColumn_index_";
    protected static final String COLUMNSORTASCDEC_PREFERENCE_KEY = "cpp_swembed_sortColumn_ascDec_";
    private TimeConverter myTimeConverter = new TimeConverter();
    private boolean ascending = true;
    private int columnIndex = 0;
    private UserPreferencesI userPrefs;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ColumnHeaderListener(UserPreferencesI userPreferences, JTable table) {
        this.userPrefs = userPreferences;
        String sortKey = COLUMNSORTASCDEC_PREFERENCE_KEY + table.getName();
        String indexKey = COLUMNSORTINDEX_PREFERENCE_KEY + table.getName();
        this.ascending = Boolean.parseBoolean(this.userPrefs.getPreference(sortKey, "true"));
        this.columnIndex = Integer.parseInt(this.userPrefs.getPreference(indexKey, "0"));
    }

    public void mouseReleased(MouseEvent event) {
        JTable table = ((JTableHeader)event.getSource()).getTable();
        this.saveColumnSizes(table);
    }

    public void mouseClicked(MouseEvent event) {
        JTable table = ((JTableHeader)event.getSource()).getTable();
        TableColumnModel columnModel = table.getColumnModel();
        int xIndex = columnModel.getColumnIndexAtX(event.getX());
        if (xIndex == -1) {
            return;
        }
        this.columnIndex = xIndex;
        this.ascending = !this.ascending;
        this.sortAllRowsBy((DefaultTableModel)table.getModel());
        this.userPrefs.setPreference(COLUMNSORTINDEX_PREFERENCE_KEY + table.getName(), String.valueOf(xIndex));
        this.userPrefs.setPreference(COLUMNSORTASCDEC_PREFERENCE_KEY + table.getName(), String.valueOf(Boolean.valueOf(this.ascending).toString()));
    }

    public void sortAllRowsBy(DefaultTableModel tmodel) {
        Collections.sort(tmodel.getDataVector(), new ColumnSorter(this.columnIndex, this.ascending));
        tmodel.fireTableStructureChanged();
    }

    private void saveColumnSizes(JTable table) {
        if (null != this.userPrefs) {
            int length = table.getColumnCount();
            for (int i = 0; i < length; ++i) {
                int width = table.getColumn(table.getColumnName(i)).getWidth();
                this.userPrefs.setPreference(COLUMNWIDTH_PREFERENCE_KEY + table.getName() + table.getColumnName(i) + "_", String.valueOf(width));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnSorter
    implements Comparator<Object> {
        int colIdx;
        boolean ascend;
        Integer t1 = null;
        Integer t2 = null;
        Object o1 = null;
        Object o2 = null;
        Date d1 = null;
        Date d2 = null;

        ColumnSorter(int colIdx, boolean ascend) {
            this.colIdx = colIdx;
            this.ascend = ascend;
        }

        private void numberFormat(Object obj1, Object obj2) {
            this.o1 = obj1;
            this.o2 = obj2;
            if (obj1 != null && obj2 != null) {
                try {
                    this.t1 = new Integer(obj1.toString());
                    this.t2 = new Integer(obj2.toString());
                    this.o1 = this.t1;
                    this.o2 = this.t2;
                }
                catch (NumberFormatException e) {
                    this.t1 = null;
                    this.t2 = null;
                }
            }
        }

        private void dateFormat(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && (this.t1 == null || this.t2 == null)) {
                this.d1 = ColumnHeaderListener.this.myTimeConverter.formatTime(obj1.toString());
                this.d2 = ColumnHeaderListener.this.myTimeConverter.formatTime(obj2.toString());
                if (this.d1 != null && this.d2 != null) {
                    this.o1 = ColumnHeaderListener.this.sdf.format(this.d1);
                    this.o2 = ColumnHeaderListener.this.sdf.format(this.d2);
                }
            }
        }

        private int compareObj() {
            if (this.o1 == null && this.o2 == null) {
                return 0;
            }
            if (this.o1 == null) {
                return 1;
            }
            if (this.o2 == null) {
                return -1;
            }
            if (this.o1 instanceof Integer) {
                if (this.ascend) {
                    if ((Integer)this.o1 > (Integer)this.o2) {
                        return 1;
                    }
                    if ((Integer)this.o1 < (Integer)this.o2) {
                        return -1;
                    }
                    return 0;
                }
                if ((Integer)this.o1 > (Integer)this.o2) {
                    return -1;
                }
                if ((Integer)this.o1 < (Integer)this.o2) {
                    return 1;
                }
                return 0;
            }
            if (this.o1 instanceof Comparable) {
                if (this.o1 instanceof String) {
                    this.o1 = this.o1.toString().toLowerCase();
                    this.o2 = this.o2.toString().toLowerCase();
                }
                if (this.ascend) {
                    return ((Comparable)this.o1).compareTo(this.o2);
                }
                return ((Comparable)this.o2).compareTo(this.o1);
            }
            if (this.ascend) {
                return this.o1.toString().compareTo(this.o2.toString());
            }
            return this.o2.toString().compareTo(this.o1.toString());
        }

        @Override
        public int compare(Object i, Object j) {
            Vector v1 = (Vector)i;
            Vector v2 = (Vector)j;
            Object obj1 = v1.get(this.colIdx);
            Object obj2 = v2.get(this.colIdx);
            if (obj1 instanceof String && ((String)obj1).length() == 0) {
                obj1 = null;
            }
            if (obj2 instanceof String && ((String)obj2).length() == 0) {
                obj2 = null;
            }
            this.numberFormat(obj1, obj2);
            this.dateFormat(obj1, obj2);
            return this.compareObj();
        }
    }
}

