/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.consumedenergy;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ConsumedEnergyMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = ConsumedEnergyMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CONSUMED_ENERGY_MEASUREMENT_MO = "ConsumedEnergyMeasurement";
    private static final String NODE_MANAGEMEMT_FUNCTION_MO = "NodeManagementFunction";

    public ConsumedEnergyMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, "ConsumedEnergy", genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ConsumedEnergyMaoImpl() - constructor");
        if (this.moExists(NODE_MANAGEMEMT_FUNCTION_MO) && !this.moExists(CONSUMED_ENERGY_MEASUREMENT_MO)) {
            this.createConsumedEnergyMeasurementMO(coordinator);
        }
    }

    public ConsumedEnergyMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ConsumedEnergyMaoImpl()- constructor used at restore");
        logger.traceReturn(THIS_CLASS, "ConsumedEnergyMaoImpl()- constructor used at restore");
    }

    private void createConsumedEnergyMeasurementMO(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createConsumedEnergyMeasurementMO()");
        ManagedObject managedObject = this.getMaoContext().getMoAccessor().lookupType(NODE_MANAGEMEMT_FUNCTION_MO).nextMo();
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(CONSUMED_ENERGY_MEASUREMENT_MO);
        MaoFactory maoFactory = this.genericMaoContext.getMaoFactoryFactory().getMoFactory(moMetaData);
        MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        AttrListImpl attrListImpl = new AttrListImpl(moRepositoryWrapper);
        maoFactory.createMo(managedObject, (AttrList)attrListImpl, "1", null, coordinator);
        logger.traceReturn(THIS_CLASS, "createConsumedEnergyMeasurementMO()");
    }

    private boolean moExists(String string) {
        logger.traceEnter(THIS_CLASS, "moExists()");
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(string);
        logger.traceReturn(THIS_CLASS, "moExists()");
        return null != moIterator;
    }
}

