/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.energymeter;

import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.consumedenergy.ConsumedEnergyMaoImpl;
import se.ericsson.crbs.supsys.efuse.ActionNotSupportedException;
import se.ericsson.crbs.supsys.efuse.HwNotPresentException;
import se.ericsson.crbs.supsys.efuse.ParamNotSupportedException;

public class EnergyMeterMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = EnergyMeterMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "EnergyMeter";
    private static final String ATTRIBUTE_CONSUMED_ENERGY_REF = "consumedEnergyRef";
    private static final String CONSUMED_ENERGY_MO = "ConsumedEnergy";
    private static final String AUX_PLUG_IN_UNIT_MO = "AuxPlugInUnit";
    private static final String ATTRIBUTE_ENERGY_METER_ENABLED = "energyMeterEnabled";
    private static final String ACTION_SETENERGYMETERENABLED = "setEnergyMeterEnabled";
    protected static final String RESULT_HW_NOT_PRESENT = Integer.toString(17039373);
    protected static final String RESULT_PARAM_NOT_SUPPORTED = Integer.toString(17039374);
    protected static final String RESULT_ACTION_NOT_SUPPORTED = Integer.toString(0x1040010);
    protected static final String RESULT_ACTION_NOT_POSSIBLE_TO_SET_ENERGYMETER_STATE = Integer.toString(0x1040011);

    public EnergyMeterMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EneryMeterMaoImpl() - constructor");
        this.setConsumedEnergyReference(coordinator);
        logger.traceReturn(THIS_CLASS, "EneryMeterMaoImpl() - constructor");
    }

    public EnergyMeterMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EnergyMeterImpl() - Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "EnergyMeterImpl() - Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet() -- " + string);
        if (string.equals(ATTRIBUTE_CONSUMED_ENERGY_REF)) {
            this.preSetConsumedEnergyRef(object, coordinator);
        } else if (string.equals(ATTRIBUTE_ENERGY_METER_ENABLED)) {
            this.preSetEnergyMeterEnabled();
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    public void actionSetEnergyMeterEnabled(boolean bl, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSetEnergyMeterEnabled()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(ATTRIBUTE_ENERGY_METER_ENABLED, bl);
        try {
            this.sendActionWithCfm(ACTION_SETENERGYMETERENABLED, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_HW_NOT_PRESENT)) {
                String string3 = "Hardware is not present " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new HwNotPresentException(MO_TYPE, string3);
            }
            if (string2.equals(RESULT_PARAM_NOT_SUPPORTED)) {
                String string4 = "Does not support setting of this parameter " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string4);
                throw new ParamNotSupportedException(MO_TYPE, string4);
            }
            if (string2.equals(RESULT_ACTION_NOT_POSSIBLE_TO_SET_ENERGYMETER_STATE)) {
                String string5 = "Max number of supported enabled EnergyMeter reached " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string5);
                throw new ActionNotSupportedException(MO_TYPE, string5);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionSetEnergyMeterEnabled()");
    }

    public void delete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "delete()");
        try {
            super.delete(coordinator);
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "delete(): Uncaught exception: " + moAccessException.toString());
            throw moAccessException;
        }
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    private void preSetConsumedEnergyRef(Object object, Coordinator coordinator) throws ActionNotSupportedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetConsumedEnergyRef()");
        boolean bl = object instanceof ConsumedEnergyMaoImpl;
        boolean bl2 = this.getParent().getType().equals(AUX_PLUG_IN_UNIT_MO);
        if (!bl || !bl2) {
            throw new ActionNotSupportedException(MO_TYPE, "Attribute consumedEnergyRef cannot be set manually.");
        }
        logger.traceReturn(THIS_CLASS, "preSetConsumedEnergyRef()");
    }

    private void setConsumedEnergyReference(Coordinator coordinator) throws ActionNotSupportedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "setConsumedEnergyReference()");
        if (this.getParent().getType().equals(AUX_PLUG_IN_UNIT_MO) && this.moExists(CONSUMED_ENERGY_MO)) {
            MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(CONSUMED_ENERGY_MO);
            this.setAttribute(ATTRIBUTE_CONSUMED_ENERGY_REF, moIterator.nextMo(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setConsumedEnergyReference()");
    }

    private void preSetEnergyMeterEnabled() throws ActionNotSupportedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetEnergyMeterEnabled()");
        logger.traceReturn(THIS_CLASS, "preSetEnergyMeterEnabled()");
        throw new ActionNotSupportedException(MO_TYPE, "Attribute energyMeterEnabled cannot be set directly, only via action.");
    }

    private boolean moExists(String string) {
        logger.traceEnter(THIS_CLASS, "moExists()");
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(string);
        logger.traceReturn(THIS_CLASS, "moExists()");
        return null != moIterator;
    }
}

