/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.common.ParserHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.ParserFactory;
import se.ericsson.crbs.omf.mao.xml.XMLElement;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.AlarmPortData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.CabinetData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ClimateSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.EcBusData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.EcPortConnectionData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalAlarmsData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalNodeData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.HwUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PlugInUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PowerSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.RadioEquipmentData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.RadioUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemMultiCabinetData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemSingleCabinetData;

public class SupportSystemDataFinder {
    private int xmlVersion = 0;
    private final transient ParserFactory parserFactory;
    private static final Class THIS_CLASS = SupportSystemDataFinder.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)SupportSystemDataFinder.class.getName());

    public SupportSystemDataFinder(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    protected String extractFileNameFromFilePath(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        return string.substring(n + 1);
    }

    protected String extractFileDirFromFilePath(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        return string.substring(0, n + 1);
    }

    public SupportSystemData parseSupportSystemXmlFile(String string) throws IOException {
        SupportSystemData supportSystemData = null;
        String string2 = this.extractFileDirFromFilePath(string);
        String string3 = this.extractFileNameFromFilePath(string);
        Parser parser = this.parserFactory.createParser(string3, string2);
        List list = parser.getXMLelements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement = (XMLElement)iterator.next();
            if ("Format".equalsIgnoreCase(xMLElement.getType())) {
                this.setXmlVersion(SupportSystemDataFinder.parseFormatData(xMLElement));
                if (this.xmlVersion == 3) {
                    logger.traceDebug(THIS_CLASS, "parseSupportSystemXmlFile() -> XmlVersion = 3");
                } else if (this.xmlVersion == 0) {
                    throw new IOException("Invalid XML file: Unknown revision ");
                }
            }
            if ("CommonSupportSystem".equalsIgnoreCase(xMLElement.getType())) {
                supportSystemData = this.parseSupportSystemData(xMLElement);
            }
            if (!"SectorEquipment".equalsIgnoreCase(xMLElement.getType())) continue;
            supportSystemData = this.parseAndAppendSupportSystemData(supportSystemData, xMLElement);
        }
        if (supportSystemData == null) {
            throw new IOException("Invalid XML file: CommonSupportSystem is missing.");
        }
        return supportSystemData;
    }

    private void setXmlVersion(String string) {
        int n = this.revValue(string);
        if (n <= this.revValue("J")) {
            this.xmlVersion = 1;
        } else if (n > this.revValue("J") && n <= this.revValue("Z")) {
            this.xmlVersion = 2;
        } else if (n > this.revValue("Z")) {
            this.xmlVersion = 3;
        }
    }

    private int revValue(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.toUpperCase().charAt(i);
            n = n * 90 + c;
        }
        return n;
    }

    private static String parseFormatData(XMLElement xMLElement) {
        logger.traceEnter(THIS_CLASS, "parseFormatData()");
        String string = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if (!"revision".equalsIgnoreCase(attributesImpl.getQName(i))) continue;
            string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
        }
        logger.traceReturn(THIS_CLASS, "parseFormatData()");
        return string;
    }

    private SupportSystemData parseSupportSystemData(XMLElement xMLElement) throws IOException {
        Object object;
        logger.traceEnter(THIS_CLASS, "parseSupportSystemData()");
        String string = "STANDARD";
        String string2 = "NOT_APPLICABLE";
        String string3 = "NORMAL";
        String string4 = "true";
        String string5 = "true";
        String string6 = "RBS6201";
        String string7 = null;
        boolean bl = false;
        boolean bl2 = false;
        PowerSystemData powerSystemData = null;
        HwUnitData[] hwUnitDataArray = null;
        PlugInUnitData[] plugInUnitDataArray = null;
        ExternalNodeData[] externalNodeDataArray = null;
        CabinetData[] cabinetDataArray = null;
        EcBusData[] ecBusDataArray = null;
        PowerSystemData[] powerSystemDataArray = null;
        ClimateSystemData[] climateSystemDataArray = null;
        EcPortConnectionData[] ecPortConnectionDataArray = null;
        ExternalAlarmsData[] externalAlarmsDataArray = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("climateControlMode".equalsIgnoreCase(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"NORMAL");
            }
            if ("climateSystem".equalsIgnoreCase(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"STANDARD");
            }
            if ("climateRegulationSystem".equalsIgnoreCase(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"NOT_APPLICABLE");
            }
            if ("supportSystemControl".equalsIgnoreCase(attributesImpl.getQName(i))) {
                string4 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"true");
            }
            if ("autoCreateExternalNodes".equalsIgnoreCase(attributesImpl.getQName(i))) {
                string5 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"true");
            }
            if ("noOfExternalNodes".equalsIgnoreCase(attributesImpl.getQName(i))) {
                if (this.xmlVersion > 1) {
                    throw new IOException("Invalid XML file: noOfExternalNodes should not exbatteryTypeist in this version.");
                }
                string7 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("cabinetType".equalsIgnoreCase(attributesImpl.getQName(i))) {
                string6 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"RBS6201");
            }
            if ("smokeDetector".equalsIgnoreCase(attributesImpl.getQName(i))) {
                bl = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"false").equals("true");
            }
            if (!"Cabinet".equalsIgnoreCase(attributesImpl.getQName(i))) continue;
            bl = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), null).equals("true");
        }
        if (this.xmlVersion > 1) {
            string7 = "0";
        } else {
            ParserHelper.checkMandatoryAttribute((String)"noOfExternalNodes", (String)string7);
        }
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<HwUnitData> arrayList = new ArrayList<HwUnitData>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<PowerSystemData> arrayList6 = new ArrayList<PowerSystemData>();
        ArrayList<Object> arrayList7 = new ArrayList<Object>();
        ArrayList<Object> arrayList8 = new ArrayList<Object>();
        ArrayList<Object> arrayList9 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object object2;
            object = (XMLElement)iterator.next();
            String string8 = object.getType();
            logger.traceDebug(THIS_CLASS, "parseSupportSystemData() xmlChildType = " + string8);
            if ("PowerSystem".equalsIgnoreCase(string8)) {
                powerSystemData = this.parsePowerSystemData((XMLElement)object);
                bl2 |= powerSystemData.parentEsf.equalsIgnoreCase("SECOND");
                arrayList6.add(powerSystemData);
            }
            if ("HwUnit".equalsIgnoreCase(string8)) {
                object2 = this.parseHwUnit((XMLElement)object);
                arrayList.add((HwUnitData)object2);
            }
            if ("PlugInUnit".equalsIgnoreCase(string8)) {
                logger.traceDebug(THIS_CLASS, "parseSupportSystemData() xmlChild=" + object.getText());
                object2 = this.parsePlugInUnit((XMLElement)object);
                logger.traceDebug(THIS_CLASS, "parseSupportSystemData() piud.positionRef=" + ((PlugInUnitData)object2).positionRef + ", piud.unitId=" + ((PlugInUnitData)object2).unitId);
                arrayList2.add(object2);
            }
            if ("ExternalNode".equalsIgnoreCase(string8)) {
                object2 = this.parseExternalNode((XMLElement)object);
                bl2 |= ((ExternalNodeData)object2).equipmentSupportFunctionRef.equalsIgnoreCase("SECOND");
                arrayList3.add(object2);
            }
            if ("Cabinet".equalsIgnoreCase(string8)) {
                object2 = this.parseCabinet((XMLElement)object);
                arrayList4.add(object2);
            }
            if ("EcBus".equalsIgnoreCase(string8)) {
                object2 = this.parseEcBus((XMLElement)object);
                bl2 |= ((EcBusData)object2).equipmentSupportFunctionRef.equalsIgnoreCase("SECOND");
                arrayList5.add(object2);
            }
            if ("ClimateSystem".equalsIgnoreCase(string8)) {
                object2 = this.parseClimateSystem((XMLElement)object);
                bl2 |= ((ClimateSystemData)object2).parentEsf.equalsIgnoreCase("SECOND");
                arrayList7.add(object2);
            }
            if ("EcPortConnection".equalsIgnoreCase(string8)) {
                object2 = this.parseEcPortConnections((XMLElement)object);
                arrayList8.add(object2);
            }
            if (!"ExternalAlarms".equalsIgnoreCase(string8)) continue;
            object2 = this.parseExternalAlarms((XMLElement)object);
            arrayList9.add(object2);
        }
        if (!arrayList4.isEmpty()) {
            cabinetDataArray = new CabinetData[arrayList4.size()];
            cabinetDataArray = arrayList4.toArray(cabinetDataArray);
        }
        if (!arrayList5.isEmpty()) {
            ecBusDataArray = new EcBusData[arrayList5.size()];
            ecBusDataArray = arrayList5.toArray(ecBusDataArray);
        }
        if (!arrayList6.isEmpty()) {
            powerSystemDataArray = new PowerSystemData[arrayList6.size()];
            powerSystemDataArray = arrayList6.toArray(powerSystemDataArray);
        }
        if (!arrayList7.isEmpty()) {
            climateSystemDataArray = new ClimateSystemData[arrayList7.size()];
            climateSystemDataArray = arrayList7.toArray(climateSystemDataArray);
        }
        if (!arrayList.isEmpty()) {
            hwUnitDataArray = new HwUnitData[arrayList.size()];
            hwUnitDataArray = arrayList.toArray(hwUnitDataArray);
        }
        if (!arrayList2.isEmpty()) {
            plugInUnitDataArray = new PlugInUnitData[arrayList2.size()];
            plugInUnitDataArray = arrayList2.toArray(plugInUnitDataArray);
        }
        if (!arrayList3.isEmpty()) {
            externalNodeDataArray = new ExternalNodeData[arrayList3.size()];
            externalNodeDataArray = arrayList3.toArray(externalNodeDataArray);
        }
        if (!arrayList8.isEmpty()) {
            ecPortConnectionDataArray = new EcPortConnectionData[arrayList8.size()];
            ecPortConnectionDataArray = arrayList8.toArray(ecPortConnectionDataArray);
        }
        if (!arrayList9.isEmpty()) {
            externalAlarmsDataArray = new ExternalAlarmsData[arrayList9.size()];
            externalAlarmsDataArray = arrayList9.toArray(externalAlarmsDataArray);
        }
        object = this.xmlVersion > 2 && cabinetDataArray != null ? new SupportSystemData(new SupportSystemSingleCabinetData(powerSystemData, hwUnitDataArray, plugInUnitDataArray, externalNodeDataArray, string, string2, string3, ParserHelper.convertOptionBoolean((String)"supportSystemControl", (String)string4), ParserHelper.convertOptionBoolean((String)"autoCreateExternalNodes", (String)string5), string6, bl, ecPortConnectionDataArray, externalAlarmsDataArray, ParserHelper.convertIntegerAttribute((String)"noOfExternalNodes", (String)string7), this.xmlVersion), new SupportSystemMultiCabinetData(cabinetDataArray, climateSystemDataArray, ecBusDataArray, powerSystemDataArray, bl2)) : new SupportSystemData(powerSystemData, hwUnitDataArray, plugInUnitDataArray, externalNodeDataArray, string, string2, string3, ParserHelper.convertOptionBoolean((String)"supportSystemControl", (String)string4), ParserHelper.convertOptionBoolean((String)"autoCreateExternalNodes", (String)string5), string6, bl, ecPortConnectionDataArray, externalAlarmsDataArray, ParserHelper.convertIntegerAttribute((String)"noOfExternalNodes", (String)string7), this.xmlVersion);
        logger.traceReturn(THIS_CLASS, "parseSupportSystemData()");
        return object;
    }

    private SupportSystemData parseAndAppendSupportSystemData(SupportSystemData supportSystemData, XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAndAppendSupportSystemData()");
        RadioEquipmentData[] radioEquipmentDataArray = null;
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<RadioEquipmentData> arrayList = new ArrayList<RadioEquipmentData>();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getType();
            if (!"RadioEquipment".equalsIgnoreCase(string)) continue;
            RadioEquipmentData radioEquipmentData = this.parseRadioEquipment(xMLElement2);
            arrayList.add(radioEquipmentData);
        }
        if (!arrayList.isEmpty()) {
            radioEquipmentDataArray = new RadioEquipmentData[arrayList.size()];
            radioEquipmentDataArray = arrayList.toArray(radioEquipmentDataArray);
        }
        supportSystemData.append(radioEquipmentDataArray);
        logger.traceReturn(THIS_CLASS, "parseAndAppendSupportSystemData()");
        return supportSystemData;
    }

    private PowerSystemData parsePowerSystemData(XMLElement xMLElement) throws IOException {
        Object object;
        logger.traceEnter(THIS_CLASS, "parsePowerSystemData()");
        String string = "00000000";
        String string2 = "UNKNOWN";
        String string3 = "60";
        String string4 = "70";
        String string5 = "DISABLED";
        String string6 = "25";
        String string7 = "01:00";
        boolean bl = true;
        boolean bl2 = true;
        String[] stringArray = new String[]{"MARCH", "SEPTEMBER"};
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = "FIRST";
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("batteryInstallationDate".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"00000000");
            }
            if ("batteryType".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"UNKNOWN");
            }
            if ("minimumBackupTime".equals(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"60");
            }
            if ("minimumStateOfHealth".equals(attributesImpl.getQName(i))) {
                string4 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"70");
            }
            if ("testMode".equals(attributesImpl.getQName(i))) {
                string5 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"DISABLED");
            }
            if ("testStartDay".equals(attributesImpl.getQName(i))) {
                string6 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"25");
            }
            if ("testStartTime".equals(attributesImpl.getQName(i))) {
                string7 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"01:00");
            }
            if ("sharedBattery".equals(attributesImpl.getQName(i))) {
                bl = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"TRUE").equals("TRUE");
            }
            if ("multiplePowerSystem".equals(attributesImpl.getQName(i))) {
                bl2 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"TRUE").equals("TRUE");
            }
            if ("noOfPsu".equals(attributesImpl.getQName(i))) {
                if (this.xmlVersion > 1) {
                    throw new IOException("Invalid XML file: strNoOfPsu should not exist in this version.");
                }
                string8 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("noOfPdu".equals(attributesImpl.getQName(i))) {
                if (this.xmlVersion > 1) {
                    throw new IOException("Invalid XML file: strNoOfPdu should not exist in this version.");
                }
                string9 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("noOfBfu".equals(attributesImpl.getQName(i))) {
                if (this.xmlVersion > 1) {
                    throw new IOException("Invalid XML file: strNoOfBfu should not exist in this version.");
                }
                string10 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("noOfBpa".equals(attributesImpl.getQName(i))) {
                if (this.xmlVersion > 1) {
                    throw new IOException("Invalid XML file: strNoOfBpa should not exist in this version.");
                }
                string11 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if (this.xmlVersion <= 2) continue;
            if ("controlDomainRef".equals(attributesImpl.getQName(i))) {
                string12 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("powerSystemId".equals(attributesImpl.getQName(i))) {
                string13 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if (!"parentEsf".equals(attributesImpl.getQName(i))) continue;
            string14 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"FIRST");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (XMLElement)iterator.next();
            String string15 = object.getType();
            if (!"TestStartMonths".equalsIgnoreCase(string15)) continue;
            List list2 = object.getChildren();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                XMLElement xMLElement2 = (XMLElement)iterator2.next();
                String string16 = xMLElement2.getType();
                if (!"Month".equalsIgnoreCase(string16)) continue;
                String string17 = this.parseMonth(xMLElement2);
                arrayList.add(string17);
            }
        }
        if (!arrayList.isEmpty()) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        if (this.xmlVersion > 1) {
            string8 = "0";
            string9 = "0";
            string10 = "0";
            string11 = "0";
        } else {
            ParserHelper.checkMandatoryAttribute((String)"noOfPsu", (String)string8);
            ParserHelper.checkMandatoryAttribute((String)"noOfPdu", (String)string9);
            ParserHelper.checkMandatoryAttribute((String)"noOfBfu", (String)string10);
            ParserHelper.checkMandatoryAttribute((String)"noOfBpa", (String)string11);
        }
        object = this.xmlVersion > 2 ? new PowerSystemData(string, string2, bl, ParserHelper.convertIntegerAttribute((String)"minimumBackupTime", (String)string3), ParserHelper.convertIntegerAttribute((String)"minimumStateOfHealth", (String)string4), string5, ParserHelper.convertIntegerAttribute((String)"testStartDay", (String)string6), string7, stringArray, bl2, string12, string13, string14) : new PowerSystemData(string, string2, bl, ParserHelper.convertIntegerAttribute((String)"minimumBackupTime", (String)string3), ParserHelper.convertIntegerAttribute((String)"minimumStateOfHealth", (String)string4), string5, ParserHelper.convertIntegerAttribute((String)"testStartDay", (String)string6), string7, stringArray, bl2, ParserHelper.convertIntegerAttribute((String)"noOfPsu", (String)string8), ParserHelper.convertIntegerAttribute((String)"noOfPdu", (String)string9), ParserHelper.convertIntegerAttribute((String)"noOfBfu", (String)string10), ParserHelper.convertIntegerAttribute((String)"noOfBpa", (String)string11), string14);
        logger.traceReturn(THIS_CLASS, "parsePowerSystemData()");
        return object;
    }

    private String parseMonth(XMLElement xMLElement) throws IOException {
        String string = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if (!"name".equals(attributesImpl.getQName(i))) continue;
            string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
        }
        return string;
    }

    private HwUnitData parseHwUnit(XMLElement xMLElement) throws IOException {
        Object object;
        int n;
        logger.traceEnter(THIS_CLASS, "parseHwUnit()");
        String string = null;
        AlarmPortData[] alarmPortDataArray = null;
        EcPortConnectionData[] ecPortConnectionDataArray = null;
        String string2 = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (n = 0; n < attributesImpl.getLength(); ++n) {
            if (!"unitType".equals(attributesImpl.getQName(n))) continue;
            string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(n));
        }
        ParserHelper.checkMandatoryAttribute((String)"unitType", string);
        if (this.xmlVersion > 2) {
            for (n = 0; n < attributesImpl.getLength(); ++n) {
                if (!"positionRef".equals(attributesImpl.getQName(n))) continue;
                string2 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(n));
            }
        }
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<AlarmPortData> arrayList = new ArrayList<AlarmPortData>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object object2;
            object = (XMLElement)iterator.next();
            String string3 = object.getType();
            if ("AlarmPort".equalsIgnoreCase(string3)) {
                object2 = this.parseAlarmPort((XMLElement)object);
                arrayList.add((AlarmPortData)object2);
            }
            if (!"EcPort".equalsIgnoreCase(string3)) continue;
            object2 = this.parseEcPortConnections((XMLElement)object);
            arrayList2.add(object2);
        }
        if (!arrayList.isEmpty()) {
            alarmPortDataArray = new AlarmPortData[arrayList.size()];
            alarmPortDataArray = arrayList.toArray(alarmPortDataArray);
        }
        if (!arrayList2.isEmpty()) {
            ecPortConnectionDataArray = new EcPortConnectionData[arrayList2.size()];
            ecPortConnectionDataArray = arrayList2.toArray(ecPortConnectionDataArray);
        }
        object = this.xmlVersion > 2 ? new HwUnitData(string, alarmPortDataArray, ecPortConnectionDataArray, string2) : new HwUnitData(string, alarmPortDataArray, ecPortConnectionDataArray);
        logger.traceReturn(THIS_CLASS, "parseHwUnit()");
        return object;
    }

    private RadioEquipmentData parseRadioEquipment(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseRadioEquipment()");
        RadioUnitData[] radioUnitDataArray = null;
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<RadioUnitData> arrayList = new ArrayList<RadioUnitData>();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getType();
            if (!"RadioUnit".equalsIgnoreCase(string)) continue;
            RadioUnitData radioUnitData = this.parseRadioUnit(xMLElement2);
            arrayList.add(radioUnitData);
        }
        if (!arrayList.isEmpty()) {
            radioUnitDataArray = new RadioUnitData[arrayList.size()];
            radioUnitDataArray = arrayList.toArray(radioUnitDataArray);
        }
        logger.traceReturn(THIS_CLASS, "parseRadioEquipment()");
        return new RadioEquipmentData(radioUnitDataArray);
    }

    private RadioUnitData parseRadioUnit(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseRadioUnit()");
        String string = null;
        AlarmPortData[] alarmPortDataArray = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if (!"unitId".equals(attributesImpl.getQName(i))) continue;
            string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
        }
        ParserHelper.checkMandatoryAttribute((String)"unitId", string);
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<AlarmPortData> arrayList = new ArrayList<AlarmPortData>();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string2 = xMLElement2.getType();
            if (!"AlarmPort".equalsIgnoreCase(string2)) continue;
            AlarmPortData alarmPortData = this.parseAlarmPort(xMLElement2);
            arrayList.add(alarmPortData);
        }
        if (!arrayList.isEmpty()) {
            alarmPortDataArray = new AlarmPortData[arrayList.size()];
            alarmPortDataArray = arrayList.toArray(alarmPortDataArray);
        }
        logger.traceReturn(THIS_CLASS, "parseRadioUnit()");
        return new RadioUnitData(string, alarmPortDataArray);
    }

    private AlarmPortData parseAlarmPort(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAlarmPort()");
        String string = null;
        String string2 = "";
        String string3 = "TRUE";
        String string4 = "MINOR";
        String string5 = "550";
        String string6 = "LOCKED";
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("alarmPortId".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("alarmSlogan".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"");
            }
            if ("normallyOpen".equals(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"TRUE");
            }
            if ("perceivedSeverity".equals(attributesImpl.getQName(i))) {
                string4 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"MINOR");
            }
            if ("probableCause".equals(attributesImpl.getQName(i))) {
                string5 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"550");
            }
            if (!"administrativeState".equals(attributesImpl.getQName(i))) continue;
            string6 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"LOCKED");
        }
        ParserHelper.checkMandatoryAttribute((String)"alarmPortId", string);
        logger.traceReturn(THIS_CLASS, "parseAlarmPort()");
        return new AlarmPortData(string, string2, ParserHelper.convertOptionBoolean((String)"normallyOpen", (String)string3), string4, ParserHelper.convertIntegerAttribute((String)"probableCause", (String)string5), string6);
    }

    private EcPortConnectionData parseEcPortConnections(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseEcPortConnections()");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("unitRef".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("ecPortId".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("hubPosition".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i).trim());
            }
            if ("cascadingOrder".equals(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i).trim());
            }
            if (this.xmlVersion <= 2 || !"ecBusRef".equals(attributesImpl.getQName(i))) continue;
            string4 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
        }
        ParserHelper.checkMandatoryAttribute((String)"unitRef", string);
        if (string2 == null && string3 == null) {
            throw new IOException("Invalid XML file, neither hubPosition nor cascadingOrder is set on EcPort.");
        }
        EcPortConnectionData ecPortConnectionData = this.xmlVersion > 2 ? new EcPortConnectionData(string, string2, string3, string4) : new EcPortConnectionData(string, string2, string3);
        logger.traceReturn(THIS_CLASS, "parseEcPortConnections()");
        return ecPortConnectionData;
    }

    private PlugInUnitData parsePlugInUnit(XMLElement xMLElement) throws IOException {
        Object object;
        int n;
        logger.traceEnter(THIS_CLASS, "parsePlugInUnit()");
        String string = null;
        EcPortConnectionData[] ecPortConnectionDataArray = null;
        String string2 = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (n = 0; n < attributesImpl.getLength(); ++n) {
            logger.traceDebug(THIS_CLASS, "parsePlugInUnit() attributes.getQName(index)=" + attributesImpl.getQName(n));
            logger.traceDebug(THIS_CLASS, "parsePlugInUnit() supportSystemConfigurationDefinitions.UNIT_ID=unitId");
            if (!"unitId".equals(attributesImpl.getQName(n))) continue;
            string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(n));
            logger.traceDebug(THIS_CLASS, "parsePlugInUnit() unitId=" + string);
        }
        ParserHelper.checkMandatoryAttribute((String)"unitType", string);
        if (this.xmlVersion > 2) {
            for (n = 0; n < attributesImpl.getLength(); ++n) {
                if (!"positionRef".equals(attributesImpl.getQName(n))) continue;
                string2 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(n));
            }
        }
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<EcPortConnectionData> arrayList = new ArrayList<EcPortConnectionData>();
        while (iterator.hasNext()) {
            object = (XMLElement)iterator.next();
            String string3 = object.getType();
            if (!"EcPort".equalsIgnoreCase(string3)) continue;
            EcPortConnectionData ecPortConnectionData = this.parseEcPortConnections((XMLElement)object);
            arrayList.add(ecPortConnectionData);
        }
        if (!arrayList.isEmpty()) {
            ecPortConnectionDataArray = new EcPortConnectionData[arrayList.size()];
            ecPortConnectionDataArray = arrayList.toArray(ecPortConnectionDataArray);
        }
        logger.traceDebug(THIS_CLASS, "parsePlugInUnit() unitId=" + string);
        object = this.xmlVersion > 2 ? new PlugInUnitData(string, ecPortConnectionDataArray, string2) : new PlugInUnitData(string, ecPortConnectionDataArray);
        logger.traceReturn(THIS_CLASS, "parsePlugInUnit()");
        return object;
    }

    private ExternalNodeData parseExternalNode(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseExternalNode()");
        String string = null;
        EcPortConnectionData[] ecPortConnectionDataArray = null;
        String string2 = "FIRST";
        String string3 = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            logger.traceDebug(THIS_CLASS, "parseExternalNode() attribute: " + attributesImpl.getQName(i) + " = " + attributesImpl.getValue(i));
            if ("externalNodeId".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if ("equipmentSupportFunctionRef".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"FIRST");
                logger.traceDebug(THIS_CLASS, "parseExternalNode() equipmentSupportFunctionRef = " + string2);
                continue;
            }
            if (!"inciConnectorRef".equals(attributesImpl.getQName(i))) continue;
            string3 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            logger.traceDebug(THIS_CLASS, "parseExternalNode() inciConnectorRef = " + string3);
        }
        ParserHelper.checkMandatoryAttribute((String)"externalNodeId", string);
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<EcPortConnectionData> arrayList = new ArrayList<EcPortConnectionData>();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string4 = xMLElement2.getType();
            if (!"EcPort".equalsIgnoreCase(string4)) continue;
            EcPortConnectionData ecPortConnectionData = this.parseEcPortConnections(xMLElement2);
            arrayList.add(ecPortConnectionData);
        }
        if (!arrayList.isEmpty()) {
            ecPortConnectionDataArray = new EcPortConnectionData[arrayList.size()];
            ecPortConnectionDataArray = arrayList.toArray(ecPortConnectionDataArray);
        }
        logger.traceReturn(THIS_CLASS, "parseExternalNode()");
        return new ExternalNodeData(string, ecPortConnectionDataArray, string2, string3);
    }

    private EcBusData parseEcBus(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseEcBus()");
        String string = null;
        String string2 = null;
        String string3 = "";
        String string4 = "FIRST";
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("ecBusId".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("ecBusConnectorRef".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if ("connectionType".equals(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if (!"equipmentSupportFunctionRef".equals(attributesImpl.getQName(i))) continue;
            string4 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"FIRST");
        }
        ParserHelper.checkMandatoryAttribute((String)"ecBusId", string);
        ParserHelper.checkMandatoryAttribute((String)"ecBusConnectorRef", string2);
        logger.traceReturn(THIS_CLASS, "parseEcBus()");
        return new EcBusData(string, string2, string3, string4);
    }

    private ExternalAlarmsData parseExternalAlarms(XMLElement xMLElement) throws IOException {
        AlarmPortData[] alarmPortDataArray;
        logger.traceEnter(THIS_CLASS, "parseExternalAlarms()");
        String string = null;
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if (!"unitId".equals(attributesImpl.getQName(i))) continue;
            string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
        }
        ParserHelper.checkMandatoryAttribute((String)"unitId", string);
        List list = xMLElement.getChildren();
        Iterator iterator = list.iterator();
        ArrayList<AlarmPortData> arrayList = new ArrayList<AlarmPortData>();
        while (iterator.hasNext()) {
            alarmPortDataArray = (AlarmPortData[])iterator.next();
            String string2 = alarmPortDataArray.getType();
            if (!"AlarmPort".equalsIgnoreCase(string2)) continue;
            AlarmPortData alarmPortData = this.parseAlarmPort((XMLElement)alarmPortDataArray);
            arrayList.add(alarmPortData);
        }
        alarmPortDataArray = new AlarmPortData[arrayList.size()];
        alarmPortDataArray = arrayList.toArray(alarmPortDataArray);
        logger.traceReturn(THIS_CLASS, "parseExternalAlarms()");
        return new ExternalAlarmsData(string, alarmPortDataArray);
    }

    private CabinetData parseCabinet(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseCabinet()");
        String string = null;
        String string2 = "STANDARD";
        String string3 = "NOT_APPLICABLE";
        boolean bl = false;
        String string4 = "";
        String string5 = "";
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("cabinetId".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if ("climateSystem".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if ("climateRegulationSystem".equals(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if ("smokeDetector".equals(attributesImpl.getQName(i))) {
                bl = Boolean.valueOf(StringHelper.emptyStringToNull((String)attributesImpl.getValue(i)));
                continue;
            }
            if ("userLabel".equals(attributesImpl.getQName(i))) {
                string4 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if (!"sharedCabinetIdentifier".equals(attributesImpl.getQName(i))) continue;
            string5 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
        }
        ParserHelper.checkMandatoryAttribute((String)"cabinetId", string);
        logger.traceReturn(THIS_CLASS, "parseCabinet()");
        return new CabinetData(string, string2, string3, bl, string4, string5);
    }

    private ClimateSystemData parseClimateSystem(XMLElement xMLElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseClimateSystem()");
        String string = "NORMAL";
        String string2 = null;
        String string3 = null;
        String string4 = "FIRST";
        AttributesImpl attributesImpl = xMLElement.getAttributes();
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if ("climateSystemId".equals(attributesImpl.getQName(i))) {
                string2 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if ("climateControlMode".equals(attributesImpl.getQName(i))) {
                string = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
                continue;
            }
            if ("controlDomainRef".equals(attributesImpl.getQName(i))) {
                string3 = StringHelper.emptyStringToNull((String)attributesImpl.getValue(i));
            }
            if (!"parentEsf".equals(attributesImpl.getQName(i))) continue;
            string4 = StringHelper.emptyStringToDefault((String)attributesImpl.getValue(i), (String)"FIRST");
        }
        ParserHelper.checkMandatoryAttribute((String)"climateSystemId", string2);
        logger.traceReturn(THIS_CLASS, "parseClimateSystem()");
        return new ClimateSystemData(string2, string, string3, string4);
    }
}

