/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;

public class FunctionalMoHelper {
    private static final Class THIS_CLASS = FunctionalMoHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final String PD_MO_TYPE = "PowerDistribution";
    private static final String PS_MO_TYPE = "PowerSupply";
    private static final String BB_MO_TYPE = "BatteryBackup";
    private static final String ECPORT_MO_TYPE = "EcPort";
    private static final String CLIMATE_MO_TYPE = "Climate";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF = "equipmentSupportFunctionRef";
    private static final String ATTRIBUTE_ECBUSREF = "ecBusRef";
    private static final int MAX_UNDERVOLTAGE_DISCONNECT = -400;
    private static final int MIN_UNDERVOLTAGE_DISCONNECT = -480;
    private static final int numOfSocValues = 101;
    private static final int[] socValue = new int[]{4416, 4430, 4445, 4459, 4474, 4488, 4500, 4512, 4524, 4536, 4548, 4560, 4572, 4584, 4596, 4608, 4615, 4622, 4630, 4637, 4644, 4651, 4658, 4666, 4673, 4680, 4687, 4694, 4702, 4709, 4716, 4723, 4730, 4738, 4745, 4752, 4759, 4766, 4774, 4781, 4788, 4794, 4800, 4807, 4813, 4819, 4825, 4830, 4836, 4841, 4847, 4851, 4856, 4860, 4865, 4869, 4875, 4880, 4885, 4891, 4896, 4901, 4906, 4910, 4915, 4920, 4925, 4931, 4936, 4941, 4946, 4952, 4957, 4962, 4968, 4973, 4977, 4980, 4984, 4988, 4992, 4994, 4997, 4999, 5002, 5004, 5006, 5009, 5011, 5014, 5016, 5018, 5021, 5023, 5026, 5028, 5030, 5033, 5035, 5038, 5040};

    public FunctionalMoHelper() {
        logger.traceEnter(THIS_CLASS, "FunctionalMoHelper() - Constructor");
        logger.traceReturn(THIS_CLASS, "FunctionalMoHelper() - Constructor");
    }

    public void validateFunctionalMOWhenPreSetControlDomainRef(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator, GenericMaoContext genericMaoContext) throws SupportSystemConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateFunctionalMOWhenPreSetControlDomainRef()");
        if (EquipmentSupportFunctionHelper.isDoubleRole(genericMaoContext)) {
            ManagedObject managedObject3 = managedObject.getParent();
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals(PD_MO_TYPE) && !managedObjectArray[i].getType().equals(PS_MO_TYPE) && !managedObjectArray[i].getType().equals(BB_MO_TYPE) && !managedObjectArray[i].getType().equals(CLIMATE_MO_TYPE) || managedObject3 == managedObjectArray[i].getParent()) continue;
                throw new SupportSystemConfigurationFailedException("ControlDomainRef is wrong", "Functional MOs under each MO EquipmentSupportFunction refer to the same MO Cabinet");
            }
            logger.traceReturn(THIS_CLASS, "validateFunctionalMOWhenPreSetControlDomainRef()");
        }
    }

    public void validateEsfRefChain(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws SupportSystemConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateEsfRefChain()");
        if (managedObject2 != null && managedObject2.getType().equals(CABINET_MO_TYPE)) {
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                MoIterator moIterator = managedObjectArray[i].getChildren();
                while (moIterator.hasMoreElements()) {
                    ManagedObject managedObject3;
                    ManagedObject managedObject4;
                    ManagedObject managedObject5 = moIterator.nextMo();
                    if (!ECPORT_MO_TYPE.equals(managedObject5.getType()) || (managedObject4 = (ManagedObject)managedObject5.getAttribute(ATTRIBUTE_ECBUSREF, coordinator)) == null || (managedObject3 = (ManagedObject)managedObject4.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) == null || managedObject == managedObject3) continue;
                    throw new SupportSystemConfigurationFailedException("controlDomainRef is faulty", "There is a conflicting reference chain to EquipmentSupportFunction.");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "validateEsfRefChain()");
    }

    public Integer getSocFromVoltage(Integer n) {
        int n2 = n;
        n2 = (int)(-1.0 * (double)n2);
        logger.traceEnter(THIS_CLASS, "getSocFromVoltage() inVolt: " + n2);
        int n3 = 0;
        for (int i = 0; i < 101; ++i) {
            n3 = (int)Math.round((double)socValue[i] / 10.0);
            if (n2 > n3) continue;
            Integer n4 = new Integer(i);
            logger.traceReturn(THIS_CLASS, "getSocFromVoltage() returning (1) Soc: " + n4.toString());
            return n4;
        }
        Integer n5 = new Integer(100);
        logger.traceReturn(THIS_CLASS, "getSocFromVoltage() returning (2) Soc: " + n5.toString());
        return n5;
    }

    public Integer getVoltageFromSoc(Integer n) {
        int n2 = n;
        logger.traceEnter(THIS_CLASS, "getVoltageFromSoc() inSoc: " + n2);
        double d = Math.round((double)socValue[n2] / 10.0);
        d *= -1.0;
        if (d > -400.0) {
            d = -400.0;
            logger.info(this.getClass(), "Volt set to max undervoltage disconnect -400");
        }
        if (d < -480.0) {
            d = -480.0;
            logger.info(this.getClass(), "Volt set to min undervoltage disconnect -480");
        }
        Integer n3 = new Integer((int)d);
        logger.traceReturn(THIS_CLASS, "getVoltageFromSoc() returning Volt: " + n3.toString());
        return n3;
    }
}

