/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemData;

public class PlugInUnitHelper {
    private static final Class THIS_CLASS = PlugInUnitHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aFactoryMgr;

    public PlugInUnitHelper(GenericMaoContext genericMaoContext) {
        logger.traceEnter(THIS_CLASS, "PlugInUnitHelper()");
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = genericMaoContext.getMoFactoryMgrWrapper();
        logger.traceReturn(THIS_CLASS, "PlugInUnitHelper()");
    }

    public void prepareChildrenForAllPlugInUnits(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "prepareChildrenForAllPlugInUnits()");
        MoIterator moIterator = this.aMoRepository.lookupType("PlugInUnit");
        while (moIterator.hasMoreElements()) {
            PlugInUnitMo plugInUnitMo = (PlugInUnitMo)moIterator.nextMo();
            try {
                this.preparePiuChildren(coordinator, plugInUnitMo);
            }
            catch (MoAccessException moAccessException) {
                String string = "MoAccessException caught when creating childs for: " + plugInUnitMo.getLocalDistinguishedName() + "Original exception:" + moAccessException.getVariablesAsString();
                logger.traceAbnormal(THIS_CLASS, string);
            }
        }
        logger.traceReturn(THIS_CLASS, "prepareChildrenForAllPlugInUnits()");
    }

    private void findPlugInUnitToAddPositionRef(String string, String string2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findPlugInUnitToAddPositionRef()");
        MoIterator moIterator = this.aMoRepository.lookupType("PlugInUnit");
        while (moIterator.hasMoreElements()) {
            PlugInUnitMo plugInUnitMo = (PlugInUnitMo)moIterator.nextMo();
            String string3 = plugInUnitMo.getFullDistinguishedName();
            if (!this.makeId(string3).equalsIgnoreCase(this.makeId(string))) continue;
            ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(string2));
            if (managedObject == null) {
                logger.traceDebug(THIS_CLASS, "Cabinet MO: Failed to get attribute reservedBy");
                String string4 = "Failed to get Cabinet with id = " + string2;
                throw new SupportSystemConfigurationFailedException("Failed to get Cabinet. ", string4);
            }
            plugInUnitMo.setAttribute("positionRef", (Object)managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "findPlugInUnitToAddPositionRef()");
    }

    public void addPositionRef(SupportSystemData supportSystemData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addPositionRef()");
        for (int i = 0; i < supportSystemData.plugInUnits.length; ++i) {
            if (supportSystemData.plugInUnits[i].positionRef == null) {
                logger.traceDebug(THIS_CLASS, "PlugInUnit MO. For Multi Cabinet configuration positionRef is mandatory.");
                throw new SupportSystemConfigurationFailedException("For Multi Cabinet configuration positionRef is mandatory.", "PlugInUnit MO.");
            }
            this.findPlugInUnitToAddPositionRef(supportSystemData.plugInUnits[i].unitId, supportSystemData.plugInUnits[i].positionRef, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "addPositionRef()");
    }

    private void preparePiuChildren(Coordinator coordinator, PlugInUnitMo plugInUnitMo) throws MoAccessException {
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)plugInUnitMo.getPiuType(coordinator);
        if (piuTypeAccess == null) {
            logger.traceDebug(THIS_CLASS, "No PiuType specified, can not autoCreate children.");
        } else {
            Struct[] structArray = piuTypeAccess.getMoConfiguration(coordinator);
            if (structArray == null) {
                logger.traceDebug(THIS_CLASS, "No Mo Configuration list found. No autocreation will be performed.");
            } else {
                for (int i = 0; i < structArray.length; ++i) {
                    String string = piuTypeAccess.getMoConfigurationHardwaresSubParentLDN(structArray[i]);
                    String string2 = piuTypeAccess.getMoConfigurationHardwareMoTypeName(structArray[i]);
                    String string3 = piuTypeAccess.getMoConfigurationMoIdentity(structArray[i]);
                    String string4 = "".equals(string) ? plugInUnitMo.getLocalDistinguishedName() : plugInUnitMo.getLocalDistinguishedName() + "," + string;
                    ManagedObject managedObject = this.aMoRepository.lookup(string4);
                    if (managedObject == null) {
                        logger.traceDebug(THIS_CLASS, "WARNING: MO Parent defined in PiuType not found, parent:" + string4);
                        continue;
                    }
                    logger.traceDebug(THIS_CLASS, "Creating MO of type: " + string2);
                    MoFactory moFactory = this.aFactoryMgr.lookup(string2);
                    if (moFactory == null) {
                        logger.traceDebug(THIS_CLASS, "WARNING:MoFactory not found " + string2);
                        continue;
                    }
                    ManagedObject managedObject2 = this.aMoRepository.lookup(string4 + "," + string2 + "=" + string3);
                    if (managedObject2 != null) continue;
                    AttrListImpl attrListImpl = new AttrListImpl(0);
                    moFactory.createMo(managedObject, (AttrList)attrListImpl, string3, null, coordinator);
                }
            }
        }
    }

    private String makeId(String string) {
        return string.substring(string.length() - 1);
    }

    public void updatePlugInUnitsCabinetReference(String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "updatePlugInUnitsCabinetReference()");
        if (string == null) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Reference to cabinet is null.");
        }
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(string));
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO.", "Could not find cabinet MO.");
        }
        MoIterator moIterator = this.aMoRepository.lookupType("PlugInUnit");
        try {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                managedObject2.setAttribute("positionRef", (Object)managedObject, coordinator);
            }
        }
        catch (Exception exception) {
            throw new SupportSystemConfigurationFailedException("PlugInUnit MO.", "Failed to set positionRef attribute");
        }
        logger.traceReturn(THIS_CLASS, "updatePlugInUnitsCabinetReference()");
    }
}

