/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import BasicConfig.Filter;
import BasicConfig.MGRef;
import BasicConfig.MOAssociation;
import BasicConfig.MORef;
import BasicConfig.MOidpair;
import BasicConfig.NameValueSeqHolder;
import BasicConfig.NotDefined;
import BasicConfig.ProcessingFailure;
import BasicConfig.SecurityViolation;
import BasicConfig.Session;
import ConfigExtended.MOInfo;
import ConfigExtended.MOInfoSeqHolder;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CelloNameValue;
import se.ericsson.cello.neal.cm.CelloTransaction;
import se.ericsson.cello.neal.cm.CelloValue;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.CmSubscriptionFactory;
import se.ericsson.cello.neal.cm.EasyNaming;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueCache;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.cello.neal.internal.ServiceContext;

class CelloManagedObject
implements Mo {
    private ServiceContext serviceContext;
    private String myDn;
    private MOInfo myMoInfo;
    private MOidpair myMoHandle;
    private NameValueCache myNameValueCache = new NameValueCache();
    private static final int NON_EXISTENT_ITER = -1;
    private static final int ITERATOR_BATCH_SIZE = 500;
    private static final Filter EMPTY_FILTER = new Filter("", "");
    private MOidpair _emptyMoId;

    CelloManagedObject(ServiceContext serviceContext, String string) {
        this.serviceContext = serviceContext;
        this.myDn = EasyNaming.extractLocalDn(string);
        this.myMoInfo = null;
    }

    CelloManagedObject(ServiceContext serviceContext, String string, BasicConfig.NameValue[] nameValueArray) {
        this.serviceContext = serviceContext;
        this.myDn = EasyNaming.extractLocalDn(string);
        this.myMoInfo = null;
        if (this.getNode().getCmService().isCacheOn() && nameValueArray != null) {
            this.myNameValueCache.update(nameValueArray, serviceContext);
        }
    }

    CelloManagedObject(ServiceContext serviceContext, MOInfo mOInfo) {
        this.serviceContext = serviceContext;
        this.myDn = null;
        this.myMoInfo = mOInfo;
    }

    private MOInfo getMoInfoFromNode() {
        MOInfo mOInfo = null;
        try {
            mOInfo = this.serviceContext.getConfigurationExtended().get_MO_info_by_name(this.getLdn(), null);
        }
        catch (Exception exception) {
            mOInfo = new MOInfo();
            mOInfo.localDN = this.getLdn();
            mOInfo.type = this.getType();
            mOInfo.prefix = exception.toString();
        }
        return mOInfo;
    }

    public String getType() {
        if (this.myDn == null) {
            return this.myMoInfo.type;
        }
        return EasyNaming.extractType(this.getLdn());
    }

    public String getMibPrefix() {
        if (this.myMoInfo == null) {
            this.myMoInfo = this.getMoInfoFromNode();
        }
        return this.myMoInfo.prefix;
    }

    public String getName() {
        return EasyNaming.extractIdentity(this.getLdn());
    }

    public String getFdn() {
        return EasyNaming.makeFdn(this.getMibPrefix(), this.getLdn());
    }

    public String getLdn() {
        if (this.myDn == null) {
            return this.myMoInfo.localDN;
        }
        return this.myDn;
    }

    public boolean exists() {
        try {
            MOInfo mOInfo;
            this.myMoInfo = mOInfo = this.serviceContext.getConfigurationExtended().get_MO_info_by_name(this.getLdn(), null);
            this.myDn = null;
            return true;
        }
        catch (NotDefined notDefined) {
            return false;
        }
        catch (SecurityViolation securityViolation) {
            return false;
        }
        catch (ProcessingFailure processingFailure) {
            return false;
        }
    }

    public Mo getParent(Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultReadTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            CelloManagedObject celloManagedObject = null;
            if (!((Object)this.serviceContext.getNode().getCmService().getRootMo()).equals(this)) {
                MOInfo mOInfo = this.serviceContext.getConfigurationExtended().get_MO_parent(this.getLdn(), ((CelloTransaction)transaction2).getBasicConfigSession());
                celloManagedObject = new CelloManagedObject(this.serviceContext, mOInfo);
            }
            CelloTransaction.commitDefaultReadTx(transaction2, transaction);
            return celloManagedObject;
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException((UserException)((Object)processingFailure));
        }
        catch (UserException userException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(userException);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw systemException;
        }
    }

    public Mo createChild(String string, String string2, NameValue[] nameValueArray, Transaction transaction) {
        return this.createChild(string, string2, null, nameValueArray, transaction);
    }

    public Mo createChild(String string, String string2, Mo mo, NameValue[] nameValueArray, Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultWriteTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            MOidpair mOidpair = this.getMoHandle();
            BasicConfig.NameValue[] nameValueArray2 = this.createNameValueArray(nameValueArray);
            MOidpair mOidpair2 = null;
            mOidpair2 = mo == null ? this.getEmptyMoId() : ((CelloManagedObject)mo).getMoHandle();
            MORef mORef = this.serviceContext.getConfigurationExtended().basic_create_MO(string, string2, mOidpair, mOidpair2, nameValueArray2, new MOAssociation[0], ((CelloTransaction)transaction2).getBasicConfigSession());
            MOInfo mOInfo = this.serviceContext.getConfigurationExtended().get_MO_info_by_id(mORef.oid, ((CelloTransaction)transaction2).getBasicConfigSession());
            CelloTransaction.commitDefaultWriteTx(transaction2, transaction);
            return new CelloManagedObject(this.serviceContext, mOInfo);
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException((UserException)((Object)processingFailure));
        }
        catch (UserException userException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(userException);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw systemException;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Mo)) {
            return false;
        }
        Mo mo = (Mo)object;
        if (!this.getLdn().equals(mo.getLdn())) {
            return false;
        }
        boolean bl = ((Object)this.getNode()).equals(mo.getNode());
        return bl;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Mo mo = (Mo)object;
        int n = this.getNode().compareTo(mo.getNode());
        if (n != 0) {
            return n;
        }
        return this.getLdn().compareTo(mo.getLdn());
    }

    public int hashCode() {
        return this.getLdn().hashCode();
    }

    public String toString() {
        return this.getFdn();
    }

    public Node getNode() {
        return this.serviceContext.getNode();
    }

    public Mo[] getChildren(Transaction transaction) {
        return this.getChildren(EMPTY_FILTER, Scope.ONE_LEVEL, transaction);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Transaction var1_1) {
        block13: {
            block12: {
                var2_2 = CelloTransaction.startDefaultReadTx(var1_1, this.serviceContext.getConfigurationExtended());
                var3_3 = -1;
                try {
                    try {
                        var4_4 = ((CelloTransaction)var2_2).getBasicConfigSession();
                        var3_3 = this.serviceContext.getConfigurationExtended().get_MO_containment(this.getLdn(), Scope.ONE_LEVEL.getScope(), CelloManagedObject.EMPTY_FILTER, var4_4);
                        var5_8 = new MOInfoSeqHolder();
                        if (this.serviceContext.getConfigurationExtended().next_MO_info(var3_3, 1, var4_4, var5_8)) {
                            var6_9 = var5_8.value.length > 0;
                            var8_11 = null;
                            break block12;
                        }
                        var6_10 = false;
                        break block13;
                    }
                    catch (ProcessingFailure var4_5) {
                        CelloTransaction.rollbackDefaultReadTx(var2_2, var1_1);
                        throw new CmException((UserException)var4_5);
                    }
                    catch (UserException var4_6) {
                        CelloTransaction.rollbackDefaultReadTx(var2_2, var1_1);
                        throw new CmException(var4_6);
                    }
                    catch (SystemException var4_7) {
                        CelloTransaction.rollbackDefaultReadTx(var2_2, var1_1);
                        throw var4_7;
                    }
                }
                catch (Throwable var7_17) {
                    var8_13 = null;
                    try {
                        if (var3_3 == -1) throw var7_17;
                        this.serviceContext.getConfigurationExtended().delete_MO_info_iter(var3_3, ((CelloTransaction)var2_2).getBasicConfigSession());
                        throw var7_17;
                    }
                    catch (Exception var9_16) {
                        throw var7_17;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [9 : 172->202)] { 
lbl36:
            // 1 sources

            if (var3_3 == -1) return var6_9;
            this.serviceContext.getConfigurationExtended().delete_MO_info_iter(var3_3, ((CelloTransaction)var2_2).getBasicConfigSession());
            return var6_9;
lbl39:
            // 1 sources

            catch (Exception var9_14) {
                // empty catch block
            }
            return var6_9;
        }
        var8_12 = null;
        try {}
        catch (Exception var9_15) {
            // empty catch block
            return var6_10;
        }
        if (var3_3 == -1) return var6_10;
        this.serviceContext.getConfigurationExtended().delete_MO_info_iter(var3_3, ((CelloTransaction)var2_2).getBasicConfigSession());
        return var6_10;
    }

    public Mo[] getChildren(String string, String string2, Scope scope, Transaction transaction) {
        return this.getChildren(new Filter(string, string2), scope, transaction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Mo[] getChildren(Filter filter, Scope scope, Transaction transaction) {
        Mo[] moArray;
        Transaction transaction2 = CelloTransaction.startDefaultReadTx(transaction, this.serviceContext.getConfigurationExtended());
        int n = -1;
        try {
            try {
                int n2;
                Session session = ((CelloTransaction)transaction2).getBasicConfigSession();
                n = this.serviceContext.getConfigurationExtended().get_MO_containment(this.getLdn(), scope.getScope(), filter, session);
                Vector<CelloManagedObject> vector = new Vector<CelloManagedObject>();
                MOInfoSeqHolder mOInfoSeqHolder = new MOInfoSeqHolder();
                while (this.serviceContext.getConfigurationExtended().next_MO_info(n, 500, session, mOInfoSeqHolder)) {
                    for (n2 = 0; n2 < mOInfoSeqHolder.value.length; ++n2) {
                        if (mOInfoSeqHolder.value[n2].localDN.equals(this.getLdn())) continue;
                        vector.addElement(new CelloManagedObject(this.serviceContext, mOInfoSeqHolder.value[n2]));
                    }
                }
                for (n2 = 0; n2 < mOInfoSeqHolder.value.length; ++n2) {
                    if (mOInfoSeqHolder.value[n2].localDN.equals(this.getLdn())) continue;
                    vector.addElement(new CelloManagedObject(this.serviceContext, mOInfoSeqHolder.value[n2]));
                }
                n = -1;
                Mo[] moArray2 = new CelloManagedObject[vector.size()];
                vector.toArray(moArray2);
                CelloTransaction.commitDefaultReadTx(transaction2, transaction);
                moArray = moArray2;
                Object var13_15 = null;
            }
            catch (ProcessingFailure processingFailure) {
                CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
                throw new CmException((UserException)((Object)processingFailure));
            }
            catch (UserException userException) {
                CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
                throw new CmException(userException);
            }
            catch (SystemException systemException) {
                CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
                throw systemException;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                if (n == -1) throw throwable;
                this.serviceContext.getConfigurationExtended().delete_MO_info_iter(n, ((CelloTransaction)transaction2).getBasicConfigSession());
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return moArray;
        }
        if (n == -1) return moArray;
        this.serviceContext.getConfigurationExtended().delete_MO_info_iter(n, ((CelloTransaction)transaction2).getBasicConfigSession());
        return moArray;
    }

    public NameValue getAttribute(String string, Transaction transaction) {
        String[] stringArray = new String[]{string};
        return this.getAttributes(stringArray, transaction)[0];
    }

    public void resetCache() {
        this.myNameValueCache.reset();
        this.myMoInfo = this.getMoInfoFromNode();
        this.myDn = null;
    }

    public NameValue[] getAttributes(String[] stringArray, Transaction transaction) {
        if (this.getNode().getCmService().isCacheOn() && this.myNameValueCache.exists(stringArray)) {
            return this.myNameValueCache.pick(stringArray);
        }
        Transaction transaction2 = CelloTransaction.startDefaultReadTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            MOidpair mOidpair = this.getMoHandle();
            NameValueSeqHolder nameValueSeqHolder = new NameValueSeqHolder();
            this.serviceContext.getConfigurationAdapter().basic_get_MO_attributes(mOidpair, stringArray, nameValueSeqHolder, ((CelloTransaction)transaction2).getBasicConfigSession());
            NameValue[] nameValueArray = new CelloNameValue[nameValueSeqHolder.value.length];
            for (int i = 0; i < nameValueArray.length; ++i) {
                nameValueArray[i] = new CelloNameValue(nameValueSeqHolder.value[i], this.serviceContext);
            }
            CelloTransaction.commitDefaultReadTx(transaction2, transaction);
            if (this.getNode().getCmService().isCacheOn()) {
                this.myNameValueCache.update(nameValueArray);
            }
            return nameValueArray;
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException((UserException)((Object)processingFailure));
        }
        catch (UserException userException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(userException);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw systemException;
        }
    }

    public void setAttribute(NameValue nameValue, Transaction transaction) {
        NameValue[] nameValueArray = new CelloNameValue[]{(CelloNameValue)nameValue};
        this.setAttributes(nameValueArray, transaction);
    }

    public void setAttributes(NameValue[] nameValueArray, Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultWriteTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            MOidpair mOidpair = this.getMoHandle();
            BasicConfig.NameValue[] nameValueArray2 = this.createNameValueArray(nameValueArray);
            this.serviceContext.getConfigurationExtended().basic_set_MO_attributes(mOidpair, nameValueArray2, ((CelloTransaction)transaction2).getBasicConfigSession());
            CelloTransaction.commitDefaultWriteTx(transaction2, transaction);
            if (this.getNode().getCmService().isCacheOn()) {
                this.myNameValueCache.update(nameValueArray);
            }
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException((UserException)((Object)processingFailure));
        }
        catch (UserException userException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(userException);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw systemException;
        }
    }

    public Value action(String string, NameValue[] nameValueArray, Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultWriteTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            MOidpair mOidpair = this.getMoHandle();
            BasicConfig.NameValue[] nameValueArray2 = this.createNameValueArray(nameValueArray);
            NameValueSeqHolder nameValueSeqHolder = new NameValueSeqHolder();
            nameValueSeqHolder.value = nameValueArray2;
            Any any = this.serviceContext.getConfigurationAdapter().action(mOidpair, string, nameValueSeqHolder, ((CelloTransaction)transaction2).getBasicConfigSession());
            CelloValue celloValue = new CelloValue(any, this.serviceContext);
            CelloTransaction.commitDefaultWriteTx(transaction2, transaction);
            return celloValue;
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException((UserException)((Object)processingFailure));
        }
        catch (UserException userException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(userException);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw systemException;
        }
    }

    public void delete(Transaction transaction) {
        this.delete(EMPTY_FILTER, Scope.BASE_ONLY, transaction);
    }

    public void delete(String string, String string2, Scope scope, Transaction transaction) {
        this.delete(new Filter(string, string2), scope, transaction);
    }

    void delete(Filter filter, Scope scope, Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultWriteTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            MOidpair mOidpair = this.getMoHandle();
            this.serviceContext.getConfigurationExtended().basic_delete_MO(mOidpair, new MGRef(), scope.getScope(), filter, ((CelloTransaction)transaction2).getBasicConfigSession());
            CelloTransaction.commitDefaultWriteTx(transaction2, transaction);
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException((UserException)((Object)processingFailure));
        }
        catch (UserException userException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(userException);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw systemException;
        }
    }

    MOidpair getMoHandle() {
        if (this.myMoHandle == null) {
            this.myMoHandle = new MOidpair();
            this.myMoHandle.name(EasyNaming.string2NameComponentArray(this.getLdn()));
        }
        return this.myMoHandle;
    }

    private BasicConfig.NameValue[] createNameValueArray(NameValue[] nameValueArray) {
        BasicConfig.NameValue[] nameValueArray2 = null;
        nameValueArray2 = nameValueArray == null ? new BasicConfig.NameValue[]{} : new BasicConfig.NameValue[nameValueArray.length];
        for (int i = 0; i < nameValueArray2.length; ++i) {
            nameValueArray2[i] = ((CelloNameValue)nameValueArray[i]).toNameValue();
        }
        return nameValueArray2;
    }

    private MOidpair getEmptyMoId() {
        if (this._emptyMoId == null) {
            this._emptyMoId = new MOidpair();
            this._emptyMoId.ref(new MORef(0L, null, ""));
        }
        return this._emptyMoId;
    }

    public CmSubscription subscribe(NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer) {
        CmSubscription cmSubscription = CmSubscriptionFactory.subscribe(notificationType, cmNotificationConsumer, this);
        return cmSubscription;
    }

    public CmSubscription subscribe(Scope scope, NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer) {
        CmSubscription cmSubscription = CmSubscriptionFactory.subscribe(scope, notificationType, cmNotificationConsumer, this);
        return cmSubscription;
    }

    public CmSubscription subscribe(Scope scope, String[] stringArray, NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer) {
        CmSubscription cmSubscription = CmSubscriptionFactory.subscribe(scope, stringArray, notificationType, cmNotificationConsumer, this);
        return cmSubscription;
    }
}

