/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.aspectj.lang.JoinPoint;
import se.ericsson.cello.neal.NealLogger;

public class NealLog {
    private static NealLogger nealLogger = null;

    public static void setLogger(NealLogger nealLogger) {
        NealLog.nealLogger = nealLogger;
    }

    public static NealLogger getLogger() {
        return nealLogger;
    }

    static void sendEnteringLog(JoinPoint joinPoint) {
        if (NealLog.getLogger() != null) {
            Object[] objectArray = null;
            String string = null;
            String string2 = null;
            string = joinPoint.getSignature().getDeclaringType().toString();
            string2 = joinPoint.getSignature().getName();
            objectArray = joinPoint.getArgs();
            if (objectArray == null || objectArray.length < 1) {
                NealLog.entering(string, string2);
            } else if (objectArray.length == 1) {
                NealLog.entering(string, string2, objectArray[0]);
            } else {
                NealLog.entering(string, string2, objectArray);
            }
        }
    }

    static void sendExitVoid(JoinPoint joinPoint) {
        if (NealLog.getLogger() != null) {
            String string = null;
            String string2 = null;
            string = joinPoint.getSignature().getDeclaringType().toString();
            string2 = joinPoint.getSignature().getName();
            NealLog.exiting(string, string2);
        }
    }

    static void sendExitNonVoid(JoinPoint joinPoint, Object object) {
        if (NealLog.getLogger() != null) {
            String string = null;
            String string2 = null;
            string = joinPoint.getSignature().getDeclaringType().toString();
            string2 = joinPoint.getSignature().getName();
            NealLog.exiting(string, string2, object);
        }
    }

    static String format(String string, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string + "\nCaused by: ");
        }
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static void entering(String string, String string2) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().entering(string, string2);
        }
    }

    public static void entering(String string, String string2, Object object) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().entering(string, string2, object);
        }
    }

    public static void entering(String string, String string2, Object[] objectArray) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().entering(string, string2, objectArray);
        }
    }

    public static void exiting(String string, String string2) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().exiting(string, string2);
        }
    }

    public static void exiting(String string, String string2, Object object) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().exiting(string, string2, object);
        }
    }

    public static void fine(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().fine(string);
        }
    }

    public static void fine(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().fine(NealLog.format(string, throwable));
        }
    }

    public static void finer(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().finer(string);
        }
    }

    public static void finer(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().finer(NealLog.format(string, throwable));
        }
    }

    public static void finest(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().finest(string);
        }
    }

    public static void finest(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().finest(NealLog.format(string, throwable));
        }
    }

    public static void info(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().info(string);
        }
    }

    public static void info(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().info(NealLog.format(string, throwable));
        }
    }

    public static void warning(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().warning(string);
        }
    }

    public static void warning(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().warning(NealLog.format(string, throwable));
        }
    }

    public static void config(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().config(string);
        }
    }

    public static void config(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().config(NealLog.format(string, throwable));
        }
    }

    public static void severe(String string) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().severe(string);
        }
    }

    public static void severe(String string, Throwable throwable) {
        if (NealLog.getLogger() != null) {
            NealLog.getLogger().severe(NealLog.format(string, throwable));
        }
    }
}

