/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import java.text.Collator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;

public class OverriddenProperties {
    private Properties modified;
    private Properties original;
    private HashMap changed = new HashMap();
    private Properties notChanged = new Properties();

    public OverriddenProperties(Properties properties) {
        this.modified = properties;
        this.original = OverriddenProperties.copy(properties);
    }

    public static Properties copy(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties2.setProperty(string, properties.getProperty(string));
        }
        return properties2;
    }

    public Object setProperty(String string, String string2) {
        Object object = this.modified.setProperty(string, string2);
        if (!this.changed.containsKey(string)) {
            this.changed.put(string, object);
        }
        return object;
    }

    public void setProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public Object setIfEmpty(String string, String string2) {
        String string3 = this.original.getProperty(string);
        if (string3 == null) {
            return this.setProperty(string, string2);
        }
        this.notChanged.setProperty(string, string2);
        return string3;
    }

    public void setIfEmpty(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setIfEmpty(string, properties.getProperty(string));
        }
    }

    public void restore() {
        Iterator iterator = this.changed.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.changed.get(string);
            if (string2 != null) {
                this.modified.setProperty(string, string2);
                continue;
            }
            this.modified.remove(string);
        }
        this.changed.clear();
        this.changed = null;
        this.modified = null;
    }

    public Properties getModifiedProperties() {
        return this.modified;
    }

    public Properties getOriginalProperties() {
        return this.original;
    }

    public String toString() {
        return this.dump("   ") + "\n";
    }

    public String dump(String string) {
        return this.dump(string, null, null, null, null, true);
    }

    public String dump(String string, String string2, String string3, String string4, String string5, boolean bl) {
        String string6;
        String string7;
        String string8;
        Iterator<Object> iterator;
        TreeSet<Object> treeSet;
        if (string == null) {
            string = "    ";
        }
        if (string2 == null) {
            string2 = "OverriddenProperties{\n";
        }
        if (string3 == null) {
            string3 = "}\n";
        }
        if (string4 == null) {
            string4 = string + "Modified  (key : oldValue -> newValue) :\n";
        }
        if (string5 == null) {
            string5 = string + "\n" + string + "Unchanged (key : oldValue (Default=newValue)) :\n";
        }
        String string9 = string + "  ";
        StringBuffer stringBuffer = new StringBuffer(string2);
        Collator collator = Collator.getInstance(Locale.US);
        collator.setStrength(1);
        if (bl || !this.changed.isEmpty()) {
            treeSet = new TreeSet<Object>(collator);
            treeSet.addAll(this.changed.keySet());
            stringBuffer.append(string4);
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                string8 = (String)iterator.next();
                string7 = (String)this.changed.get(string8);
                string6 = this.modified.getProperty(string8);
                stringBuffer.append(string9);
                stringBuffer.append(string8);
                stringBuffer.append(" : ");
                this.appendValue(stringBuffer, string7);
                stringBuffer.append(" -> ");
                this.appendValue(stringBuffer, string6);
                stringBuffer.append("\n");
            }
        }
        if (bl || !this.notChanged.isEmpty()) {
            treeSet = new TreeSet<Object>(collator);
            treeSet.addAll(this.notChanged.keySet());
            stringBuffer.append(string5);
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                string8 = (String)iterator.next();
                string7 = this.modified.getProperty(string8);
                string6 = this.notChanged.getProperty(string8);
                stringBuffer.append(string9);
                stringBuffer.append(string8);
                stringBuffer.append(" : ");
                this.appendValue(stringBuffer, string7);
                stringBuffer.append("  (Default=");
                this.appendValue(stringBuffer, string6);
                stringBuffer.append(")\n");
            }
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private void appendValue(StringBuffer stringBuffer, String string) {
        if (string == null) {
            stringBuffer.append("(null)");
        } else if (string.equals("")) {
            stringBuffer.append("\"\"");
        } else {
            stringBuffer.append(string);
        }
    }
}

