/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.iptransport.DscpQueueStruct;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class DscpQueueMap {
    private Map dscpQueueMap = null;
    private Struct[] moStructs = null;
    private ArrayParameter parameter = null;
    private static final int NUMBER_OF_ELEMENTS = 64;
    private static final int QUEUE_1 = 1;
    private static final int QUEUE_2 = 2;
    private static final int QUEUE_3 = 3;
    private static final int QUEUE_4 = 4;
    private static final int QUEUE_5 = 5;
    private static final int QUEUE_6 = 6;
    private static final int QUEUE_7 = 7;
    private static final int QUEUE_8 = 8;

    protected DscpQueueMap() throws MoAccessException {
        this.dscpQueueMap = new HashMap(64);
        block22: for (int i = 0; i < 64; ++i) {
            switch (i) {
                case 8: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 10: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 4));
                    continue block22;
                }
                case 12: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 4));
                    continue block22;
                }
                case 14: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 4));
                    continue block22;
                }
                case 16: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 18: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 20: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 22: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 24: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 26: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 28: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 3));
                    continue block22;
                }
                case 32: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 34: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 36: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 38: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 40: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 46: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 48: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 2));
                    continue block22;
                }
                case 51: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 1));
                    continue block22;
                }
                case 54: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 1));
                    continue block22;
                }
                default: {
                    this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(i, 5));
                }
            }
        }
        this.parameter = this.createParameter();
        this.moStructs = this.createStructs();
    }

    public DscpQueueMap(Struct[] structArray) throws MoAccessException {
        if (structArray.length != 64) {
            throw new ValueOutOfRangeException("Missing element in dscpMapArray", "TrafficScheduler");
        }
        this.dscpQueueMap = new HashMap(64);
        for (int i = 0; i < 64; ++i) {
            this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(structArray[i]));
        }
        this.parameter = this.createParameter();
    }

    public DscpQueueMap(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter != null) {
            if (arrayParameter.size() != 64) {
                throw new ValueOutOfRangeException("Missing element in dscpMapArray", "TrafficScheduler");
            }
            this.dscpQueueMap = new HashMap(64);
            for (int i = 0; i < 64; ++i) {
                StructParameter structParameter = (StructParameter)arrayParameter.get(i);
                this.dscpQueueMap.put(new Integer(i), new DscpQueueStruct(structParameter));
            }
        } else {
            throw new ConfigurationMismatchException("Cannot create DscpQueueMap with null parameter ", "TrafficScheduler", "dscpMapArray");
        }
        this.moStructs = this.createStructs();
        this.parameter = arrayParameter;
    }

    public int numberOfQueues() throws MoAccessException {
        int[] nArray = new int[64];
        int n = 0;
        DscpQueueStruct dscpQueueStruct = null;
        for (int i = 0; i < 64; ++i) {
            dscpQueueStruct = (DscpQueueStruct)this.dscpQueueMap.get(new Integer(i));
            nArray[i] = (Integer)dscpQueueStruct.getValue("queue");
        }
        Arrays.sort(nArray);
        n = nArray[nArray.length - 1];
        return n;
    }

    private ArrayParameter createParameter() throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("dscpMapArray");
        for (int i = 0; i < 64; ++i) {
            arrayParameter.add((Parameter)((DscpQueueStruct)this.dscpQueueMap.get(new Integer(i))).toParameter());
        }
        return arrayParameter;
    }

    private Struct[] createStructs() throws MoAccessException {
        StructImpl[] structImplArray = new StructImpl[64];
        for (int i = 0; i < 64; ++i) {
            structImplArray[i] = ((DscpQueueStruct)this.dscpQueueMap.get(new Integer(i))).toStruct();
        }
        return structImplArray;
    }

    public Struct[] toStructs() throws MoAccessException {
        return this.moStructs;
    }

    public ArrayParameter toParameter() throws MoAccessException {
        return this.parameter;
    }
}

