/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.FastEthernetBuildIF;
import se.ericsson.cello.equipment.GeneralProcessorUnitMo;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.FastEthernetMo;
import se.ericsson.cello.iptransport.IpAccessHostGpbMoImpl;
import se.ericsson.cello.iptransport.IpInterface;
import se.ericsson.cello.iptransport.ipcp_fast_eth_lh;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class FastEthernetMoImpl
extends CelloMao
implements FastEthernetMo,
Reservable,
IpInterface,
FroInfo,
FastEthernetBuildIF {
    private static TransactionalFroIdMap froIds = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private MoData data;
    private static final int MO_DATA_REVISION_5 = 5000;
    private static final int MO_DATA_REVISION_LATEST = 5000;
    private static final int NETWORK_PREFIX_LENGTH_MIN = 0;
    private static final int NETWORK_PREFIX_LENGTH_MAX = 30;
    private static final int MTU_MIN = 64;
    private static final int MTU_MAX = 1500;
    private static final int DEFAULT_MTU = 1500;
    private static final String DEFAULT_IP_ADDRESS = "0.0.0.0";
    private static final String DH_FROID = "dhFroid";
    private static final String LH_FROID = "lhFroid";
    protected static final String PIU_ID = "piuId";
    protected static final String LH_ID = "lhId";
    private static final int MAX_NO_OF_SIBLINGS = 1;
    private static final int MAX_NO_OF_FASTETHERNET = 16;
    private static final String IPACCESSHOSTGPB_CLASSNAME = "se.ericsson.cello.iptransport.IpAccessHostGpbMoImpl";
    private static final int MAX_NO_OF_GPB_RESERVERS = 16;
    private FroProxy fastEthDhProxy = null;
    private FroProxy fastEthLhProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipcp_fast_eth_lh.class.getName()));
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"FastEthernet", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"GeneralProcessorUnit");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"FastEthernet", (int)1);
        MoAttributeValidator.checkCardinality((String)"FastEthernet", (int)16);
        FastEthernetMoImpl.searchForMediumAccessUnit(managedObject);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<SignedIntParameter> arrayList2 = new ArrayList<SignedIntParameter>();
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"FastEthernet", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"FastEthernet");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"networkPrefixLength", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)30, (String)"FastEthernet");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"mtu", (AttrList)attrList, (boolean)false, (int)1500, (int)64, (int)1500, (String)"FastEthernet");
        String string3 = (String)MoAttributeValidator.checkAndGetMandatoryAttribute((String)"defaultRouter", (AttrList)attrList, (String)"FastEthernet", (Class)String.class);
        HostIpAddress hostIpAddress = new HostIpAddress(string3, n2);
        if (hostIpAddress.equals((Object)IpAddress.getDefaultIpAddress())) {
            throw new ValueOutOfRangeException("defaultRouter can't be 0.0.0.0.", "FastEthernet");
        }
        arrayList2.add(new SignedIntParameter("administrativeState", n));
        arrayList.add(new SignedIntParameter("networkPrefixLength", n2));
        arrayList.add(new StringParameter("defaultRouter", hostIpAddress.toString()));
        arrayList.add(new SignedIntParameter("mtu", n3));
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"FastEthernet");
        return new FastEthernetMoImpl(managedObject, string, string2, arrayList, arrayList2, coordinator, froProxy, froProxy2, maoFroIndicationHandler);
    }

    private FastEthernetMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, ArrayList arrayList2, Coordinator coordinator, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "FastEthernet", string, coordinator);
        ManagedObject managedObject2;
        this.fastEthDhProxy = froProxy;
        this.fastEthLhProxy = froProxy2;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int n = 0;
        GeneralProcessorUnitMo generalProcessorUnitMo = (GeneralProcessorUnitMo)managedObject;
        if (generalProcessorUnitMo.getParent().getType().equals("Cbu")) {
            managedObject2 = generalProcessorUnitMo.getParent();
            n = ((PlugInUnitMoInternal)managedObject2.getParent()).getResourceId(coordinator);
        } else {
            n = ((PlugInUnitMoInternal)generalProcessorUnitMo.getParent()).getResourceId(coordinator);
        }
        arrayList2.add(new SignedIntParameter(PIU_ID, n));
        managedObject2 = this.fastEthLhProxy.create(coordinator, (Collection)arrayList2);
        int n2 = managedObject2.getFroId();
        arrayList.add(new SignedIntParameter(PIU_ID, n));
        arrayList.add(new SignedIntParameter(LH_ID, n2));
        managedObject2 = this.fastEthDhProxy.create(coordinator, (Collection)arrayList);
        int n3 = managedObject2.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(LH_FROID, false, n2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(DH_FROID, false, n3));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getLhFroId(coordinator));
        froIds.put(n3, (ManagedObject)this, coordinator);
        this.data.setRevision(5000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public FastEthernetMoImpl(MoData moData, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.fastEthDhProxy = froProxy;
        this.fastEthLhProxy = froProxy2;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5000);
        moDataRecoveryHelper.assertAttribute(DH_FROID);
        moDataRecoveryHelper.assertAttribute(LH_FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(LH_FROID)).getValue(null));
        froIds.put(((IntegerAttribute)this.data.getAttribute(DH_FROID)).getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("FastEthernet");
        }
        this.fastEthDhProxy.delete(coordinator, this.getDhFroId(coordinator), null);
        this.fastEthLhProxy.delete(coordinator, this.getLhFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getLhFroId(coordinator));
        froIds.remove(this.getDhFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getFastEthernetId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("FastEthernetId", coordinator);
    }

    public String getMacAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("macAddress", coordinator);
    }

    public String getDefaultRouter(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("defaultRouter", coordinator);
    }

    public void setDefaultRouter(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("defaultRouter", string, coordinator);
    }

    public int getMtu(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("mtu", coordinator);
    }

    public void setMtu(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("mtu", new Integer(n), coordinator);
    }

    public int getPmIfInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInErrors", coordinator);
    }

    public int getPmIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInUcastPkts", coordinator);
    }

    public int getPmIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutUcastPkts", coordinator);
    }

    public int getPmIfInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInDiscards", coordinator);
    }

    public int getPmIfInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInUnknownProtos", coordinator);
    }

    public int getPmIfOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutErrors", coordinator);
    }

    public int getPmIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutDiscards", coordinator);
    }

    public int getPmIfInMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInMulticastPkts", coordinator);
    }

    public int getPmIfInBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInBroadcastPkts", coordinator);
    }

    public int getPmIfOutMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutMulticastPkts", coordinator);
    }

    public int getPmIfOutBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutBroadcastPkts", coordinator);
    }

    public int getPmIfInOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsLo", coordinator);
    }

    public int getPmIfOutOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsLo", coordinator);
    }

    public int getPmIfInOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsHi", coordinator);
    }

    public int getPmIfOutOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsHi", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        PmData pmData = null;
        Map map = this.fastEthDhProxy.getAttributes(coordinator, this.getDhFroId(coordinator));
        Map map2 = this.fastEthLhProxy.getAttributes(coordinator, this.getLhFroId(coordinator));
        for (int i = 0; i < stringArray.length; ++i) {
            StringParameter stringParameter;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter")) {
                stringParameter = (StringParameter)map.get("defaultRouter");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                stringParameter = (SignedIntParameter)map.get("networkPrefixLength");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subnet")) {
                stringParameter = (SignedIntParameter)map.get("networkPrefixLength");
                int n = stringParameter.getValue();
                StringParameter stringParameter2 = (StringParameter)map.get("defaultRouter");
                HostIpAddress hostIpAddress = new HostIpAddress(stringParameter2.getValue(), stringParameter.getValue());
                IpAddress ipAddress = hostIpAddress.getSubnetAddress(n);
                objectArray[i] = ipAddress.toString();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtu")) {
                stringParameter = (SignedIntParameter)map.get("mtu");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                stringParameter = (SignedIntParameter)map2.get("administrativeState");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                stringParameter = (SignedIntParameter)map2.get("operationalState");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                stringParameter = (SignedIntParameter)map2.get("availabilityStatus");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("macAddress")) {
                stringParameter = (StringParameter)map2.get("macAddress");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInBroadcastPkts")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInBroadcastPkts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInDiscards")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInDiscards"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInErrors")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInMulticastPkts")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInMulticastPkts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInOctetsHi")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInOctetsHi"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInOctetsLo")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInOctetsLo"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInUcastPkts")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInUcastPkts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInUnknownProtos")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfInUnknownProtos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutBroadcastPkts")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutBroadcastPkts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutDiscards")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutDiscards"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutErrors")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutMulticastPkts")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutMulticastPkts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsHi")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutOctetsHi"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsLo")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutOctetsLo"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutUcastPkts")) {
                pmData = this.getPMAttributesFromFro(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIfOutUcastPkts"));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "FastEthernet");
        }
        return objectArray;
    }

    private PmData getPMAttributesFromFro(PmData pmData, Coordinator coordinator) throws MoAccessException {
        if (pmData == null) {
            return this.fastEthLhProxy.getPmAttributes(coordinator, this.getLhFroId(coordinator));
        }
        return pmData;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        IpAddress ipAddress;
        HostIpAddress hostIpAddress;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Hashtable hashtable = this.prepareSetFroAttr(coordinator, "dh");
        Hashtable hashtable2 = this.prepareSetFroAttr(coordinator, "lh");
        int n = 0;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? FastEthernetMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "FastEthernet");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"FastEthernet", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? FastEthernetMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("defaultRouter", "FastEthernet");
                }
                string = (String)objectArray[i];
                int n2 = this.getNetworkPrefixLength(coordinator);
                hostIpAddress = new HostIpAddress(string, n2);
                ipAddress = new IpAddress(this.getSubnet(coordinator));
                hostIpAddress.validateIpAddrWithinSubnet(n2, ipAddress, "FastEthernet");
                hashtable.put("defaultRouter", new StringParameter("defaultRouter", string));
                String string2 = ipAddress.toString();
                String[] stringArray2 = new String[]{"defaultRouter", "subnet"};
                Object[] objectArray2 = new String[]{string, string2};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray2, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtu")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? FastEthernetMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("mtu", "FastEthernet");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"mtu", (int)n, (int)64, (int)1500, (String)"FastEthernet");
                hashtable.put("mtu", new SignedIntParameter("mtu", n));
                this.sendNotification("mtu", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? FastEthernetMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "FastEthernet");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"FastEthernet");
                hashtable2.put("administrativeState", new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "FastEthernet");
        }
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add(hashtable.get(enumeration.nextElement()));
        }
        this.fastEthDhProxy.setAttributes(coordinator, this.getDhFroId(coordinator), arrayList);
        hostIpAddress = new ArrayList();
        ipAddress = hashtable2.keys();
        while (ipAddress.hasMoreElements()) {
            hostIpAddress.add(hashtable2.get(ipAddress.nextElement()));
        }
        this.fastEthLhProxy.setAttributes(coordinator, this.getLhFroId(coordinator), (Collection)hostIpAddress);
    }

    private Hashtable prepareSetFroAttr(Coordinator coordinator, String string) throws MoAccessException {
        Hashtable hashtable = new Hashtable();
        if (string.equals("dh")) {
            Map map = this.fastEthDhProxy.getAttributes(coordinator, this.getDhFroId(coordinator), null);
            hashtable.put("defaultRouter", map.get("defaultRouter"));
            hashtable.put("mtu", map.get("mtu"));
        } else {
            Map map = this.fastEthLhProxy.getAttributes(coordinator, this.getLhFroId(coordinator), null);
            hashtable.put("administrativeState", map.get("administrativeState"));
        }
        return hashtable;
    }

    public int getNetworkPrefixLength(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{"networkPrefixLength"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return (Integer)objectArray[0];
    }

    public String getSubnet(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{"subnet"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return (String)objectArray[0];
    }

    public NetworkAddress getNetworkAddress(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{"subnet", "networkPrefixLength"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return new NetworkAddress((String)objectArray[0], ((Integer)objectArray[1]).intValue());
    }

    public String getType() {
        return "FastEthernet";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getDhFroId(coordinator);
    }

    public int getDhFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(DH_FROID)).getValue(coordinator);
    }

    public int getLhFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(LH_FROID)).getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObject instanceof IpAccessHostGpbMoImpl && (n = ReservableImpl.noOfReservers((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (String)IPACCESSHOSTGPB_CLASSNAME, (Coordinator)coordinator)) >= 16) {
            throw new MaxNumberExceededException("Max number of " + managedObject.getType() + " reservers is exceeded", "FastEthernet");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Object[] objectArray;
            String[] stringArray;
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("administrativeState");
            StringParameter stringParameter = (StringParameter)map.get("macAddress");
            if (signedIntParameter != null) {
                stringArray = new String[]{"administrativeState"};
                objectArray = new Object[]{new Integer(signedIntParameter.getValue())};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            }
            if (stringParameter != null) {
                stringArray = new String[]{"macAddress"};
                objectArray = new Object[]{stringParameter.getValue()};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            }
            if (signedIntParameter == null && stringParameter == null) {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    private static void searchForMediumAccessUnit(ManagedObject managedObject) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals("MediumAccessUnit")) continue;
                throw new ValueOutOfRangeException("Not possible to configure both MediumAccessUnit and FastEthernet under the same GeneralProcessorUnit", "FastEthernet");
            }
        }
    }

    public static FastEthernetMoImpl lookupDhFroIdInstance(int n, Coordinator coordinator) throws TransactionRequiredException {
        return (FastEthernetMoImpl)froIds.get(n, coordinator);
    }
}

