/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.DetailModel;
import se.ericsson.cello.support.gui.guilib.table.SortedTable;

class DetailTable
extends SortedTable {
    private static final long serialVersionUID = -5746785179750995286L;

    public DetailTable(DetailModel model) {
        super.setModel(model);
        this.setRenderers();
        this.setRowSelectionAllowed(true);
        this.setShowGrid(false);
        this.setSelectionMode(0);
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public void setModel(DetailModel newModel) {
        super.setModel(newModel);
        this.setRenderers();
        this.sizeColumnsToFit(-1);
    }

    public AbstractViewElement getViewElementAtPoint(Point point) {
        int clickedRow = this.rowAtPoint(point);
        if (clickedRow >= 0) {
            DetailModel originalModel = (DetailModel)this.getOriginalTableModel();
            int originalClickedRow = this.getOriginalRow(clickedRow);
            return originalModel.getElement(originalClickedRow);
        }
        return null;
    }

    private void setRenderers() {
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(new NameColumnRenderer());
        }
    }

    public void selectTableElement(AbstractViewElement ave) {
        int presRow = this.findPresentedRow(ave);
        if (presRow < 0) {
            throw new IllegalArgumentException("View element not in table: " + ave);
        }
        this.setRowSelectionInterval(presRow, presRow);
    }

    public int findPresentedRow(AbstractViewElement ave) {
        int row;
        DetailModel originalModel = (DetailModel)this.getOriginalTableModel();
        AbstractViewElement parent = originalModel.getParentElement();
        int presentedRow = -1;
        if (parent != null && (row = parent.getChildIndex(ave)) != -1) {
            presentedRow = this.getPresentedRow(row);
        }
        return presentedRow;
    }

    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.setRenderers();
        this.sizeColumnsToFit(-1);
    }

    private class NameColumnRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 182496187130200315L;

        private NameColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = null;
            TableCellRenderer columnHeaderLabel = table.getTableHeader().getDefaultRenderer();
            if (columnHeaderLabel instanceof JLabel) {
                ((JLabel)((Object)columnHeaderLabel)).setHorizontalAlignment(10);
            }
            c = table.hasFocus() ? super.getTableCellRendererComponent(table, value, isSelected, false, row, column) : super.getTableCellRendererComponent(table, value, false, false, row, column);
            if (value != null && value instanceof AbstractViewElement && c instanceof JLabel) {
                JLabel cellLabel = (JLabel)c;
                cellLabel.setText(((AbstractViewElement)value).getName());
                cellLabel.setIcon(((AbstractViewElement)value).getIconForTable());
            }
            return c;
        }
    }
}

