/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.EmasGuilibMediator;

public class EmasProgressMonitor {
    private EmasProgressMonitor roots;
    private JDialog dialogs;
    private JOptionPane panes;
    private JProgressBar bar;
    private JLabel notesLabel;
    private Component parent;
    private String notes;
    private Object title;
    private Object message;
    private long time0;
    private int millisDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int minValue;
    private int maxValue;
    private int last;
    private int delta;
    private static Vector openProgressMonitors = new Vector();

    public EmasProgressMonitor(Component parentComponent, Object title, Object message, String note, int min, int maxValue) {
        this(parentComponent, title, message, note, min, maxValue, null);
    }

    private EmasProgressMonitor(Component parentComponent, Object title, Object messages, String note, int min, int max, EmasProgressMonitor grp) {
        this.minValue = min;
        this.maxValue = max;
        this.parent = parentComponent;
        this.delta = (max - min) / 100;
        if (this.delta < 1) {
            this.delta = 1;
        }
        this.title = title;
        this.message = messages;
        this.notes = note;
        if (grp != null) {
            this.roots = grp.roots != null ? grp.roots : grp;
            this.time0 = this.roots.time0;
            this.dialogs = this.roots.dialogs;
        } else {
            this.time0 = System.currentTimeMillis();
        }
        openProgressMonitors.add(this);
    }

    public void setProgress(int v) {
        if (v >= this.maxValue) {
            this.dialogClose();
        } else if (v >= this.last + this.delta) {
            this.last = v;
            if (this.bar != null) {
                this.bar.setValue(v);
                this.repaintImmediately();
            } else {
                int predictedCompleteTime;
                long currentTime = System.currentTimeMillis();
                long deltaT = (int)(currentTime - this.time0);
                if (deltaT >= (long)this.millisDecideToPopup && (predictedCompleteTime = v > this.minValue ? (int)(deltaT * (long)(this.maxValue - this.minValue) / (long)(v - this.minValue)) : this.millisToPopup) >= this.millisToPopup) {
                    this.bar = new JProgressBar();
                    this.bar.setMinimum(this.minValue);
                    this.bar.setMaximum(this.maxValue);
                    this.bar.setValue(v);
                    if (this.notes != null) {
                        this.notesLabel = new JLabel(this.notes);
                    }
                    this.panes = new ProgressOptionPane(new Object[]{this.message, this.notesLabel, this.bar});
                    this.dialogs = this.panes.createDialog(this.parent, this.title.toString());
                    this.dialogs.show();
                    this.repaintImmediately();
                }
            }
        }
    }

    private void repaintImmediately() {
        Container comp = this.dialogs.getContentPane();
        if (comp instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                comp.paintAll(comp.getGraphics());
            } else {
                comp.repaint();
            }
        } else {
            comp.repaint(0, 0, comp.getWidth(), comp.getHeight());
        }
    }

    public void dialogClose() {
        if (this.dialogs != null) {
            this.dialogs.setVisible(false);
            this.dialogs.dispose();
            this.dialogs = null;
            this.panes = null;
            this.bar = null;
        }
        openProgressMonitors.remove(this);
    }

    public static void closeAllOpenProgressMonitors() {
        for (int i = 0; i < openProgressMonitors.size(); ++i) {
            EmasProgressMonitor vectorProgressMonitor = (EmasProgressMonitor)openProgressMonitors.get(i);
            vectorProgressMonitor.dialogClose();
        }
        openProgressMonitors.clear();
    }

    public int getMinimumVal() {
        return this.minValue;
    }

    public void setMinimumVal(int minVal) {
        this.minValue = minVal;
    }

    public int getMaximumVal() {
        return this.maxValue;
    }

    public void setMaximumVal(int maxVal) {
        this.maxValue = maxVal;
    }

    public void setMillisToDecideToPopup(int millisToPopup) {
        this.millisDecideToPopup = millisToPopup;
    }

    public int getMsToDecideToPopup() {
        return this.millisDecideToPopup;
    }

    public void setMsToPopup(int msToPopup) {
        this.millisToPopup = msToPopup;
    }

    public int getMsToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String n) {
        this.notes = n;
        if (this.notesLabel != null) {
            this.notesLabel.setText(n);
            this.repaintImmediately();
        }
    }

    public String getProgressMonitorNote() {
        return this.notes;
    }

    public void resetProgressBar() {
        this.bar.setValue(this.minValue);
        this.last = this.minValue;
    }

    private static class ProgressOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 2560921553536165142L;

        ProgressOptionPane(Object message) {
            super(message, 1, -1, null, new Object[]{new JPanel()}, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component parent, String titles) {
            if (null == parent) {
                parent = EmasGuilibMediator.getReference().getMainWindowReference().getView();
            }
            Frame frame = JOptionPane.getFrameForComponent(parent);
            final JDialog dialogs = new JDialog(frame, titles, false);
            Container content = dialogs.getContentPane();
            content.setLayout(new BorderLayout());
            content.add((Component)this, "Center");
            dialogs.pack();
            dialogs.setLocationRelativeTo(parent);
            dialogs.addWindowListener(new WindowAdapter(){
                boolean getFocus = false;

                public void windowClosing(WindowEvent e) {
                    ProgressOptionPane.this.setValue(null);
                }

                public void windowActivated(WindowEvent e) {
                    if (!this.getFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.getFocus = true;
                    }
                }
            });
            PropertyChangeListener listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent changeEvent) {
                    if (dialogs.isVisible() && changeEvent.getSource() == ProgressOptionPane.this && (changeEvent.getPropertyName().equals("value") || changeEvent.getPropertyName().equals("inputValue"))) {
                        dialogs.setVisible(false);
                        dialogs.dispose();
                    }
                }
            };
            this.addPropertyChangeListener(listener);
            return dialogs;
        }
    }
}

