/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import javax.swing.DefaultComboBoxModel;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.OptionsView;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.PreferencesController;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.Logger;

public class OptionsController
extends PreferencesController {
    private OptionsView view;
    private static Logger preferencesLog = Logger.getLogger("se.ericsson.cello.support.gui.preferencesLog");

    protected void init() {
        super.init();
        this.view = (OptionsView)this.getView();
        this.setSelectedItem(this.view.interfaceLog, this.getInterfaceLogSettings());
        this.view.interfaceLog.addActionListener(this.editAction);
    }

    protected void stop() {
        super.stop();
        AbstractController parent = this.getParentController();
        if (parent instanceof MainWindowController) {
            // empty if block
        }
    }

    private DefaultComboBoxModel getInterfaceLogSettings() {
        InterfaceLogSetting on = new InterfaceLogSetting("GSL_INTERFACE_LOG_ALL", this.getString("GSL_INTERFACE_LOG_ALL"));
        InterfaceLogSetting off = new InterfaceLogSetting("GSL_INTERFACE_LOG_NOTHING", this.getString("GSL_INTERFACE_LOG_NOTHING"));
        InterfaceLogSetting def = new InterfaceLogSetting("GSL_INTERFACE_LOG_DEFAULT", this.getString("GSL_INTERFACE_LOG_DEFAULT"));
        DefaultComboBoxModel<InterfaceLogSetting> model = new DefaultComboBoxModel<InterfaceLogSetting>();
        model.addElement(on);
        model.addElement(off);
        model.addElement(def);
        Level currentSetting = LogManager.getLogManager().getLevel("settings");
        if (currentSetting.equals(Level.SEVERE)) {
            model.setSelectedItem(off);
        } else if (currentSetting.equals(Level.FINE)) {
            model.setSelectedItem(on);
        } else {
            model.setSelectedItem(def);
        }
        return model;
    }

    protected boolean perform() {
        boolean returnValue = super.perform();
        InterfaceLogSetting selectedSetting = (InterfaceLogSetting)this.view.interfaceLog.getModel().getSelectedItem();
        String selectedKey = selectedSetting.getKey();
        if (selectedKey.equals("GSL_INTERFACE_LOG_ALL")) {
            preferencesLog.log(Level.SEVERE, "Set logging levels to FINE...");
            LogManager.getLogManager().setLevel("", Level.FINE);
            Handler[] handlers = LogManager.getLogManager().getGlobalHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].setLevel(Level.FINE);
            }
            LogManager.getLogManager().setLevel("settings", Level.FINE);
        } else if (selectedKey.equals("GSL_INTERFACE_LOG_NOTHING")) {
            preferencesLog.log(Level.SEVERE, "Set logging levels to SEVERE...");
            LogManager.getLogManager().setLevel("", Level.SEVERE);
            Handler[] handlers = LogManager.getLogManager().getGlobalHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].setLevel(Level.SEVERE);
            }
            LogManager.getLogManager().setLevel("settings", Level.SEVERE);
        } else if (selectedKey.equals("GSL_INTERFACE_LOG_DEFAULT")) {
            preferencesLog.log(Level.SEVERE, "Set logging levels according to properties file...");
            try {
                LogManager.getLogManager().readConfiguration();
                LogManager.getLogManager().setLevel("settings", Level.INFO);
            }
            catch (Exception e) {
                preferencesLog.log(Level.SEVERE, "Error rereading properties file");
            }
        }
        return returnValue;
    }

    private static class InterfaceLogSetting {
        private String label;
        private String key;

        public InterfaceLogSetting(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public String getKey() {
            return this.key;
        }
    }
}

