/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import se.ericsson.cello.support.gui.SortedList;

public class SortedArrayList
extends ArrayList
implements SortedList {
    private static final long serialVersionUID = -5131133569759712202L;
    Comparator comparator = null;
    boolean isSorted = false;
    boolean lazySorting;

    public SortedArrayList() {
        this.setLazySorting(true);
    }

    public SortedArrayList(Comparator comp) {
        this.setComparator(comp);
        this.setLazySorting(true);
    }

    public final boolean isLazySorting() {
        return this.lazySorting;
    }

    public final void setLazySorting(boolean v) {
        this.lazySorting = v;
    }

    public void setComparator(Comparator newComparator) {
        this.comparator = newComparator;
        this.isSorted = false;
        this.sortIfBusySorting();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean add(Object o) {
        super.add(o);
        this.isSorted = false;
        this.sortIfBusySorting();
        return true;
    }

    public boolean addAll(Collection c) {
        boolean listChanged = super.addAll(c);
        this.isSorted = !listChanged;
        this.sortIfBusySorting();
        return listChanged;
    }

    public Object set(int index, Object element) {
        this.sortIfNeeded();
        Object previousElement = super.set(index, element);
        this.isSorted = false;
        this.sortIfBusySorting();
        return previousElement;
    }

    public boolean sort() {
        Object[] sortArray = super.toArray();
        boolean arrayChanged = false;
        if (this.comparator == null) {
            Arrays.sort(sortArray);
        } else {
            Arrays.sort(sortArray, this.comparator);
        }
        for (int i = 0; i < sortArray.length; ++i) {
            Object newObjectAtPosition = sortArray[i];
            Object oldObjectAtPosition = super.set(i, sortArray[i]);
            arrayChanged |= newObjectAtPosition != oldObjectAtPosition;
        }
        this.isSorted = true;
        return arrayChanged;
    }

    public Object get(int idx) {
        this.sortIfNeeded();
        return super.get(idx);
    }

    public int indexOf(Object o) {
        this.sortIfNeeded();
        return super.indexOf(o);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("not supported in SortedArrayList");
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException("not supported in SortedArrayList");
    }

    public int lastIndexOf(Object o) {
        this.sortIfNeeded();
        return super.lastIndexOf(o);
    }

    public Object remove(int index) {
        this.sortIfNeeded();
        return super.remove(index);
    }

    public void removeRange(int fromIndex, int toIndex) {
        this.sortIfNeeded();
        super.removeRange(fromIndex, toIndex);
    }

    public List subList(int fromIndex, int toIndex) {
        this.sortIfNeeded();
        return super.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        this.sortIfNeeded();
        return super.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.sortIfNeeded();
        return super.toArray(a);
    }

    public Object[] toArrayUnsorted() {
        return super.toArray();
    }

    public Object[] toArrayUnsorted(Object[] a) {
        return super.toArray(a);
    }

    private final void sortIfBusySorting() {
        if (!this.isLazySorting()) {
            this.sort();
        }
    }

    private final void sortIfNeeded() {
        if (!this.isSorted) {
            this.sort();
        }
    }

    public static SortedList synchronizedSortedArrayList(SortedList s) {
        return new SynchronizedSortedArrayList(s);
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -8052521903917657732L;
        private List lists;

        SynchronizedList(List list) {
            super(list);
            this.lists = list;
        }

        SynchronizedList(List list, Object mutex) {
            super(list, mutex);
            this.lists = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object obj) {
            Object object = this.mutexObj;
            synchronized (object) {
                return ((Object)this.lists).equals(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutexObj;
            synchronized (object) {
                return ((Object)this.lists).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int index) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.lists.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int idx, Object ele) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.lists.set(idx, ele);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int idx, Object ele) {
            Object object = this.mutexObj;
            synchronized (object) {
                this.lists.add(idx, ele);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int idx) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.lists.remove(idx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.lists.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.lists.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int idx, Collection coll) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.lists.addAll(idx, coll);
            }
        }

        public ListIterator listIterator() {
            return this.lists.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.lists.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.mutexObj;
            synchronized (object) {
                return new SynchronizedList(this.lists.subList(from, to), this.mutexObj);
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        Collection collect;
        Object mutexObj;

        SynchronizedCollection(Collection coll) {
            if (coll == null) {
                throw new NullPointerException();
            }
            this.collect = coll;
            this.mutexObj = this;
        }

        SynchronizedCollection(Collection coll, Object mutex) {
            this.collect = coll;
            this.mutexObj = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object obj) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] o) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.toArray(o);
            }
        }

        public Iterator iterator() {
            return this.collect.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object obj) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.remove(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection collection) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutexObj;
            synchronized (object) {
                this.collect.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.collect.toString();
            }
        }
    }

    static class SynchronizedSortedArrayList
    extends SynchronizedList
    implements SortedList {
        private static final long serialVersionUID = 9216650326149986666L;
        private SortedList s;

        SynchronizedSortedArrayList(SortedList sort) {
            super(sort);
            this.s = sort;
        }

        SynchronizedSortedArrayList(SortedList sort, Object mutex) {
            super(sort);
            this.s = sort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator newComparator) {
            Object object = this.mutexObj;
            synchronized (object) {
                this.s.setComparator(newComparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator getComparator() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.s.getComparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sort() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.s.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.s.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArrayUnsorted() {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.s.toArrayUnsorted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArrayUnsorted(Object[] a) {
            Object object = this.mutexObj;
            synchronized (object) {
                return this.s.toArrayUnsorted(a);
            }
        }
    }
}

