/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;

public class SplashWindow
extends JWindow
implements KeyListener {
    private static final long serialVersionUID = 1348159125170590658L;
    private static final int OPTIONS_HOTKEY = 119;
    private static final int OPTIONS_WAIT_SECONDS = 6;
    private static final String PRODUCT = "EMAS";
    private static final String EMAS_VERSION = "N/A";
    private static final String LICENCE_TO = "N/A";
    private static final String LICENCE_COMPANY = "   N/A";
    private static final String LICENCE_NUMBER = "   N/A";
    private static final String PRODUCT_GIF = "product_GIF";
    private static final String COPYRIGHT = "N/A";
    protected JPanel splashPanel;
    protected boolean optionButtonClicked = false;
    protected JToggleButton optionsButton = null;
    protected JLabel statusBar = null;
    protected JLabel productName = null;
    protected JLabel version = null;
    protected JLabel licenseTo = null;
    protected JLabel licenseName = null;
    protected JLabel licenseCompany = null;
    protected JLabel licenseNumber = null;
    protected JLabel copyrightLabel = null;
    protected JLabel fm_progressBar = null;
    protected JLabel fm_ericssonLogo = null;
    protected JLabel fm_picture = null;
    private JLabel picture = null;
    private JLabel logo = null;
    private JLabel progress = null;
    static SplashWindow instance;
    static ResourceBundle bundle;
    static Properties prop;
    protected JPanel southPanel = null;
    protected JPanel fm_textPanel = null;

    private SplashWindow() {
        this.initialize(null, null, null, null, null, null, null, null, null, null);
    }

    public static SplashWindow getInstance() {
        if (instance == null) {
            instance = new SplashWindow();
        }
        return instance;
    }

    public void displaySplash() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.splashPanel, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = this.splashPanel.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
    }

    public void removeSplash() {
        this.setVisible(false);
        this.dispose();
    }

    private void initialize(String aProductName, String aVersion, String aLicenseTo, String aLicenseName, String aLicenseCompany, String aLicenseNumber, String aCopyright, String aProductImageSource, String aLogoImageSource, String aProgressBarSource) {
        this.productName = new JLabel();
        this.version = new JLabel();
        this.licenseTo = new JLabel();
        this.licenseName = new JLabel();
        this.licenseCompany = new JLabel();
        this.licenseNumber = new JLabel();
        this.copyrightLabel = new JLabel();
        this.statusBar = new JLabel();
        this.fm_progressBar = new JLabel();
        this.fm_ericssonLogo = new JLabel();
        this.fm_picture = new JLabel();
        this.productName.setForeground(new Color(0, 0, 0));
        this.version.setFont(new Font("Arial", 0, 11));
        this.version.setForeground(new Color(102, 102, 102));
        this.licenseTo.setFont(new Font("Arial", 0, 9));
        this.licenseTo.setForeground(new Color(0, 0, 0));
        this.licenseName.setFont(new Font("Arial", 0, 9));
        this.licenseName.setForeground(new Color(0, 0, 0));
        this.licenseCompany.setFont(new Font("Arial", 0, 9));
        this.licenseCompany.setForeground(new Color(0, 0, 0));
        this.licenseNumber.setFont(new Font("Arial", 0, 9));
        this.licenseNumber.setForeground(new Color(0, 0, 0));
        this.splashPanel = new JPanel(new BorderLayout());
        this.splashPanel.setPreferredSize(new Dimension(570, 296));
        this.splashPanel.setBorder(new BevelBorder(0, new Color(128, 128, 128), new Color(0, 0, 0)));
        this.fm_textPanel = new JPanel(new BorderLayout());
        this.fm_textPanel.setBackground(Color.white);
        this.statusBar.setFont(new Font("Arial", 0, 9));
        this.statusBar.setForeground(new Color(0, 0, 0));
        JPanel textPanel = new JPanel();
        textPanel.setBackground(Color.white);
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(Box.createVerticalStrut(10));
        textPanel.add(this.productName);
        textPanel.add(Box.createVerticalStrut(10));
        textPanel.add(this.version);
        textPanel.add(Box.createVerticalStrut(30));
        textPanel.add(this.licenseTo);
        textPanel.add(this.licenseName);
        textPanel.add(this.licenseCompany);
        textPanel.add(this.licenseNumber);
        textPanel.add(Box.createVerticalStrut(30));
        textPanel.add(this.statusBar);
        Object optionsButtonImg = null;
        this.optionsButton = new JToggleButton("Options");
        this.optionsButton.setBorder(new EmptyBorder(this.optionsButton.getInsets()));
        this.optionsButton.setEnabled(false);
        this.southPanel = new JPanel(new FlowLayout(0));
        this.copyrightLabel.setFont(new Font("Arial", 0, 7));
        this.copyrightLabel.setForeground(new Color(102, 102, 102));
        this.progress = new JLabel("    Loading image...");
        this.progress.setPreferredSize(new Dimension(273, 20));
        this.progress.setForeground(Color.black);
        this.southPanel.add(this.progress);
        this.southPanel.add(this.optionsButton);
        this.southPanel.add(this.copyrightLabel);
        this.southPanel.setPreferredSize(new Dimension(366, 60));
        this.southPanel.setBackground(Color.white);
        this.fm_textPanel.add(Box.createHorizontalStrut(15), "West");
        this.logo = new JLabel("      Loading image...");
        this.logo.setPreferredSize(new Dimension(344, 43));
        this.logo.setForeground(Color.black);
        this.fm_textPanel.add((Component)this.logo, "North");
        this.fm_textPanel.add((Component)textPanel, "Center");
        this.fm_textPanel.add((Component)this.southPanel, "South");
        this.picture = new JLabel("     Loading image...");
        this.picture.setPreferredSize(new Dimension(199, 296));
        this.picture.setOpaque(true);
        this.picture.setBackground(Color.white);
        this.picture.setForeground(Color.black);
        this.splashPanel.add((Component)this.picture, "West");
        this.splashPanel.add((Component)this.fm_textPanel, "Center");
        this.addKeyListener(this);
    }

    public boolean waitForOptionButton() {
        boolean timeOut = false;
        boolean splashVisible = false;
        int i = 0;
        this.optionButtonClicked = false;
        this.optionsButton.setEnabled(true);
        try {
            while (!this.optionButtonClicked && !timeOut) {
                this.optionButtonClicked = this.optionsButton.isSelected();
                Thread.sleep(100L);
                if (++i <= 60) continue;
                timeOut = true;
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.optionsButton.setEnabled(false);
        return this.optionButtonClicked;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 119) {
            this.optionsButton.setSelected(true);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void enableOptionsButton() {
        this.optionsButton.setEnabled(true);
    }

    public void setProductName(String productNameStr) {
        if (productNameStr.length() < 23) {
            this.productName.setFont(new Font("Arial", 0, 30));
        } else {
            this.productName.setFont(new Font("Arial", 0, 20));
        }
        this.productName.setText(productNameStr);
        this.productName.repaint();
    }

    public void setVersion(String newVersion) {
        this.version.setText(newVersion);
        this.version.repaint();
    }

    public void setLicenseTo(String newLicenseTo) {
        this.licenseTo.setText(newLicenseTo);
        this.licenseTo.repaint();
    }

    public void setLicenseName(String newLicenseName) {
        this.licenseName.setText(newLicenseName);
        this.licenseName.repaint();
    }

    public void setLicenseCompany(String newLicenseCompany) {
        this.licenseCompany.setText(newLicenseCompany);
        this.licenseCompany.repaint();
    }

    public void setLicenseNumber(String newLicenceNumber) {
        this.licenseNumber.setText(newLicenceNumber);
        this.licenseNumber.repaint();
    }

    public void setCopyrightLabel(String newCopyrightLabel) {
        this.copyrightLabel.setText(newCopyrightLabel);
        this.copyrightLabel.repaint();
    }

    public void setStatusBar(String aTag) {
        this.statusBar.setText(aTag);
        this.statusBar.repaint();
    }

    public void setProgressBarImage(String source) {
        ImageIcon aProgressBar = (ImageIcon)IconHelper.createIcon(source);
        this.southPanel.remove(this.progress);
        this.southPanel.remove(this.optionsButton);
        this.southPanel.remove(this.copyrightLabel);
        this.southPanel.add(this.fm_progressBar);
        this.southPanel.add(this.optionsButton);
        this.southPanel.add(this.copyrightLabel);
        this.fm_progressBar.setIcon(aProgressBar);
        this.fm_progressBar.repaint();
    }

    public void setLogoImage(String source) {
        ImageIcon aLogoImage = (ImageIcon)IconHelper.createIcon(source);
        this.fm_textPanel.remove(this.logo);
        this.fm_textPanel.add((Component)this.fm_ericssonLogo, "North");
        this.fm_ericssonLogo.setIcon(aLogoImage);
        this.fm_ericssonLogo.repaint();
    }

    public void setProductImage(String source) {
        ImageIcon aProductImage = (ImageIcon)IconHelper.createIcon(source);
        this.splashPanel.remove(this.picture);
        this.splashPanel.add((Component)this.fm_picture, "West");
        this.fm_picture.setIcon(aProductImage);
        this.fm_picture.repaint();
    }

    public static void setBundle(ResourceBundle bundle_in) {
        bundle = bundle_in;
    }

    public ResourceBundle getResourceBundle() {
        return bundle;
    }

    public static void setProperties(Properties properties) {
        prop = properties;
    }

    public void hideOptionsButton() {
        this.optionsButton.setVisible(false);
    }

    public void displayOptionsButton() {
        this.optionsButton.setVisible(true);
    }

    static {
        prop = null;
    }
}

