/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class GenCheckBox
extends LabelledField {
    private static final long serialVersionUID = 3078587453882919405L;
    private String[] listCheckBox = null;
    private JCheckBox[] checkboxArray = null;

    public GenCheckBox(String translations, String tag, String[] listItems) {
        super(translations, tag);
        Log.trace("Constructor()");
        this.checkboxArray = new JCheckBox[listItems.length];
        for (int i = 0; i < listItems.length; ++i) {
            this.checkboxArray[i] = new JCheckBox(listItems[i]);
            this.add(this.checkboxArray[i]);
        }
        this.listCheckBox = listItems;
    }

    public GenCheckBox(String tag, String[] listItems) {
        super(tag);
        Log.trace("Constructor()");
        this.checkboxArray = new JCheckBox[listItems.length];
        for (int i = 0; i < listItems.length; ++i) {
            this.checkboxArray[i] = new JCheckBox(listItems[i]);
            this.add(this.checkboxArray[i]);
        }
        this.listCheckBox = listItems;
    }

    public void setEditable(boolean set) {
        Log.trace("setEditable()");
        for (int i = 0; i < this.checkboxArray.length; ++i) {
            this.checkboxArray[i].setEnabled(set);
        }
        this.getLabel().setEnabled(set);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        for (int i = 0; i < this.checkboxArray.length; ++i) {
            if (aListener != null) {
                this.checkboxArray[i].addActionListener(aListener);
            }
            this.checkboxArray[i].setActionCommand(aCommand);
        }
    }

    public void setValue(String[] checkOn, String[] checkOff) throws SyntaxException {
        int j;
        boolean buttonNotDefined;
        int i;
        Log.trace("setValue()");
        boolean syntaxError = false;
        for (i = 0; i < checkOn.length; ++i) {
            buttonNotDefined = true;
            for (j = 0; j < this.listCheckBox.length; ++j) {
                if (!this.listCheckBox[j].equals(checkOn[i])) continue;
                buttonNotDefined = false;
                this.checkboxArray[j].setSelected(true);
            }
            if (!buttonNotDefined) continue;
            syntaxError = true;
        }
        for (i = 0; i < checkOff.length; ++i) {
            buttonNotDefined = true;
            for (j = 0; j < this.listCheckBox.length; ++j) {
                if (!this.listCheckBox[j].equals(checkOff[i])) continue;
                buttonNotDefined = false;
                this.checkboxArray[j].setSelected(false);
            }
            if (!buttonNotDefined) continue;
            syntaxError = true;
        }
        if (syntaxError) {
            throw new SyntaxException();
        }
    }

    public String[] getValue() {
        Log.trace("getValue()");
        Vector<String> checked = new Vector<String>();
        for (int i = 0; i < this.listCheckBox.length; ++i) {
            if (!this.checkboxArray[i].isSelected()) continue;
            String s = this.listCheckBox[i];
            checked.addElement(s);
        }
        String[] checkedItems = new String[checked.size()];
        checked.toArray(checkedItems);
        return checkedItems;
    }

    public void setToolTip(String bundle, String tag) {
        Log.trace("setToolTip(" + tag + ")");
        this.toolTipBundle = bundle;
        this.toolTipTag = tag;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    public void setToolTip(String tag) {
        Log.trace("setToolTip(" + tag + ")");
        for (int j = 0; j < this.listCheckBox.length; ++j) {
            this.checkboxArray[j].setToolTipText(tag);
        }
    }

    public void setToolTip(String bundle, String tag, String additionalText) {
        this.toolTipAddition = additionalText;
        if (null == tag) {
            for (int i = 0; i < this.checkboxArray.length; ++i) {
                this.checkboxArray[i].setToolTipText(this.toolTipAddition);
            }
        } else {
            this.setToolTip(bundle, tag);
        }
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.checkboxArray;
    }

    public void updateLocale(Locale locale) {
        Log.traceFlow();
        super.updateLocale(locale);
        for (int i = 0; i < this.listCheckBox.length; ++i) {
            this.checkboxArray[i].setText(this.translateString(this.listCheckBox[i]));
        }
        this.translateTooltip(locale);
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle ttBundle = GuilibResourceBundle.getBundle(this.toolTipBundle, locale, this.getClass().getClassLoader());
            if (this.toolTipTag != null) {
                for (int i = 0; i < this.checkboxArray.length; ++i) {
                    try {
                        this.checkboxArray[i].setToolTipText(ttBundle.getString(this.toolTipTag) + this.toolTipAddition);
                        continue;
                    }
                    catch (MissingResourceException mre) {
                        this.checkboxArray[i].setToolTipText(this.toolTipTag + this.toolTipAddition);
                    }
                }
            }
        }
    }
}

