/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

public class GenLabel
extends JLabel
implements Translatable {
    private static final long serialVersionUID = -414761239262742977L;
    private String myTag = null;
    private String myBundle = null;

    public GenLabel(String translations, String tag) {
        Log.trace("Constructor()");
        this.myTag = tag;
        this.myBundle = translations;
    }

    public GenLabel(String tag) {
        this.myTag = tag;
        this.setText(this.myTag);
    }

    public void updateLocale(Locale locale) {
        Log.traceFlow();
        if (null == this.myTag || this.myTag.equals("")) {
            super.setText("");
            return;
        }
        ResourceBundle rb = null;
        try {
            rb = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
            this.setText(rb.getString(this.myTag));
        }
        catch (MissingResourceException mre) {
            this.setText(this.myTag);
        }
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        if (this.myTag != null && !this.myTag.equals("")) {
            try {
                this.setText(bundle.getString(this.myTag));
            }
            catch (MissingResourceException mre) {
                this.setText(this.myTag);
            }
        } else {
            super.setText("");
        }
    }
}

