/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.cello.support.gui.gengui.ComponentLayout;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.gengui.TranslatableListBox;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class GenListTranslatableString
extends LabelledField
implements FocusListener,
ListSelectionListener,
ComponentListener {
    private static final long serialVersionUID = -9117276441255940263L;
    protected String[] value = new String[]{""};
    private TranslatableListBox list;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private String myBundle = null;
    private JScrollPane scrollPane = null;
    int width = 0;
    private boolean maxsize = false;

    public GenListTranslatableString(String translations, String tag, String[] items) {
        super(translations, tag);
        this.myBundle = translations;
        this.list = new TranslatableListBox(items);
        this.list.addListSelectionListener(this);
        this.list.addFocusListener(this);
        this.addComponentListener(this);
        this.add(this.list);
    }

    public GenListTranslatableString(String tag, String[] items) {
        super(tag);
        this.list = new TranslatableListBox(items);
        this.list.addListSelectionListener(this);
        this.list.addFocusListener(this);
        this.addComponentListener(this);
        this.add(this.list);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public void focusLost(FocusEvent e) {
        if (this.changeSelection()) {
            int[] selected = this.list.getSelectedIndices();
            this.value = new String[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                this.value[i] = (String)this.list.getTranslatableItemAt(selected[i]);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void removeAllItems() {
        this.list.removeAllItems();
        this.layoutComponent();
    }

    public void addItems(String[] items) {
        this.list.addTranslatableItem(items);
        this.layoutComponent();
    }

    public void setValue(String[] setValue) throws SyntaxException {
        int[] selectedItems = new int[setValue.length];
        boolean undefinedListItem = true;
        for (int i = 0; i < setValue.length; ++i) {
            undefinedListItem = true;
            for (int j = 0; j < this.list.getTranslatableItemCount(); ++j) {
                if (!this.list.getTranslatableItemAt(j).equals(setValue[i])) continue;
                undefinedListItem = false;
                selectedItems[i] = j;
            }
            if (!undefinedListItem) continue;
            throw new SyntaxException();
        }
        this.list.setSelectedIndices(selectedItems);
        this.value = setValue;
    }

    public String[] getValue() {
        return this.value;
    }

    private boolean changeSelection() {
        int[] arrayOfObjects = this.list.getSelectedIndices();
        if (this.value.length == arrayOfObjects.length) {
            for (int i = 0; i < arrayOfObjects.length; ++i) {
                if (this.value[i] == (String)this.list.getTranslatableItemAt(arrayOfObjects[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isFilledIn() {
        boolean filledIn = true;
        if (this.list.getSelectedIndex() == -1) {
            filledIn = false;
        }
        return filledIn;
    }

    public Object getFieldComponent() {
        return this.list;
    }

    public void setWidth(int width) {
        Dimension myDim = this.list.getPreferredSize();
        myDim.width = width;
        this.width = width;
        this.list.setMinimumSize(myDim);
    }

    public Dimension getMaximumSize() {
        if (this.maxsize) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return super.getMaximumSize();
    }

    public void setScrollable(int rows, int width) {
        this.scrollPane = new JScrollPane(20, 30);
        Dimension d = new Dimension(width, rows * 19);
        this.scrollPane.setPreferredSize(d);
        this.scrollPane.setMinimumSize(d);
        this.remove(this.list);
        this.add(this.scrollPane);
        this.maxsize = true;
        ((ComponentLayout)this.getLayout()).setSizeAble(true);
    }

    public void componentResized(ComponentEvent e) {
        if (this.maxsize) {
            this.remove(this.scrollPane);
            this.scrollPane = new JScrollPane(this.list, 20, 30);
            this.scrollPane.setPreferredSize(new Dimension(this.getSize().width - 8, this.getSize().height - this.getLabel().getSize().height - 8));
            this.add(this.scrollPane);
            this.updateUI();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        int[] selected = this.list.getSelectedIndices();
        this.list.setBundle(GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader()));
        this.list.setSelectedIndices(selected);
        this.translateTooltip(locale);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.actionListener != null && !e.getValueIsAdjusting()) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
        }
    }
}

