/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import se.ericsson.cello.support.gui.gengui.GenButton;
import se.ericsson.cello.support.gui.gengui.GenLabelField;
import se.ericsson.cello.support.gui.gengui.GenList;
import se.ericsson.cello.support.gui.gengui.GenStringField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;

public class GenStringList
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -3967840082693735042L;
    private GenLabelField label = null;
    private GenList list = null;
    private GenStringField string = null;
    private GenButton add = null;
    private GenButton remove = null;
    private String[] value = new String[0];
    private ActionListener actionListener = null;
    private String actionCommand = null;

    public GenStringList(String tag, int amountOfChar, int amountOfRows) {
        this.label = new GenLabelField(tag);
        this.string = new GenStringField("", new Integer(amountOfChar));
        this.string.setUnderneath(true);
        this.string.setActionListener(this, "IPADDRESS");
        String[] lst = new String[]{""};
        this.list = new GenList("", lst){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.list.setScrollable(amountOfRows, ((JTextField)this.string.getFieldComponent()).getPreferredSize().width);
        this.list.setActionListener(this, "LIST");
        this.list.removeAllItems();
        this.list.setAlignmentY(0.0f);
        this.add = new GenButton("ADD");
        this.add.setActionListener(this, "ADD");
        this.add.setEnabled(false);
        Dimension d = this.add.getPreferredSize();
        d.width = 100;
        this.add.setPreferredSize(d);
        this.add.setMinimumSize(d);
        this.add.setMaximumSize(d);
        this.add.setSize(d);
        this.remove = new GenButton("REMOVE");
        this.remove.setActionListener(this, "REMOVE");
        this.remove.setEnabled(false);
        d = this.remove.getPreferredSize();
        d.width = 100;
        this.remove.setPreferredSize(d);
        this.remove.setMinimumSize(d);
        this.remove.setMaximumSize(d);
        this.remove.setSize(d);
        this.remove.setAlignmentY(0.0f);
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        JPanel component1 = new JPanel();
        component1.setLayout(new BoxLayout(component1, 0));
        component1.setAlignmentX(0.0f);
        component1.add(this.string);
        component1.add(this.add);
        JPanel component2 = new JPanel();
        component2.setLayout(new BoxLayout(component2, 0));
        component2.setAlignmentX(0.0f);
        component2.add(this.list);
        component2.add(this.remove);
        this.add(this.label);
        this.add(component1);
        this.add(component2);
    }

    public void addItems(String[] items) {
        this.list.removeAllItems();
        this.list.addItems(items);
        ListModel d = ((JList)this.list.getFieldComponent()).getModel();
        this.value = new String[d.getSize()];
        for (int i = 0; i < d.getSize(); ++i) {
            this.value[i] = (String)d.getElementAt(i);
        }
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public void setMandatory(boolean set) {
        this.label.setMandatory(set);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.add)) {
            String[] address = new String[]{this.string.getValue()};
            this.list.addItems(address);
            ((JList)this.list.getFieldComponent()).setSelectedValue(this.string.getValue(), true);
            try {
                this.list.setValue(address);
            }
            catch (SyntaxException e) {
                // empty catch block
            }
            ((JTextField)this.string.getFieldComponent()).setText("");
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
            }
        } else if (event.getSource().equals(this.remove)) {
            String[] selected = this.list.getValue();
            for (int i = 0; i < selected.length; ++i) {
                this.list.removeItem(selected[i]);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
            }
        }
        this.add.setEnabled(this.string.isFilledIn());
        this.remove.setEnabled(this.list.isFilledIn());
    }

    public String[] getValue() {
        ListModel model = ((JList)this.list.getFieldComponent()).getModel();
        String[] value = new String[model.getSize()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (String)model.getElementAt(i);
        }
        return value;
    }

    public void setValue(String[] items) {
        this.list.removeAllItems();
        this.list.addItems(items);
    }

    public boolean isFilledIn() {
        return ((JList)this.list.getFieldComponent()).getModel().getSize() != 0;
    }
}

