/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import se.ericsson.cello.support.gui.gengui.ComponentLayout;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.TranslatableTextArea;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public class GenTranslatableTextAreaField
extends LabelledField
implements ComponentListener,
LocaleChangeListener {
    private static final long serialVersionUID = -3783464103488131121L;
    private TranslatableTextArea myTextAreaField = null;
    private String value = null;
    private String myBundle = null;
    private JScrollPane myPane = null;
    private static int TEXTAREA_WIDTH = 400;
    private static int TEXTAREA_HEIGHT = 100;
    private static int MAX_ROWS = 5;
    private static int MAX_WIDTH = 40;

    public GenTranslatableTextAreaField(String translations, String labelTag) {
        super(translations, labelTag);
        this.myBundle = translations;
        this.createArea();
        this.myTextAreaField.putClientProperty("LANGUAGE_CONTROLLED", "NT");
    }

    void createArea() {
        this.myTextAreaField = new TranslatableTextArea(MAX_ROWS, MAX_WIDTH);
        this.myTextAreaField.setLineWrap(true);
        this.myTextAreaField.setWrapStyleWord(true);
        this.myTextAreaField.setDisabledTextColor(Color.black);
        this.myTextAreaField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), this.myTextAreaField.getBorder()));
        this.myTextAreaField.setEditable(false);
        this.myPane = new JScrollPane(this.myTextAreaField, 20, 30);
        this.myPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), this.myPane.getBorder()));
        this.add(this.myPane);
        this.setUnderneath(true);
        this.addComponentListener(this);
        ((ComponentLayout)this.getLayout()).setSizeAble(true);
    }

    public GenTranslatableTextAreaField(String labelTag) {
        super(labelTag);
        this.createArea();
    }

    public Object getFieldComponent() {
        return this.myTextAreaField;
    }

    public void setSizeTextArea(int columns, int rows) {
        this.myTextAreaField.setColumns(columns);
        this.myTextAreaField.setRows(rows);
        this.layoutComponent();
    }

    public void setValue(String newValue) {
        this.value = newValue;
        this.myTextAreaField.setTranslatableText(newValue);
    }

    public String getValue() {
        return this.value;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.myTextAreaField.setBundle(ResourceBundle.getBundle(this.myBundle, locale));
        this.translateTooltip(locale);
        this.layoutComponent();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void componentResized(ComponentEvent e) {
        this.remove(this.myPane);
        this.myPane = new JScrollPane(this.myTextAreaField, 20, 30);
        this.myPane.setPreferredSize(new Dimension(this.getSize().width - 8, this.getSize().height - this.getLabel().getSize().height - 8));
        this.add(this.myPane);
        this.updateUI();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

