/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

class TranslatableComboBox
extends JComboBox
implements Translatable {
    private static final long serialVersionUID = 21668419567951847L;
    private String[] translatableTags;
    private ResourceBundle myBundle;
    private TranslatableListItem[] myListItems;
    private boolean sortingOn = true;
    private ActionListener actionListener;

    TranslatableComboBox(String[] items, boolean sorting) {
        super(items);
        this.sortingOn = sorting;
        this.addTranslatableItems(items);
    }

    Object getTranslatableItemAt(int i) {
        if (i > this.getTranslatableItemCount() || this.myListItems == null) {
            return null;
        }
        return this.myListItems[i].myKey;
    }

    int getUnsortedIndex() {
        String myValue = (String)this.getTranslatableItemAt(this.getSelectedIndex());
        for (int i = 0; i < this.translatableTags.length; ++i) {
            if (!this.translatableTags[i].equals(myValue)) continue;
            return i;
        }
        return -1;
    }

    public void removeAllItems() {
        if (this.getItemCount() > 0) {
            super.removeAllItems();
        }
        this.translatableTags = null;
        this.myListItems = null;
    }

    void setBundle(ResourceBundle bundle) {
        this.myBundle = bundle;
        this.updateLocale();
    }

    void addTranslatableItems(String[] items) {
        if (this.translatableTags == null) {
            this.translatableTags = items;
        } else {
            int i;
            int length = items.length + this.translatableTags.length;
            String[] dummy = this.translatableTags;
            this.translatableTags = new String[length];
            for (i = 0; i < dummy.length; ++i) {
                this.translatableTags[i] = dummy[i];
            }
            for (i = dummy.length; i < length; ++i) {
                this.translatableTags[i] = items[i - dummy.length];
            }
        }
        if (this.myBundle != null) {
            this.updateLocale();
        } else {
            int i;
            this.removeActionListener(this.actionListener);
            this.myListItems = new TranslatableListItem[this.translatableTags.length];
            for (i = 0; i < this.translatableTags.length; ++i) {
                this.myListItems[i] = new TranslatableListItem(this.translatableTags[i], this.translatableTags[i]);
            }
            if (this.sortingOn) {
                Arrays.sort(this.myListItems);
            }
            for (i = 0; i < this.myListItems.length; ++i) {
                this.addItem(this.myListItems[i].myTranslation);
            }
            super.addActionListener(this.actionListener);
        }
    }

    int getTranslatableItemCount() {
        if (this.myListItems == null) {
            return 0;
        }
        return this.myListItems.length;
    }

    void updateLocale() {
        int i;
        this.removeActionListener(this.actionListener);
        String[] labelKeys = this.translatableTags;
        int selected = this.getSelectedIndex();
        String oldKey = null;
        if (this.myListItems != null && selected > -1) {
            oldKey = this.myListItems[selected].myKey;
        }
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        this.myListItems = new TranslatableListItem[labelKeys.length];
        for (i = 0; i < labelKeys.length; ++i) {
            if (labelKeys[i] != null) {
                String label = null;
                try {
                    label = this.myBundle.getString(labelKeys[i]);
                }
                catch (MissingResourceException mre) {
                    label = labelKeys[i];
                }
                this.myListItems[i] = new TranslatableListItem(labelKeys[i], label);
                continue;
            }
            this.myListItems[i] = new TranslatableListItem("<ERROR: NULL KEY>", "<ERROR: NULL KEY>");
        }
        if (this.sortingOn) {
            Arrays.sort(this.myListItems);
        }
        for (i = 0; i < this.myListItems.length; ++i) {
            this.addItem(this.myListItems[i].myTranslation);
        }
        if (oldKey == null) {
            this.setSelectedIndex(0);
        } else {
            for (i = 0; i < this.myListItems.length; ++i) {
                if (!this.myListItems[i].myKey.equals(oldKey)) continue;
                this.setSelectedIndex(i);
            }
        }
        this.translatableTags = labelKeys;
        super.addActionListener(this.actionListener);
    }

    public void addActionListener(ActionListener i) {
        super.addActionListener(i);
        this.actionListener = i;
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        this.myBundle = bundle;
        this.updateLocale();
    }

    public static class TranslatableListItem
    implements Comparable {
        String myKey;
        String myTranslation;

        TranslatableListItem(String key, String translation) {
            this.myKey = key;
            this.myTranslation = translation;
        }

        public int compareTo(Object o) {
            String myOtherTranslation = ((TranslatableListItem)o).myTranslation;
            return this.myTranslation.compareToIgnoreCase(myOtherTranslation);
        }
    }
}

