/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

class TranslatableLabel
extends JTextField
implements Translatable,
FocusListener {
    private static final long serialVersionUID = 5689443269901731359L;
    private String translatableTag;
    private ResourceBundle myBundle;

    public void setText(String text) {
        super.setText(" " + text);
    }

    TranslatableLabel(String tag) {
        this.translatableTag = tag;
        this.setOpaque(false);
        this.setEditable(false);
        this.setBorder(null);
        this.addFocusListener(this);
    }

    TranslatableLabel() {
        this.setOpaque(false);
        this.setEditable(false);
        this.setBorder(null);
        this.addFocusListener(this);
    }

    void setTranslatableText(String tag) {
        this.translatableTag = tag;
        if (this.myBundle != null) {
            this.updateLocale();
        }
    }

    void setBundle(ResourceBundle bundle) {
        this.myBundle = bundle;
        this.updateLocale();
    }

    void updateLocale() {
        if (this.translatableTag != null) {
            try {
                this.setText(this.myBundle.getString(this.translatableTag));
            }
            catch (MissingResourceException mre) {
                this.setText(this.translatableTag);
            }
        }
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        this.myBundle = bundle;
        this.updateLocale();
    }

    public void focusGained(FocusEvent e) {
        String text = this.getText();
        this.selectAll();
    }

    public void focusLost(FocusEvent e) {
    }
}

