/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

class TranslatableListBox
extends JList
implements Translatable {
    private static final long serialVersionUID = -8166824406809213389L;
    DefaultListModel model = new DefaultListModel();
    private String[] translatableTags;
    private ResourceBundle myBundle;

    TranslatableListBox(String[] items) {
        this.translatableTags = items;
        for (int i = 0; i < items.length; ++i) {
            this.model.addElement(items[i]);
        }
        this.setModel(this.model);
    }

    TranslatableListBox() {
        this.setModel(this.model);
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public Object getItemAt(int i) {
        return this.model.getElementAt(i);
    }

    public void addItem(Object item) {
        this.model.addElement(item);
    }

    Object getTranslatableItemAt(int i) {
        if (i > this.getTranslatableItemCount()) {
            return null;
        }
        return this.translatableTags[i];
    }

    public void removeAllItems() {
        if (this.model.getSize() > 0) {
            this.model.removeAllElements();
        }
        this.translatableTags = null;
    }

    void addTranslatableItem(String[] items) {
        if (this.translatableTags == null) {
            this.translatableTags = items;
        } else {
            int i;
            int length = items.length + this.translatableTags.length;
            String[] dummy = this.translatableTags;
            this.translatableTags = new String[length];
            for (i = 0; i < dummy.length; ++i) {
                this.translatableTags[i] = dummy[i];
            }
            for (i = dummy.length; i < length; ++i) {
                this.translatableTags[i] = items[i - dummy.length];
            }
        }
        if (this.myBundle != null) {
            this.updateLocale();
        }
    }

    int getTranslatableItemCount() {
        if (this.translatableTags == null) {
            return 0;
        }
        return this.translatableTags.length;
    }

    void setBundle(ResourceBundle bundle) {
        this.myBundle = bundle;
        this.updateLocale();
    }

    void updateLocale() {
        int i;
        String[] labelKeys = new String[this.getTranslatableItemCount()];
        for (i = 0; i < labelKeys.length; ++i) {
            labelKeys[i] = (String)this.getTranslatableItemAt(i);
        }
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        for (i = 0; i < labelKeys.length; ++i) {
            if (labelKeys[i] == null && labelKeys[i] == "") continue;
            String label = null;
            try {
                label = this.myBundle.getString(labelKeys[i]);
            }
            catch (MissingResourceException mre) {
                label = labelKeys[i];
            }
            this.addItem(label);
        }
        this.translatableTags = labelKeys;
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        this.myBundle = bundle;
        this.updateLocale();
    }
}

