/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationDefaultView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;
import se.ericsson.cello.support.gui.guilib.infra.WindowsDialogController;
import se.ericsson.cello.support.gui.guilib.infra.WindowsDialogView;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;

class ApplicationDefaultController
extends AbstractApplicationController {
    private static final String COPYRIGHT_YEAR = "2008-2010";
    private static final String MISSING = "missing";
    private static final String INIT_KEY = "HELPSERVICE_INIT";
    private static final String TRUE_VALUE = "TRUE";
    private ApplicationDefaultView view;
    private ExitAction exitAction = null;
    private CloseAction closeAction = null;
    private OptionsAction optionsAction = new OptionsAction();
    private WindowMenuListener windowMenuListener = new WindowMenuListener();
    private CascadeWindowsAction cascadeWindowsAction = new CascadeWindowsAction();
    private NextWindowsAction nextWindowsAction = new NextWindowsAction();
    private PreviousWindowsAction previousWindowsAction = new PreviousWindowsAction();
    private MinimiseAllWindowsAction minimiseAllWindowsAction = new MinimiseAllWindowsAction();
    private ShowAllWindowsAction showAllWindowsAction = new ShowAllWindowsAction();
    private AboutAction aboutAction = new AboutAction();
    private UsingHelpAction usingHelpAction = new UsingHelpAction();
    private static final int NUMBER_OF_MENU_ITEMS = 9;

    ApplicationDefaultController() {
    }

    protected void init() {
        this.view = ((ApplicationPresenter)this.getPresenter()).getMenuToolBarHandler().getApplicationDefaultView();
        if (this.view.exitMenuItem != null) {
            this.exitAction = new ExitAction();
            this.view.exitMenuItem.addActionListener(this.exitAction);
        }
        if (this.view.closeMenuItem != null) {
            this.closeAction = new CloseAction();
            this.view.closeMenuItem.addActionListener(this.closeAction);
        }
        if (this.view.optionsMenuItem != null) {
            this.view.optionsMenuItem.addActionListener(this.optionsAction);
        }
        this.view.windowMenu.addMenuListener(this.windowMenuListener);
        this.view.cascadeWindowsMenuItem.addActionListener(this.cascadeWindowsAction);
        this.view.nextWindowsMenuItem.addActionListener(this.nextWindowsAction);
        this.view.previousWindowsMenuItem.addActionListener(this.previousWindowsAction);
        this.view.minimiseAllWindowsMenuItem.addActionListener(this.minimiseAllWindowsAction);
        this.view.windowsWindowsMenuItem.addActionListener(this.showAllWindowsAction);
        this.view.aboutMenuItem.addActionListener(this.aboutAction);
        this.view.howToHelpMenuItem.addActionListener(this.usingHelpAction);
    }

    protected void stop() {
        if (this.closeAction != null) {
            this.view.closeMenuItem.removeActionListener(this.closeAction);
        }
        if (this.exitAction != null) {
            this.view.exitMenuItem.removeActionListener(this.exitAction);
        }
        if (this.view.optionsMenuItem != null) {
            this.view.optionsMenuItem.removeActionListener(this.optionsAction);
        }
        this.view.windowMenu.removeMenuListener(this.windowMenuListener);
        this.view.cascadeWindowsMenuItem.removeActionListener(this.cascadeWindowsAction);
        this.view.nextWindowsMenuItem.removeActionListener(this.nextWindowsAction);
        this.view.previousWindowsMenuItem.removeActionListener(this.previousWindowsAction);
        this.view.minimiseAllWindowsMenuItem.removeActionListener(this.minimiseAllWindowsAction);
        this.view.windowsWindowsMenuItem.removeActionListener(this.showAllWindowsAction);
        this.view.aboutMenuItem.removeActionListener(this.aboutAction);
        this.view.howToHelpMenuItem.removeActionListener(this.usingHelpAction);
        this.view = null;
    }

    private JFrame getFrame(Component parent, String iconPath) {
        JFrame frame = null;
        if (parent instanceof JFrame) {
            frame = (JFrame)parent;
        } else {
            frame = new JFrame();
            Image im = this.getIconImage(iconPath);
            if (null != im) {
                frame.setIconImage(im);
            }
        }
        return frame;
    }

    private Image getIconImage(String path) {
        Image im = null;
        File imgFile = new File(path);
        if (!imgFile.exists()) {
            return null;
        }
        try {
            int c;
            FileInputStream stream = new FileInputStream(imgFile);
            BufferedInputStream in = new BufferedInputStream(stream);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                byteArrayOut.write(c);
            }
            stream.close();
            im = Toolkit.getDefaultToolkit().createImage(byteArrayOut.toByteArray());
            in.close();
        }
        catch (Exception e) {
            im = null;
        }
        return im;
    }

    private Launchable getHelpServiceI() throws LauncherException {
        Log.logNotify("getHelpServiceI");
        Properties props = new Properties();
        String helpServiceConfigFile = EmasSystemProperties.getProperty("HELPSERVICE_CONFIG", "");
        String nodeServiceConfig = EmasSystemProperties.getProperty("NODESERVICES_CONFIG", MISSING);
        String iconpath = EmasSystemProperties.getProperty("TOOL_ICON", MISSING);
        Log.logNotify("getHelpServiceI HELPSERVICE_CONFIG: " + helpServiceConfigFile);
        if (MISSING != nodeServiceConfig) {
            props.setProperty("NODESERVICES_CONFIG", nodeServiceConfig);
        }
        if (MISSING != iconpath) {
            props.setProperty("TOOL_ICON", iconpath);
        }
        props.setProperty(INIT_KEY, TRUE_VALUE);
        MainWindowController mainWindow = EmasGuilibMediator.getReference().getMainWindowReference();
        Log.logNotify("getHelpServiceI, calling runResource");
        Launchable helpServ = mainWindow.getApplicationManager().runResource(helpServiceConfigFile, props);
        return helpServ;
    }

    private static class ShowWindowAction
    implements ActionListener {
        private ViewContainer container;

        public ShowWindowAction(ViewContainer container) {
            this.container = container;
        }

        public void actionPerformed(ActionEvent event) {
            this.container.bringToFront();
        }
    }

    private class WindowMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = -1598423891378826794L;

        public WindowMenuItem(AbstractApplication application, int index) {
            this.setName(application, index);
            this.getModel().setSelected(application == ApplicationDefaultController.this.getApplication());
            this.addActionListener(new ShowWindowAction(application.getApplicationPresenter().getViewContainer()));
        }

        private void setName(AbstractApplication application, int index) {
            StringBuffer buf = new StringBuffer(String.valueOf(index)).append(" ").append(application.getTitle());
            this.setText(buf.toString());
        }
    }

    private class UsingHelpAction
    implements ActionListener {
        private UsingHelpAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Runnable runner = new Runnable(){

                public void run() {
                    UsingHelpAction.this.launchEmToolboxUsingHelp();
                }
            };
            new Thread(runner, "launchEmToolboxUsingHelpThread").start();
        }

        private void launchEmToolboxUsingHelp() {
            Log.logNotify("launchEmToolboxUsingHelp");
            try {
                Launchable helpServ = ApplicationDefaultController.this.getHelpServiceI();
                String iconpath = EmasSystemProperties.getProperty("TOOL_ICON", ApplicationDefaultController.MISSING);
                AbstractView parent = EmasGuilibMediator.getReference().getMainWindowReference().getView();
                JFrame frame = ApplicationDefaultController.this.getFrame(parent, iconpath);
                Class[] argumentClassArray = new Class[]{JFrame.class};
                Method displayUsingHelpMethod = helpServ.getClass().getMethod("displayUsingHelp", argumentClassArray);
                Object[] argument = new Object[]{frame};
                displayUsingHelpMethod.invoke((Object)helpServ, argument);
            }
            catch (Exception e) {
                Log.logWarning("When trying to display Using Help window we got the exception: " + e.getMessage());
            }
        }
    }

    private class AboutAction
    implements ActionListener {
        private AboutAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Runnable runner = new Runnable(){

                public void run() {
                    AboutAction.this.launchEmToolboxAbout();
                }
            };
            new Thread(runner, "launchEmToolboxAboutThread").start();
        }

        private void launchEmToolboxAbout() {
            Log.logNotify("launchEmToolboxAbout");
            try {
                Launchable helpServ = ApplicationDefaultController.this.getHelpServiceI();
                Collection configFiles = ApplicationDefaultController.this.getApplicationManager().getConfigurationFiles();
                String applName = EmasSystemProperties.getProperty("CUSTOM_APPL_NAME", ApplicationDefaultController.MISSING);
                String iconpath = EmasSystemProperties.getProperty("TOOL_ICON", ApplicationDefaultController.MISSING);
                AbstractView parent = EmasGuilibMediator.getReference().getMainWindowReference().getView();
                JFrame frame = ApplicationDefaultController.this.getFrame(parent, iconpath);
                Class[] argumentClassArray = new Class[]{String.class, Collection.class, JFrame.class, ImageIcon.class, String.class, String.class, String.class};
                Method displayAboutMethod = helpServ.getClass().getMethod("displayAbout", argumentClassArray);
                Object[] argument = new Object[]{applName, configFiles, frame, null, "", ApplicationDefaultController.COPYRIGHT_YEAR, ""};
                displayAboutMethod.invoke((Object)helpServ, argument);
            }
            catch (Exception e) {
                Log.logWarning("When trying to display an About window we got the exception: " + e.getMessage());
            }
        }
    }

    private class ShowAllWindowsAction
    implements ActionListener {
        private ShowAllWindowsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            ApplicationDefaultController.this.startDialog(false, "GSL_CHOOSE_WINDOW", null, WindowsDialogView.class, WindowsDialogController.class);
        }
    }

    private class MinimiseAllWindowsAction
    implements ActionListener {
        private MinimiseAllWindowsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Enumeration enume = ApplicationDefaultController.this.getApplicationManager().getAllApplications();
            while (enume.hasMoreElements()) {
                AbstractApplication application = (AbstractApplication)enume.nextElement();
                application.getApplicationPresenter().getViewContainer().setMinimized();
            }
        }
    }

    private class PreviousWindowsAction
    implements ActionListener {
        private PreviousWindowsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            AbstractApplication application = null;
            AbstractApplication prevApp = null;
            Enumeration enume = ApplicationDefaultController.this.getApplicationManager().getApplications();
            boolean foundApp = false;
            if (enume.hasMoreElements()) {
                prevApp = (AbstractApplication)enume.nextElement();
            }
            if (prevApp == ApplicationDefaultController.this.getApplication()) {
                prevApp = ApplicationDefaultController.this.getApplicationManager().getFirstInitialApplication();
                prevApp.getApplicationPresenter().getViewContainer().bringToFront();
            } else {
                while (enume.hasMoreElements() && !foundApp) {
                    application = (AbstractApplication)enume.nextElement();
                    if (ApplicationDefaultController.this.getApplication() != application) continue;
                    foundApp = true;
                    prevApp.getApplicationPresenter().getViewContainer().bringToFront();
                }
                prevApp = application;
            }
        }
    }

    private class NextWindowsAction
    implements ActionListener {
        private NextWindowsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            boolean foundApp = false;
            AbstractApplication application = null;
            Enumeration enume = ApplicationDefaultController.this.getApplicationManager().getApplications();
            if (ApplicationDefaultController.this.getApplicationManager().isInitialApplication(ApplicationDefaultController.this.getApplication())) {
                if (enume.hasMoreElements()) {
                    application = (AbstractApplication)enume.nextElement();
                    application.getApplicationPresenter().getViewContainer().bringToFront();
                }
            } else {
                while (enume.hasMoreElements() && !foundApp) {
                    application = (AbstractApplication)enume.nextElement();
                    if (ApplicationDefaultController.this.getApplication() != application) continue;
                    foundApp = true;
                    if (!enume.hasMoreElements()) continue;
                    application = (AbstractApplication)enume.nextElement();
                    application.getApplicationPresenter().getViewContainer().bringToFront();
                }
            }
        }
    }

    private class CascadeWindowsAction
    implements ActionListener {
        private CascadeWindowsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            ApplicationDefaultController.this.getApplication().getApplicationManager().cascadeWindows();
        }
    }

    private class WindowMenuListener
    implements MenuListener {
        private WindowMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            this.removeWindowMenuItems();
            this.updateWindowMenuItems();
        }

        private void removeWindowMenuItems() {
            while (((ApplicationDefaultController)ApplicationDefaultController.this).view.windowMenu.getItemCount() > 9) {
                ((ApplicationDefaultController)ApplicationDefaultController.this).view.windowMenu.remove(9);
            }
        }

        private void updateWindowMenuItems() {
            int i = 1;
            Enumeration enume = ApplicationDefaultController.this.getApplicationManager().getAllApplications();
            while (enume.hasMoreElements()) {
                ((ApplicationDefaultController)ApplicationDefaultController.this).view.windowMenu.add(new WindowMenuItem((AbstractApplication)enume.nextElement(), i++));
            }
        }
    }

    private class ExitAction
    implements ActionListener {
        private ExitAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("true")) {
                ApplicationDefaultController.this.getApplicationManager().exitApplicationEMTApp();
            } else {
                ApplicationDefaultController.this.getApplicationManager().stopApplication(ApplicationDefaultController.this.getApplication());
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("true")) {
                ApplicationDefaultController.this.getApplicationManager().exitApplicationEMTApp();
            } else {
                ApplicationDefaultController.this.getApplicationManager().stopApplication(ApplicationDefaultController.this.getApplication());
            }
        }
    }

    private class OptionsAction
    implements ActionListener {
        private OptionsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                ApplicationDefaultController.this.startDialog(false, "GSL_OPTIONS_DIALOG_TITLE", null, Class.forName("se.ericsson.cello.support.gui.OptionsView"), Class.forName("se.ericsson.cello.support.gui.OptionsController"));
            }
            catch (ClassNotFoundException e) {
                Log.logError("Options classes not found.", e);
            }
        }
    }
}

