/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.EmasLaunchableInterface;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.comp.SortedComboBoxModel;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.LanguageManager;
import se.ericsson.cello.support.gui.guilib.infra.PreferencesView;
import se.ericsson.cello.support.gui.guilib.infra.TraceHelper;

public class PreferencesController
extends AbstractDialogController {
    private PreferencesView view;
    private Locale currentLocale;
    private String currentLookAndFeel;
    private String[] lookAndFeels;
    private Hashtable lookAndFeelInfoLookup = new Hashtable(5, 0.75f);
    private ResourceBundle languageBundle;
    private OkButtonAction okButtonAction = new OkButtonAction();
    private ApplyButtonAction applyButtonAction = new ApplyButtonAction();
    private CancelButtonAction cancelButtonAction = new CancelButtonAction();
    protected EditAction editAction = new EditAction();

    protected void init() {
        this.languageBundle = this.getApplication().getLanguageBundle();
        this.currentLocale = this.getApplication().getLocale();
        this.view = (PreferencesView)this.getView();
        this.view.okButton.addActionListener(this.okButtonAction);
        this.view.applyButton.addActionListener(this.applyButtonAction);
        this.view.cancelButton.addActionListener(this.cancelButtonAction);
        this.view.language.addActionListener(this.editAction);
        this.view.traceTypes.addActionListener(this.editAction);
        this.view.logLevel.addActionListener(this.editAction);
        this.view.logToStdOutCheckB.addActionListener(this.editAction);
        this.view.logToFileCheckB.addActionListener(this.editAction);
        this.setSelectedItem(this.view.language, this.getLocales());
        ComponentToolkit.makeSearchable(this.view.language);
        this.getLookAndFeels();
        SortedComboBoxModel lookAndFeelModel = new SortedComboBoxModel(this.lookAndFeels);
        this.view.lookAndFeel.setModel(lookAndFeelModel);
        ComponentToolkit.makeSearchable(this.view.lookAndFeel);
        this.currentLookAndFeel = UIManager.getLookAndFeel().getName();
        lookAndFeelModel.setSelectedItem(this.currentLookAndFeel);
        if (!"TRUE".equalsIgnoreCase(this.getProperty("gsl.supportlookandfeel"))) {
            this.view.lookAndFeelLabel.setVisible(false);
            this.view.lookAndFeel.setVisible(false);
        }
        this.setSelectedItem(this.view.presentation, this.getPresentation());
        ComponentToolkit.makeSearchable(this.view.presentation);
        if (!"TRUE".equalsIgnoreCase(this.getProperty("gsl.supportpresentation"))) {
            this.view.presentationLabel.setVisible(false);
            this.view.presentation.setVisible(false);
        }
        this.setSelectedItem(this.view.traceTypes, this.getAppTracing());
        this.setSelectedItem(this.view.logLevel, this.getLogLevels());
        boolean initLogToStdOut = Log.getLogToStdOut();
        this.view.logToStdOutCheckB.setSelected(initLogToStdOut);
        boolean initLogToFile = Log.getLogToFile();
        this.view.logToFileCheckB.setSelected(initLogToFile);
        String initFileId = Log.getLogFilePathAndName();
        if (initFileId != null) {
            this.view.fileIdTextB.setText(initFileId);
        }
        this.view.applyButton.setEnabled(false);
    }

    protected void afterVisible() {
        this.view.okButton.requestFocus();
        this.view.cancelButton.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    PreferencesController.this.stopDialog();
                }
                catch (Exception e) {
                    Log.trace("PreferencesController exception while doing stopDialog");
                }
            }
        }, "", KeyStroke.getKeyStroke(27, 0, false), 2);
    }

    protected void setSelectedItem(JComboBox box, ComboBoxModel model) {
        Object sel = model.getSelectedItem();
        box.setModel(model);
        if (sel != null) {
            model.setSelectedItem(sel);
        }
    }

    private SortedComboBoxModel getPresentation() {
        String[] visibleLevelKeys = ApplicationManager.PRESENTATION_TYPE_KEYS;
        int[] values = ApplicationManager.PRESENTATION_TYPE_VALUES;
        SortedComboBoxModel model = new SortedComboBoxModel();
        for (int i = 0; i < values.length; ++i) {
            String str = this.getString(visibleLevelKeys[i]);
            if (str == null) continue;
            Presentation pres = new Presentation(str, values[i]);
            model.add(pres);
            if (values[i] != this.getApplicationManager().getPresentation()) continue;
            model.setSelectedItem(pres);
        }
        return model;
    }

    private DefaultComboBoxModel getLogLevels() {
        String[] visibleLevelKeys = Log.LOG_LEVEL_KEYS;
        int[] levelValues = Log.LOG_LEVEL_VALUES;
        DefaultComboBoxModel<LogLevel> model = new DefaultComboBoxModel<LogLevel>();
        for (int i = 0; i < levelValues.length; ++i) {
            String str = this.getString(visibleLevelKeys[i]);
            if (str == null) continue;
            LogLevel logLevel = new LogLevel(str, levelValues[i]);
            model.addElement(logLevel);
            if (levelValues[i] != Log.getLogLevel()) continue;
            model.setSelectedItem(logLevel);
        }
        return model;
    }

    private DefaultComboBoxModel getAppTracing() {
        String[] visibleLevelKeys = TraceHelper.TRACE_LEVEL_KEYS;
        int[] levelValues = TraceHelper.TRACE_LEVEL_VALUES;
        DefaultComboBoxModel<LogLevel> model = new DefaultComboBoxModel<LogLevel>();
        for (int i = 0; i < levelValues.length; ++i) {
            String str = this.getString(visibleLevelKeys[i]);
            if (str == null) continue;
            LogLevel appTrace = new LogLevel(str, levelValues[i]);
            model.addElement(appTrace);
            if (levelValues[i] != TraceHelper.getTraceType()) continue;
            model.setSelectedItem(appTrace);
        }
        return model;
    }

    protected String getString(String key) {
        try {
            return this.languageBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            Log.log(2, "Key not found in resource bundle " + key);
            return null;
        }
    }

    private SortedComboBoxModel getLocales() {
        String supportedLocales = this.getApplication().getEnvironment().getProperty("gsl.language.supportedlocales");
        StringTokenizer st = new StringTokenizer(supportedLocales, ":");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        SortedComboBoxModel model = new SortedComboBoxModel();
        model.add(new LocaleHolder(this.getString("GSL_DEFAULT_LOCALE"), LanguageManager.EMPTY_LOCALE));
        for (int i = 0; i < v.size(); ++i) {
            String locale = (String)v.elementAt(i);
            String language = "";
            String country = "";
            int uScore = locale.indexOf("_");
            if (uScore == 0) {
                country = locale.substring(uScore + 1);
            } else if (uScore != -1) {
                language = locale.substring(0, uScore);
                country = locale.substring(uScore + 1);
            } else {
                language = locale;
            }
            Locale newLocale = new Locale(language, country);
            try {
                LocaleHolder newLocaleImpl = new LocaleHolder(newLocale.getDisplayName(this.currentLocale), newLocale);
                model.add(newLocaleImpl);
                if (!newLocale.equals(this.currentLocale)) continue;
                model.setSelectedItem(newLocaleImpl);
                continue;
            }
            catch (MissingResourceException mre) {
                Log.log(2, "Unsupported locale " + locale);
            }
        }
        return model;
    }

    private void getLookAndFeels() {
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        this.lookAndFeels = new String[installedLookAndFeels.length];
        for (int i = 0; i < installedLookAndFeels.length; ++i) {
            String name;
            UIManager.LookAndFeelInfo lfInfo = installedLookAndFeels[i];
            this.lookAndFeels[i] = name = lfInfo.getName();
            this.lookAndFeelInfoLookup.put(name, lfInfo);
        }
    }

    protected void stop() {
        this.view.okButton.removeActionListener(this.okButtonAction);
        this.view.applyButton.removeActionListener(this.applyButtonAction);
        this.view.cancelButton.removeActionListener(this.cancelButtonAction);
        this.view.cancelButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
    }

    private void updateExternalApplicationsLogging() {
        String logToFile = "false";
        String logToStdOut = "false";
        int logLevel = Log.getLogLevel();
        logToFile = Log.getLogToFile() ? "true" : "false";
        logToStdOut = Log.getLogToStdOut() ? "true" : "false";
        MainWindowController mw = EmasGuilibMediator.getReference().getMainWindowReference();
        if (mw == null) {
            Log.logNotify("Can't get MainWindowController in OptionsController class");
            return;
        }
        Hashtable exApps = mw.getExternalApplications();
        if (exApps == null) {
            Log.logNotify("No external applications started in OptionsController class");
            return;
        }
        Object[] args = new Object[]{logToFile, logToStdOut, new Integer(logLevel)};
        String methodName = "updateLoggingSettings";
        Enumeration launchables = exApps.elements();
        while (launchables.hasMoreElements()) {
            EmasLaunchableInterface anLanchable = (EmasLaunchableInterface)launchables.nextElement();
            anLanchable.genMethod(methodName, args);
        }
        Log.logNotify("Successfully changed logging settings ");
    }

    protected boolean perform() {
        LocaleHolder selectedLocale;
        Presentation selectedPres;
        String applyFileId;
        this.getApplication().setCursor(Application.WAIT_CURSOR);
        String selectedLookAndFeel = (String)this.view.lookAndFeel.getModel().getSelectedItem();
        if (selectedLookAndFeel != null && !this.currentLookAndFeel.equals(selectedLookAndFeel)) {
            Log.logNotify("LookAndFeel: " + selectedLookAndFeel);
            UIManager.LookAndFeelInfo lfInfo = (UIManager.LookAndFeelInfo)this.lookAndFeelInfoLookup.get(selectedLookAndFeel);
            try {
                UIManager.setLookAndFeel((LookAndFeel)Class.forName(lfInfo.getClassName()).newInstance());
                this.getApplication().getApplicationManager().updateLookAndFeel();
                this.currentLookAndFeel = selectedLookAndFeel;
            }
            catch (Throwable t) {
                Log.logError("Set LookAndFeel failed", t);
                this.view.lookAndFeel.getModel().setSelectedItem(this.currentLookAndFeel);
                this.showMessageDialog("GSL_UNSUPORTED_LOOKANDFEEL_MSG", new String[]{selectedLookAndFeel}, "GSL_UNSUPORTED_LOOKANDFEEL_TITLE", null, 0, null);
                return false;
            }
        }
        LogLevel selectedAppLevel = (LogLevel)this.view.traceTypes.getModel().getSelectedItem();
        TraceHelper.setTraceType(selectedAppLevel.getValue());
        LogLevel selectedLevel = (LogLevel)this.view.logLevel.getModel().getSelectedItem();
        Log.setLogLevel(selectedLevel.getValue());
        boolean applyLogToStdOut = this.view.logToStdOutCheckB.isSelected();
        Log.setLogToStdOut(applyLogToStdOut);
        boolean applyLogToFile = this.view.logToFileCheckB.isSelected();
        Log.setLogToFile(applyLogToFile);
        if (applyLogToFile) {
            Log.log(0, "Logging to file started");
        }
        if ((applyFileId = Log.getLogFilePathAndName()) != null) {
            this.view.fileIdTextB.setText(applyFileId);
        }
        if ((selectedPres = (Presentation)this.view.presentation.getModel().getSelectedItem()).getValue() != this.getApplicationManager().getPresentation()) {
            this.getApplication().getApplicationManager().setPresentation(selectedPres.getValue());
        }
        if (this.view.language.getModel().getSelectedItem() != null && !(selectedLocale = (LocaleHolder)this.view.language.getModel().getSelectedItem()).getLocale().equals(this.currentLocale)) {
            this.updateLocale(selectedLocale.getLocale());
            this.languageBundle = this.getApplication().getLanguageBundle();
            this.currentLocale = this.getApplication().getLocale();
            this.setSelectedItem(this.view.language, this.getLocales());
            this.setSelectedItem(this.view.logLevel, this.getLogLevels());
            this.setSelectedItem(this.view.traceTypes, this.getAppTracing());
            this.setSelectedItem(this.view.presentation, this.getPresentation());
        }
        this.updateExternalApplicationsLogging();
        Log.trace("Perform:end logging setting changed successfully.");
        this.getApplication().setCursor(Application.DEFAULT_CURSOR);
        return true;
    }

    private void updateLocale(Locale locale) {
        Enumeration enume = this.getApplication().getApplicationManager().getAllApplications();
        while (enume.hasMoreElements()) {
            ((AbstractApplication)enume.nextElement()).setLocale(locale);
        }
    }

    private static class LocaleHolder
    implements Comparable {
        private String label;
        private Locale locale;

        protected LocaleHolder(String label, Locale locale) {
            this.label = label;
            this.locale = locale;
        }

        public String toString() {
            return this.label;
        }

        protected String getLabel() {
            return this.label;
        }

        public boolean equals(Object k2) {
            if (this.label == null || k2 == null || ((LocaleHolder)k2).getLabel() == null) {
                return false;
            }
            return this.label.equals(((LocaleHolder)k2).getLabel());
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object k2) {
            return this.label.compareTo(((LocaleHolder)k2).getLabel());
        }

        protected Locale getLocale() {
            return this.locale;
        }
    }

    private static class LogLevel
    implements Comparable {
        private String label;
        private int value;

        protected LogLevel(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public int compareTo(Object k2) {
            return this.label.compareTo(((LogLevel)k2).getLabel());
        }

        public boolean equals(Object k2) {
            if (this.label == null || k2 == null || ((LogLevel)k2).getLabel() == null) {
                return false;
            }
            return this.label.equals(((LogLevel)k2).getLabel());
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        protected String getLabel() {
            return this.label;
        }

        protected int getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class Presentation
    implements Comparable {
        private String label;
        private int value;

        protected Presentation(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public int compareTo(Object k2) {
            return this.label.compareTo(((Presentation)k2).getLabel());
        }

        public boolean equals(Object k2) {
            if (this.label == null || k2 == null || ((Presentation)k2).getLabel() == null) {
                return false;
            }
            return this.label.equals(((Presentation)k2).getLabel());
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        protected String getLabel() {
            return this.label;
        }

        protected int getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        public void actionPerformed(ActionEvent event) {
            ((PreferencesController)PreferencesController.this).view.applyButton.setEnabled(true);
        }
    }

    private class CancelButtonAction
    implements ActionListener {
        private CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            PreferencesController.this.stopDialog();
        }
    }

    private class ApplyButtonAction
    implements ActionListener {
        private ApplyButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (PreferencesController.this.perform()) {
                ((PreferencesController)PreferencesController.this).view.applyButton.setEnabled(false);
            }
        }
    }

    private class OkButtonAction
    extends ApplyButtonAction {
        private OkButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            boolean perform = PreferencesController.this.perform();
            if (perform) {
                PreferencesController.this.getPresenter().stop();
            } else {
                PreferencesController.this.getPresenter().getViewContainer().bringToFront();
            }
        }
    }
}

