/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogView;
import se.ericsson.cello.support.gui.guilib.infra.AbstractRequest;

class RequestHandler
implements Runnable {
    private AbstractController controller;
    private AbstractRequest request;
    private AbstractRequest.BlockMode blockMode;
    private AbstractRequest.ProgressMode progressMode;
    private boolean isRequestFinished = false;
    private boolean isRequestCancelled = false;
    private CancelDialogController cancelController;

    RequestHandler(AbstractController controller, AbstractRequest request) {
        this.controller = controller;
        this.request = request;
        this.blockMode = request.getBlockMode();
        this.progressMode = request.getProgressMode();
    }

    AbstractController getController() {
        return this.controller;
    }

    AbstractRequest getRequest() {
        return this.request;
    }

    synchronized void invokeRequest() {
        Log.assertion(SwingUtilities.isEventDispatchThread(), "Must be called in event dispath thread");
        this.request.setController(this.controller);
        if (this.blockMode == AbstractRequest.BLOCK_THIS_APPLICATION) {
            this.controller.getApplication().setEnabled(false);
            if (this.progressMode != AbstractRequest.NO_PROGRESS) {
                Timer timer = new Timer(3000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        RequestHandler.this.showProgressDialog();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        } else if (this.progressMode != AbstractRequest.NO_PROGRESS) {
            this.showProgressDialog();
        }
        new Thread(this).start();
    }

    private void handleDone(Exception exception) {
        if (this.controller.isDisposed()) {
            Log.log(3, "NOTIFY RequestHandler handleDone(): Controller has been diposed", (Throwable)exception);
        } else {
            if (this.cancelController != null) {
                this.cancelController.stopDialog();
            }
            if (this.blockMode == AbstractRequest.BLOCK_THIS_APPLICATION) {
                this.controller.getApplication().setEnabled(true);
            }
            if (this.isRequestCancelled) {
                this.request.handleCancelled();
            } else if (exception == null) {
                this.request.handleSuccesful();
            } else {
                this.request.handleException(exception);
            }
        }
        this.controller = null;
        this.request = null;
    }

    private void showProgressDialog() {
        if (!this.isRequestFinished) {
            this.cancelController = (CancelDialogController)this.controller.startDialog(false, this.request.getDialogTitleKey(), this.request.getDialogTitleArgs(), CancelDialogView.class, CancelDialogController.class, new Object[][]{{"RequestHandler", this}});
        }
    }

    public void run() {
        Exception exception = null;
        try {
            this.request.invoke();
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            this.request.invokeFinally();
        }
        catch (Exception e) {
            Log.logWarning("RequestHandler run(): Exception occured in method invokeFinally()\n" + e);
        }
        if (!this.isRequestFinished) {
            this.requestFinished(exception);
        }
    }

    private synchronized void cancelRequest() {
        if (!this.isRequestFinished) {
            this.isRequestCancelled = true;
            this.requestFinished(null);
        }
    }

    private synchronized void requestFinished(Exception exception) {
        this.isRequestFinished = true;
        final Exception finalException = exception;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RequestHandler.this.handleDone(finalException);
            }
        });
    }

    public static class CancelDialogController
    extends AbstractDialogController
    implements ActionListener {
        private CancelDialogView view;
        private RequestHandler requestHandler;
        private ProgressUpdater progressUpdater = new ProgressUpdater();

        protected void init() {
            this.view = (CancelDialogView)this.getView();
            this.requestHandler = (RequestHandler)this.getParameter("RequestHandler");
            this.setMessageAndCancel();
            this.view.cancelButton.addActionListener(this);
            Timer timer = new Timer(500, this.progressUpdater);
            timer.setRepeats(true);
            timer.start();
        }

        private void setMessageAndCancel() {
            String key = this.requestHandler.getRequest().getDialogMessageKey();
            Object[] args = this.requestHandler.getRequest().getDialogMessageArgs();
            String message = "";
            if (key != null && !key.equals("")) {
                message = this.requestHandler.getController().getString(key, args);
            }
            this.view.messageText.setText(message);
            if (this.requestHandler.getRequest().getProgressMode() == AbstractRequest.PROGRESS_WITH_CANCEL_DIALOG) {
                this.view.addCancelButton();
            }
        }

        protected void viewClosing() {
            this.requestHandler.cancelRequest();
        }

        protected void stop() {
            this.view.cancelButton.removeActionListener(this);
            this.view = null;
            this.requestHandler = null;
            this.progressUpdater = null;
        }

        public void actionPerformed(ActionEvent event) {
            this.requestHandler.cancelRequest();
        }

        private class ProgressUpdater
        implements ActionListener {
            private int progress;

            private ProgressUpdater() {
            }

            public void actionPerformed(ActionEvent e) {
                if (CancelDialogController.this.view != null) {
                    this.progress += 20;
                    if (this.progress > 100) {
                        this.progress = 0;
                    }
                    ((CancelDialogController)CancelDialogController.this).view.progressBar.setValue(this.progress);
                }
            }
        }
    }

    public static class CancelDialogView
    extends AbstractDialogView {
        private static final long serialVersionUID = 4635897397830235140L;
        private JTextArea messageText;
        private JPanel innerPanel;
        JButton cancelButton;
        JProgressBar progressBar = new JProgressBar(0, 0, 100);

        protected void init() {
            this.setLayout(new BorderLayout());
            this.messageText = new JTextArea();
            this.messageText.setEditable(false);
            this.messageText.setLineWrap(true);
            this.messageText.setWrapStyleWord(true);
            this.messageText.setRequestFocusEnabled(false);
            this.messageText.setBackground(UIManager.getColor("control"));
            this.messageText.setForeground(UIManager.getColor("controlText"));
            this.innerPanel = new JPanel();
            this.innerPanel.setLayout(new BorderLayout());
            this.innerPanel.add((Component)this.messageText, "Center");
            this.add((Component)this.innerPanel, "Center");
            this.add((Component)this.progressBar, "South");
            this.cancelButton = new JButton("GSL_CANCEL");
            this.setPreferredSize(new Dimension(250, 100));
        }

        public void addCancelButton() {
            JPanel pan = new JPanel();
            pan.add(this.cancelButton);
            this.innerPanel.add((Component)pan, "South");
        }

        public boolean onClose() {
            return true;
        }

        public boolean isResizable() {
            return false;
        }
    }
}

