/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import javax.swing.JComboBox;
import se.ericsson.cello.support.gui.guilib.table.SmartTableCell;

public class ComboBoxTableCell
extends SmartTableCell {
    private int selectedIndex;
    private JComboBox box;

    public ComboBoxTableCell(JComboBox box) {
        this.init(box, true, 0);
    }

    public ComboBoxTableCell(JComboBox box, boolean isEditable) {
        this.init(box, isEditable, 0);
    }

    public ComboBoxTableCell(JComboBox box, boolean isEditable, int selectedIndex) {
        this.init(box, isEditable, selectedIndex);
    }

    private void init(JComboBox box, boolean isEditable, int selectedIndex) {
        this.box = box;
        this.setEditable(isEditable);
        this.setSelectedIndex(selectedIndex);
    }

    public Object getValue() {
        return this;
    }

    public Object getCellValue() {
        return this.box.getItemAt(this.selectedIndex);
    }

    public String toString() {
        if (this.box.getItemAt(this.selectedIndex) == null) {
            return " ";
        }
        return this.box.getItemAt(this.selectedIndex).toString();
    }

    public boolean setValue(Object value) {
        int numberOfItems = this.box.getItemCount();
        for (int i = 0; i < numberOfItems; ++i) {
            if (!this.box.getItemAt(i).equals(value)) continue;
            this.selectedIndex = i;
            break;
        }
        return true;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex >= this.box.getItemCount()) {
            selectedIndex = -1;
        }
        this.selectedIndex = selectedIndex;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int compareTo(Object value) {
        return this.toString().compareTo(((ComboBoxTableCell)value).toString());
    }
}

