/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.support.gui.guilib.table.ColumnGroup;
import se.ericsson.cello.support.gui.guilib.table.GroupableTableHeader;

class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    GroupableTableHeaderUI() {
    }

    public void paint(Graphics graph, JComponent comp) {
        Rectangle clipBounds = graph.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int col = 0;
        Dimension s = this.header.getSize();
        Rectangle cell = new Rectangle(0, 0, s.width, s.height);
        Hashtable t = new Hashtable();
        int colMargin = this.header.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> tableColumn = this.header.getColumnModel().getColumns();
        this.paintGroup(tableColumn, s, cell, t, graph, colMargin, clipBounds, col);
    }

    private void paintGroup(Enumeration tableColumn, Dimension size, Rectangle cell, Hashtable hashTable, Graphics graph, int colMargin, Rectangle clipBounds, int col) {
        while (tableColumn.hasMoreElements()) {
            cell.height = size.height;
            cell.y = 0;
            TableColumn aCol = (TableColumn)tableColumn.nextElement();
            Enumeration groups = ((GroupableTableHeader)this.header).getColumnGroups(aCol);
            if (groups != null) {
                int grpHeight = 0;
                while (groups.hasMoreElements()) {
                    ColumnGroup colGroup = (ColumnGroup)groups.nextElement();
                    Rectangle group = (Rectangle)hashTable.get(colGroup);
                    if (group == null) {
                        group = new Rectangle(cell);
                        Dimension d = colGroup.getSize(this.header.getTable());
                        group.width = d.width;
                        group.height = d.height;
                        hashTable.put(colGroup, group);
                    }
                    this.paintCell(graph, group, colGroup);
                    cell.height = size.height - (grpHeight += group.height);
                    cell.y = grpHeight;
                }
            }
            cell.width = aCol.getWidth() + colMargin;
            if (cell.intersects(clipBounds)) {
                this.paintCell(graph, cell, col);
            }
            cell.x += cell.width;
            ++col;
        }
    }

    private void paintCell(Graphics graph, Rectangle cell, int colIndex) {
        TableColumn aCol = this.header.getColumnModel().getColumn(colIndex);
        TableCellRenderer render = aCol.getHeaderRenderer();
        Component comp = render.getTableCellRendererComponent(this.header.getTable(), aCol.getHeaderValue(), false, false, -1, colIndex);
        this.rendererPane.add(comp);
        this.rendererPane.paintComponent(graph, comp, this.header, cell.x, cell.y, cell.width, cell.height, true);
    }

    private void paintCell(Graphics graph, Rectangle cell, ColumnGroup colGroup) {
        TableCellRenderer renderer = colGroup.getHeaderRender();
        Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), colGroup.getHeaderVal(), false, false, -1, -1);
        this.rendererPane.add(comp);
        this.rendererPane.paintComponent(graph, comp, this.header, cell.x, cell.y, cell.width, cell.height, true);
    }

    private int getHeaderHeight() {
        int high = 0;
        TableColumnModel colModel = this.header.getColumnModel();
        for (int c = 0; c < colModel.getColumnCount(); ++c) {
            TableColumn aCol = colModel.getColumn(c);
            TableCellRenderer render = aCol.getHeaderRenderer();
            Component comp = render.getTableCellRendererComponent(this.header.getTable(), aCol.getHeaderValue(), false, false, -1, c);
            int compHeight = comp.getPreferredSize().height;
            Enumeration e = ((GroupableTableHeader)this.header).getColumnGroups(aCol);
            if (e != null) {
                while (e.hasMoreElements()) {
                    ColumnGroup cGroup = (ColumnGroup)e.nextElement();
                    compHeight += cGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            high = Math.max(high, compHeight);
        }
        return high;
    }

    private Dimension createHeaderSize(long w) {
        TableColumnModel colModel = this.header.getColumnModel();
        if ((w += (long)(colModel.getColumnMargin() * colModel.getColumnCount())) > Integer.MAX_VALUE) {
            w = Integer.MAX_VALUE;
        }
        return new Dimension((int)w, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent comp) {
        long wide = 0L;
        Enumeration<TableColumn> e = this.header.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn aColumn = e.nextElement();
            wide += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(wide);
    }
}

