/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import se.ericsson.cello.support.gui.guilib.table.SortedTableModel;

public class SortedTable
extends JTable {
    private static final long serialVersionUID = -5082526966840449550L;
    private SortedTableModel stModel = null;

    public void setModel(TableModel model) {
        boolean b_setTableHeader = true;
        if (this.stModel != null) {
            this.stModel.removeMouseListenerToHeaderInTable();
            b_setTableHeader = false;
        }
        this.stModel = new SortedTableModel(model);
        super.setModel(this.stModel);
        if (b_setTableHeader) {
            this.setTableHeader(this.createDefaultTableHeader());
        } else {
            this.stModel.addMouseListenerToHeaderInTable(this);
        }
    }

    public void setTableHeader(JTableHeader tableHeader) {
        super.setTableHeader(tableHeader);
        this.stModel.removeMouseListenerToHeaderInTable();
        this.stModel.addMouseListenerToHeaderInTable(this);
    }

    public TableModel getModel() {
        return super.getModel();
    }

    public TableModel getOriginalTableModel() {
        return ((SortedTableModel)super.getModel()).getModel();
    }

    public int getOriginalSelectedRow() {
        int row = super.getSelectedRow();
        if (row == -1) {
            return row;
        }
        return ((SortedTableModel)super.getModel()).getIndex(row);
    }

    public int[] getOriginalSelectedRows() {
        int[] row = super.getSelectedRows();
        int[] realRows = new int[row.length];
        for (int i = 0; i < row.length; ++i) {
            realRows[i] = ((SortedTableModel)super.getModel()).getIndex(row[i]);
        }
        return realRows;
    }

    public void setSortOnRowInsertDelete(boolean sortOnRowInsertDelete) {
        if (this.stModel != null) {
            this.stModel.setSortOnRowInsertDelete(sortOnRowInsertDelete);
        }
    }

    public void sort() {
        if (this.stModel != null) {
            this.stModel.doSort();
        }
    }

    public int getOriginalRow(int presentedRow) {
        return ((SortedTableModel)super.getModel()).getIndex(presentedRow);
    }

    public int getPresentedRow(int originalRow) {
        int presentedRow = ((SortedTableModel)super.getModel()).getPresentedIndex(originalRow);
        return presentedRow;
    }
}

