/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import se.ericsson.cello.support.gui.guilib.table.SmartTableCell;

public class StringTableCell
extends SmartTableCell {
    private String value;
    private boolean valueMandatory = false;

    public StringTableCell(String str, boolean isEditable) {
        this.value = str;
        this.setEditable(isEditable);
    }

    public Object getValue() {
        return this;
    }

    public Object getCellValue() {
        return this.value;
    }

    public String toString() {
        if (this.value != null && !this.value.equals("")) {
            return this.value;
        }
        return " ";
    }

    public void setValueMandatory(boolean valueMandatory) {
        this.valueMandatory = valueMandatory;
    }

    public boolean setValue(Object value) {
        int length = -1;
        if (value != null) {
            try {
                length = ((String)value).length();
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        if (length > 0) {
            this.value = value.toString();
        } else if (value != null && !this.valueMandatory) {
            this.value = value.toString();
        } else {
            if (value != null && this.valueMandatory) {
                return false;
            }
            this.value = null;
        }
        return true;
    }

    public int compareTo(Object value) {
        if (this.value != null && ((StringTableCell)value).getCellValue() != null) {
            return this.value.compareTo(((StringTableCell)value).toString());
        }
        if (this.value != null && ((StringTableCell)value).getCellValue() == null) {
            return 1;
        }
        if (this.value == null && ((StringTableCell)value).getCellValue() == null) {
            return 0;
        }
        return -1;
    }
}

