/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import se.ericsson.cello.support.gui.NameValue;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.LogRecord;

public class SeparatorFormatter
extends Formatter {
    private static long baseTime = -1L;

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(500);
        Object[] params = record.getParameters();
        String logMessage = record.getMessage();
        if (baseTime == -1L) {
            baseTime = record.getMillis();
        }
        sb.append(record.getMillis() - baseTime);
        if (logMessage != null) {
            sb.append(";");
            sb.append(logMessage);
        }
        if (params != null && params.length >= 6) {
            sb.append(";");
            sb.append((String)params[2]);
            sb.append(";");
            sb.append((String)params[3]);
            sb.append(";");
            sb.append(params[0].toString());
            sb.append(";");
            sb.append((String)params[1]);
            sb.append(";");
            sb.append(params[4].toString());
            sb.append(";");
            sb.append(params[5].toString());
            for (int index = 6; index < params.length; ++index) {
                if (params[index] instanceof NameValue[]) {
                    NameValue[] nv = (NameValue[])params[index];
                    for (int i = 0; i < nv.length; ++i) {
                        sb.append(";");
                        sb.append(nv[i].getName());
                        sb.append(",");
                        sb.append(nv[i].getValue().toString());
                    }
                    continue;
                }
                if (!(params[index] instanceof String)) continue;
                sb.append(";");
                sb.append(params[index].toString());
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

