/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.support.gui.AbstractViewManager;
import se.ericsson.cello.support.gui.EmasProperties;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.FactoryHelper;

public class ElementManager
extends AbstractViewManager {
    private TopologyModel myTopologyModel;
    private String view;
    private EmasProperties properties;

    private String getAssertedProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            Log.logError("Property " + key + " not found for view=" + this.view);
        }
        return value;
    }

    public ElementManager(Properties p) {
        this(p, null);
    }

    public ElementManager(Properties p, String packagePath) {
        String bundle;
        String emcreators;
        String nameOfRoot;
        this.properties = (EmasProperties)p;
        Hashtable<String, EmasViewElementCreator> creators = new Hashtable<String, EmasViewElementCreator>();
        String viewprefix = this.getAssertedProperty("viewprefix");
        String view = this.properties.getProperty("tag");
        if (view == null) {
            Log.logError("Property (" + viewprefix + ") tag not found for view");
        }
        if ((nameOfRoot = this.properties.getProperty("root")) == null) {
            Log.logError("Property (" + viewprefix + ") root not found for view=" + view);
        }
        if ((emcreators = this.properties.getProperty("creators")) == null) {
            Log.logError("Property (" + viewprefix + ") creators not found for view=" + view);
        }
        if (MainWindowController.PROPS_DEBUG) {
            System.out.println("__________" + (EmasProperties.isExtended(this.properties, "tag") ? "EXT.tag = " : "tag = ") + view);
            System.out.println("__________" + (EmasProperties.isExtended(this.properties, "root") ? "EXT.root = " : "root = ") + nameOfRoot);
            System.out.println("__________" + (EmasProperties.isExtended(this.properties, "creators") ? "EXT.creators = " : "creators = ") + emcreators);
            System.out.println("__________" + (EmasProperties.isExtended(this.properties, "attributes") ? "EXT.attributes = " : "attributes = ") + this.properties.getProperty("attributes"));
            System.out.println("__________" + (EmasProperties.isExtended(this.properties, "languageBundle") ? "EXT.languageBundle" : "languageBundle = ") + this.properties.getProperty("languageBundle"));
        }
        StringTokenizer st = new StringTokenizer(emcreators, ",");
        while (st.hasMoreTokens()) {
            String creator = st.nextToken();
            String key = "creator." + creator + ".";
            String nameOfClass = this.properties.getProperty(key + "class");
            if (nameOfClass == null) {
                Log.logError("Property (" + viewprefix + ")" + key + "class not found for view=" + view);
                continue;
            }
            if (nameOfClass.equalsIgnoreCase("null") || nameOfClass.equals("")) {
                Log.logNotify("Property " + viewprefix + key + "class overridden with empty value.");
                continue;
            }
            String nameOfProperties = this.properties.getProperty(key + "properties");
            if (MainWindowController.PROPS_DEBUG) {
                System.out.println("__________" + (EmasProperties.isExtended(this.properties, key + "class") ? "EXT." + key + "class = " : key + "class = ") + nameOfClass);
                System.out.println("__________" + (EmasProperties.isExtended(this.properties, key + "properties") ? "EXT." + key + "properties = " : key + "properties = ") + nameOfProperties);
                System.out.println("__________" + (EmasProperties.isExtended(this.properties, key + "parent") ? "EXT." + key + "parent = " : key + "parent = ") + this.properties.getProperty(key + "parent"));
            }
            if (packagePath == null) {
                packagePath = this.createPackagePath(nameOfProperties);
            }
            EmasViewElementCreator instance = null;
            try {
                Properties ppp = nameOfProperties == null ? this.properties : (nameOfProperties.equals("null") ? new EmasProperties() : PropertiesHelper.getProperties(nameOfProperties, packagePath));
                ppp.setProperty("viewprefix", viewprefix);
                ppp.setProperty("creatorprefix", key);
                Object[] args = new Object[]{ppp, packagePath};
                instance = (EmasViewElementCreator)FactoryHelper.instantiateClass(nameOfClass, args);
            }
            catch (Exception e) {
                Log.logError("ElementCreator " + nameOfClass + " cannot be instantiated", e);
            }
            creators.put(creator, instance);
            if (creator.equals(nameOfRoot)) continue;
            String nameOfParent = this.properties.getProperty(key + "parent");
            EmasViewElementCreator parent = null;
            if (nameOfParent != null) {
                parent = (EmasViewElementCreator)creators.get(nameOfParent);
            }
            if (parent == null) {
                Log.logError("Property (" + viewprefix + ")" + key + "parent=" + nameOfParent + " invalid for view=" + view);
                continue;
            }
            parent.add(instance);
        }
        EmasViewElementCreator root = (EmasViewElementCreator)creators.get(nameOfRoot);
        if (root == null) {
            Log.logError("No creator found for root=" + nameOfRoot + " for view=" + view);
        }
        this.myTopologyModel = new TopologyModel(view, root);
        String attributes = this.properties.getProperty("attributes");
        if (attributes != null) {
            Vector<String> names = new Vector<String>();
            st = new StringTokenizer(attributes, ",");
            if (!attributes.equalsIgnoreCase("null")) {
                while (st.hasMoreTokens()) {
                    names.add(st.nextToken());
                }
            }
            this.myTopologyModel.replaceStandardAttributes(names.toArray(new String[0]));
        }
        if ((bundle = this.properties.getProperty("languageBundle")) == null) {
            Log.logError("Property languageBundle not found");
        }
        this.myTopologyModel.setResourceBundleBasename(bundle);
    }

    private String createPackagePath(String aPropertiesFile) {
        try {
            String classPath = aPropertiesFile.replace('/', '.');
            int index = classPath.lastIndexOf(".resources");
            classPath = classPath.substring(1, index);
            index = classPath.lastIndexOf(".");
            return classPath.substring(0, index);
        }
        catch (Exception e) {
            return "";
        }
    }

    public TopologyModel getTopologyModel() {
        return this.myTopologyModel;
    }
}

