/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.omg.TimeBase.UtcT;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.MOProxy;

public class TimeConverter {
    private SimpleDateFormat utc_formatter;
    private SimpleDateFormat utc_formatterWithMilliseconds;
    private SimpleDateFormat clientTime_formatter;
    public boolean convertToClientLocalTime;
    public boolean convertToUTC_time;
    public final long gregorianCutover;
    private TimeZone utc_TimeZone = TimeZone.getTimeZone("GMT+00:00");
    private Locale local_US = new Locale("en", "US");
    SimpleDateFormat[] formatterType = new SimpleDateFormat[]{new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z", this.local_US), new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa", this.local_US), new SimpleDateFormat("'Date:' yyyy-MM-dd, 'Time:'HH:mm:ss.SSS", this.local_US), new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", this.local_US), new SimpleDateFormat("yy'W'ww", this.local_US), new SimpleDateFormat("yyyyMMdd", this.local_US), new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", this.local_US), new SimpleDateFormat(" EEE MMM dd HH:mm:ss yyyy", this.local_US), new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss", this.local_US)};

    public TimeConverter() {
        this.gregorianCutover = 12219292800000L;
        this.clientTime_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.utc_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.utc_formatterWithMilliseconds = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.utc_formatter.setTimeZone(this.utc_TimeZone);
        this.utc_formatterWithMilliseconds.setTimeZone(this.utc_TimeZone);
        this.convertToClientLocalTime = true;
        this.convertToUTC_time = false;
        for (int i = 0; i < this.formatterType.length; ++i) {
            this.formatterType[i].setTimeZone(this.utc_TimeZone);
            this.formatterType[i].setLenient(true);
        }
    }

    public String formatTime(UtcT UtcTTime) {
        String timeString = null;
        long timeServerTime = (UtcTTime.time - (long)UtcTTime.inacclo) / 10000L;
        Date utcDate = new Date(timeServerTime - this.gregorianCutover);
        String _UTC_DateString = this.utc_formatter.format(utcDate);
        if (this.convertToClientLocalTime) {
            Integer localOffset = this.getLocalOffset(_UTC_DateString);
            Date localClientDate = new Date(timeServerTime - this.gregorianCutover + (long)localOffset.intValue());
            String clientTime_DateString = this.utc_formatter.format(localClientDate);
            timeString = this.formatTimeToISO(clientTime_DateString, localOffset, true);
        } else if (this.convertToUTC_time) {
            Integer localOffset = null;
            timeString = this.formatTimeToISO(_UTC_DateString, localOffset, false);
        }
        return timeString;
    }

    public String getCurrentTime() {
        String timeString = null;
        if (this.convertToClientLocalTime) {
            long time = System.currentTimeMillis();
            Date date = new Date(time);
            String dateString = this.clientTime_formatter.format(date);
            Integer localOffset = new Integer(Calendar.getInstance().get(15) + Calendar.getInstance().get(16));
            timeString = this.formatTimeToISO(dateString, localOffset, true);
        } else if (this.convertToUTC_time) {
            timeString = this.get_current_node_UTC_time();
        }
        return timeString;
    }

    public String get_current_node_UTC_time() {
        String timeString = null;
        try {
            MOProxy myElementDataMO = new MOProxy("ManagedElement=1,ManagedElementData=1");
            Long aLong = (Long)myElementDataMO.getAttribute("nodeUTCTime");
            Date date = new Date(aLong);
            String dateString = this.utc_formatter.format(date);
            Integer localOffset = null;
            timeString = this.formatTimeToISO(dateString, localOffset, false);
        }
        catch (Exception e) {
            Log.logNotify("Unable to fetch time from the node. " + e.getMessage());
        }
        return timeString;
    }

    public String formatTime(String dateString) {
        String timeString = null;
        String _UTC_DateString = null;
        String clientTime_DateString = null;
        Date parsedDate = null;
        boolean formatSuccessfull = false;
        boolean dateWithoutTime = false;
        boolean dateContainsMilliseconds = false;
        if (dateString.trim().equals("") || dateString == null) {
            return dateString;
        }
        try {
            for (int i = 0; i < this.formatterType.length; ++i) {
                if (formatSuccessfull) continue;
                try {
                    if (formatSuccessfull) continue;
                    parsedDate = this.formatterType[i].parse(dateString);
                    formatSuccessfull = true;
                    if (i == 4 || i == 5) {
                        dateWithoutTime = true;
                        continue;
                    }
                    if (i != 2) continue;
                    dateContainsMilliseconds = true;
                    continue;
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (!formatSuccessfull) {
                throw new Exception();
            }
            _UTC_DateString = dateContainsMilliseconds ? this.utc_formatterWithMilliseconds.format(parsedDate) : this.utc_formatter.format(parsedDate);
            if (this.convertToClientLocalTime) {
                long _UTC_DateInMilliseconds = parsedDate.getTime();
                Integer localOffset = this.getLocalOffset(_UTC_DateString);
                Date localClientDate = new Date(_UTC_DateInMilliseconds + (long)localOffset.intValue());
                clientTime_DateString = dateContainsMilliseconds ? this.utc_formatterWithMilliseconds.format(localClientDate) : this.utc_formatter.format(localClientDate);
                timeString = this.formatTimeToISO(clientTime_DateString, localOffset, true);
            } else if (this.convertToUTC_time) {
                Integer localOffset = null;
                timeString = this.formatTimeToISO(_UTC_DateString, localOffset, false);
            }
            if (dateWithoutTime) {
                return timeString.substring(0, 10);
            }
            return timeString;
        }
        catch (Exception e) {
            Log.logWarning("Not possible to parse the string date:" + dateString);
            if (this.convertToClientLocalTime) {
                return "UTC Time: " + dateString;
            }
            return dateString;
        }
    }

    private String formatTimeToISO(String dateString, Integer localOffset, boolean formatWithClientTime) {
        String offsetString = null;
        String sign = null;
        if (formatWithClientTime) {
            sign = "+";
            if (localOffset < 0) {
                sign = "-";
            }
            long hourOffset = Math.abs(localOffset) / 1000 / 60 / 60;
            offsetString = Math.abs(localOffset) < 36000000 ? "0" + Math.abs(localOffset) / 1000 / 60 / 60 : "" + Math.abs(localOffset) / 1000 / 60 / 60;
            long minoffset = ((long)Math.abs(localOffset) - hourOffset * 60L * 60L * 1000L) / 1000L / 60L;
            offsetString = minoffset == 0L ? offsetString + ":00" : offsetString + ":" + minoffset;
        } else {
            sign = "Z";
            offsetString = "";
        }
        String fomattedTime = dateString + sign + offsetString;
        return fomattedTime;
    }

    private Integer getLocalOffset(String utc_date) {
        int year = Integer.parseInt(utc_date.substring(0, 4));
        int month = Integer.parseInt(utc_date.substring(5, 7));
        int day = Integer.parseInt(utc_date.substring(8, 10));
        int hours = Integer.parseInt(utc_date.substring(11, 13));
        int minutes = Integer.parseInt(utc_date.substring(14, 16));
        int seconds = Integer.parseInt(utc_date.substring(17, 19));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(year, --month, day, hours, minutes, seconds);
        int zone_offset = gregorianCalendar.get(15);
        int dst_offset = gregorianCalendar.get(16);
        Integer total_offset = new Integer(zone_offset + dst_offset);
        return total_offset;
    }
}

