/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.MORef;
import BasicConfig.MORefHelper;
import BasicConfig.MORefSeqHelper;
import BasicConfig.MOidpair;
import BasicConfig.MOidpairHelper;
import BasicConfig.MOidpairSeqHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.NameValuePair;
import se.ericsson.cello.configirpimpl.helpers.BooleanSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.FloatSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.LongLongSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.LongSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.StringSeqHelper;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.CSFacade;
import se.ericsson.cello.support.proxy.MOName;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class AnyMapping {
    public static java.lang.Object any2object(Any value) throws IllegalArgumentException, CSException {
        TypeCode tc = value.type();
        try {
            if (tc.kind() == TCKind.tk_void) {
                return null;
            }
            if (tc.kind() == TCKind.tk_long) {
                return new Integer(value.extract_long());
            }
            if (tc.kind() == TCKind.tk_float) {
                return new Float(value.extract_float());
            }
            if (tc.kind() == TCKind.tk_string) {
                return value.extract_string();
            }
            if (tc.kind() == TCKind.tk_boolean) {
                return Boolean.valueOf(String.valueOf(value.extract_boolean()));
            }
            if (tc.kind() == TCKind.tk_longlong) {
                return new Long(value.extract_longlong());
            }
            if (tc.equal(MORefHelper.type())) {
                MORef moRef = MORefHelper.extract(value);
                CSFacade cs = null;
                cs = CSFacade.getInstance();
                MOName dn = cs.getDN(moRef);
                MOProxy moProxy = null;
                moProxy = dn == null ? new MOProxy("") : new MOProxy(dn);
                return moProxy;
            }
            if (tc.equal(MORefSeqHelper.type())) {
                MORef[] moRef = MORefSeqHelper.extract(value);
                CSFacade cs = null;
                cs = CSFacade.getInstance();
                MOName[] dn = new MOName[moRef.length];
                MOProxy[] moProxy = new MOProxy[moRef.length];
                for (int i = 0; i < moRef.length; ++i) {
                    dn[i] = cs.getDN(moRef[i]);
                    moProxy[i] = new MOProxy(dn[i]);
                }
                return moProxy;
            }
            if (tc.kind() == TCKind.tk_struct) {
                DynStruct dynStruct = null;
                ORB orb = EmasFramework.getORB();
                try {
                    DynAnyFactory factory = DynAnyFactoryHelper.narrow((Object)orb.resolve_initial_references("DynAnyFactory"));
                    dynStruct = DynStructHelper.narrow((Object)factory.create_dyn_any(value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                NameValuePair[] nvList = dynStruct.get_members();
                NameValue[] myList = new NameValue[nvList.length];
                for (int i = 0; i < nvList.length; ++i) {
                    myList[i] = new NameValue(nvList[i].id, AnyMapping.any2object(nvList[i].value));
                }
                Struct myStruct = new Struct(myList);
                dynStruct.destroy();
                return myStruct;
            }
            if (tc.kind() == TCKind.tk_sequence) {
                return AnyMapping.seq2object(value);
            }
            if (tc.kind() == TCKind.tk_alias) {
                return AnyMapping.seq2object(value);
            }
            if (tc.kind() == MOidpairHelper.type().kind()) {
                MOidpair idPair = MOidpairHelper.extract(value);
                MOName moName = new MOName(idPair.name());
                String dn = moName.toString();
                MOProxy moProxy = new MOProxy(dn);
                return moProxy;
            }
        }
        catch (Exception x) {
            Log.logNotify("AnyMapping: " + x.getMessage());
        }
        throw new IllegalArgumentException("type in Any isn't supported");
    }

    private static java.lang.Object seq2object(Any value) throws IllegalArgumentException, CSException {
        TypeCode elementTC = null;
        try {
            TypeCode tc = value.type();
            elementTC = tc.kind() == TCKind.tk_sequence && value.type().content_type().kind() == TCKind.tk_struct ? value.type().content_type() : value.type().content_type().content_type();
        }
        catch (Exception x) {
            try {
                elementTC = value.type().content_type();
            }
            catch (Exception e) {
                Log.logNotify("AnyMapping: " + e.getMessage());
                return null;
            }
        }
        if (elementTC.kind() == TCKind.tk_short) {
            return null;
        }
        if (elementTC.kind() == TCKind.tk_long) {
            int[] result = LongSeqHelper.extract(value);
            return result;
        }
        if (elementTC.kind() == TCKind.tk_float) {
            float[] floats = FloatSeqHelper.extract(value);
            return floats;
        }
        if (elementTC.kind() == TCKind.tk_string) {
            return StringSeqHelper.extract(value);
        }
        if (elementTC.kind() == TCKind.tk_boolean) {
            return BooleanSeqHelper.extract(value);
        }
        if (elementTC.kind() == TCKind.tk_longlong) {
            return LongLongSeqHelper.extract(value);
        }
        if (elementTC.kind() == TCKind.tk_struct) {
            Any[] myArray = null;
            DynStruct dynStruct = null;
            ORB orb = EmasFramework.getORB();
            try {
                DynAnyFactory factory1 = DynAnyFactoryHelper.narrow((Object)orb.resolve_initial_references("DynAnyFactory"));
                DynSequence dynSequence = (DynSequence)factory1.create_dyn_any(value);
                myArray = dynSequence.get_elements();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Struct[] rv = new Struct[myArray.length];
            for (int i = 0; i < myArray.length; ++i) {
                try {
                    DynAnyFactory factory = DynAnyFactoryHelper.narrow((Object)orb.resolve_initial_references("DynAnyFactory"));
                    dynStruct = DynStructHelper.narrow((Object)factory.create_dyn_any(myArray[i]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                NameValuePair[] nvList = dynStruct.get_members();
                NameValue[] myList = new NameValue[nvList.length];
                for (int j = 0; j < nvList.length; ++j) {
                    myList[j] = new NameValue(nvList[j].id, AnyMapping.any2object(nvList[j].value));
                }
                rv[i] = new Struct(myList);
                dynStruct.destroy();
            }
            return rv;
        }
        if (elementTC.kind() == MOidpairHelper.type().kind()) {
            MOidpair[] idPairs = MOidpairSeqHelper.extract(value);
            MOProxy[] rv = new MOProxy[idPairs.length];
            for (int i = 0; i < idPairs.length; ++i) {
                MOName moName = new MOName(idPairs[i].name());
                String dn = moName.toString();
                MOProxy moProxy = null;
                rv[i] = moProxy = new MOProxy(dn);
            }
            return rv;
        }
        if (elementTC.equal(MORefHelper.type())) {
            MORef moRef = MORefHelper.extract(value);
            CSFacade cs = null;
            cs = CSFacade.getInstance();
            MOName dn = cs.getDN(moRef);
            MOProxy moProxy = new MOProxy(dn);
            return moProxy;
        }
        throw new IllegalArgumentException("type in Any is not supported");
    }

    public static Any object2any(java.lang.Object o) {
        if (o instanceof Struct) {
            return AnyMapping.createAnyStruct((Struct)o);
        }
        if (o instanceof Struct[]) {
            return AnyMapping.createAnySeqStruct((Struct[])o);
        }
        ORB orb = EmasFramework.getORB();
        Any res = orb.create_any();
        AnyMapping.insertObjectInAny(o, res);
        return res;
    }

    private static void insertObjectInAny(java.lang.Object o, Any any) {
        if (o instanceof Integer) {
            any.insert_long(((Integer)o).intValue());
        } else if (o instanceof String) {
            any.insert_string((String)o);
        } else if (o instanceof Float) {
            any.insert_float(((Float)o).floatValue());
        } else if (o instanceof MOProxy) {
            MOProxy moProxy = (MOProxy)o;
            String dn = moProxy.getDN();
            MOName moName = new MOName(dn);
            MOidpair idPair = moName.getMOidpair();
            MOidpairHelper.insert(any, idPair);
        } else if (o instanceof Boolean) {
            any.insert_boolean(((Boolean)o).booleanValue());
        } else if (o instanceof MOidpair) {
            MOidpairHelper.insert(any, (MOidpair)o);
        } else if (o instanceof MORef) {
            MORefHelper.insert(any, (MORef)o);
        } else if (o instanceof MOidpair[]) {
            MOidpairSeqHelper.insert(any, (MOidpair[])o);
        } else if (o instanceof MORef[]) {
            MORefSeqHelper.insert(any, (MORef[])o);
        } else if (o instanceof Integer[]) {
            int len = ((Integer[])o).length;
            int[] jan = new int[len];
            for (int i = 0; i < len; ++i) {
                jan[i] = ((Integer[])o)[i];
            }
            LongSeqHelper.insert(any, jan);
        } else if (o instanceof int[]) {
            LongSeqHelper.insert(any, (int[])o);
        } else if (o instanceof String[]) {
            StringSeqHelper.insert(any, (String[])o);
        } else if (o instanceof Float[]) {
            int len = ((Float[])o).length;
            float[] jan = new float[len];
            for (int i = 0; i < len; ++i) {
                jan[i] = ((Float[])o)[i].floatValue();
            }
            FloatSeqHelper.insert(any, jan);
        } else if (o instanceof float[]) {
            FloatSeqHelper.insert(any, (float[])o);
        } else if (o instanceof Boolean[]) {
            int len = ((Boolean[])o).length;
            boolean[] boolArr = new boolean[len];
            for (int i = 0; i < len; ++i) {
                boolArr[i] = ((Boolean[])o)[i];
            }
            BooleanSeqHelper.insert(any, boolArr);
        } else if (o instanceof boolean[]) {
            BooleanSeqHelper.insert(any, (boolean[])o);
        } else if (o instanceof MOProxy[]) {
            MOProxy[] rv = (MOProxy[])o;
            MOidpair[] idPairs = new MOidpair[rv.length];
            for (int i = 0; i < rv.length; ++i) {
                MOidpair idPair;
                MOName moName = new MOName(rv[i].getDN());
                idPairs[i] = idPair = moName.getMOidpair();
            }
            MOidpairSeqHelper.insert(any, idPairs);
        } else if (o instanceof Long) {
            any.insert_longlong(((Long)o).longValue());
        } else if (o instanceof Long[]) {
            int len = ((Long[])o).length;
            long[] arr = new long[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = ((Long[])o)[i];
            }
            LongLongSeqHelper.insert(any, arr);
        } else if (o instanceof long[]) {
            LongLongSeqHelper.insert(any, (long[])o);
        } else if (o == null) {
            MOName moName = new MOName();
            MOidpair idPair = moName.getMOidpair();
            MOidpairHelper.insert(any, idPair);
        }
    }

    private static Any createAnyStruct(Struct struct) {
        NameValue[] nameValues = struct.getNameValues();
        StructMember[] members = new StructMember[nameValues.length];
        Any[] anys = new Any[nameValues.length];
        for (int i = 0; i < struct.size(); ++i) {
            anys[i] = AnyMapping.object2any(nameValues[i].value);
            members[i] = new StructMember(nameValues[i].name, anys[i].type(), null);
        }
        ORB orb = EmasFramework.getORB();
        TypeCode tc = orb.create_struct_tc("IDL:Anonymous:1.0", "Anonymous", members);
        NameValuePair[] nvList = new NameValuePair[nameValues.length];
        for (int i = 0; i < struct.size(); ++i) {
            nvList[i] = new NameValuePair(nameValues[i].name, anys[i]);
        }
        try {
            DynAnyFactory factory = DynAnyFactoryHelper.narrow((Object)orb.resolve_initial_references("DynAnyFactory"));
            DynStruct dynStruct = DynStructHelper.narrow((Object)factory.create_dyn_any_from_type_code(tc));
            dynStruct.set_members(nvList);
            return dynStruct.to_any();
        }
        catch (UserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Any createAnySeqStruct(Struct[] structSeq) {
        Struct[] structArr = structSeq;
        int size = structArr.length;
        Any[] anySeq = new Any[size];
        for (int i = 0; i < size; ++i) {
            anySeq[i] = AnyMapping.createAnyStruct(structArr[i]);
        }
        ORB orb = EmasFramework.getORB();
        TypeCode seqType = size > 0 ? orb.create_sequence_tc(size, anySeq[0].type()) : orb.create_sequence_tc(size, orb.get_primitive_tc(TCKind.tk_short));
        DynAnyFactory factory = null;
        DynSequence dynSequence = null;
        try {
            factory = DynAnyFactoryHelper.narrow((Object)orb.resolve_initial_references("DynAnyFactory"));
            dynSequence = DynSequenceHelper.narrow((Object)factory.create_dyn_any_from_type_code(seqType));
            dynSequence.set_elements(anySeq);
            return dynSequence.to_any();
        }
        catch (UserException e) {
            e.printStackTrace();
            return dynSequence.to_any();
        }
    }
}

