/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.AlreadyDefined;
import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import BasicConfig.ProcessingFailure;
import BasicConfig.SecurityViolation;
import BasicConfig.TransactionFailure;
import BasicConfig.UnsupportedQoS;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;

public class BaseException
extends Exception {
    private static final long serialVersionUID = 7066830355067566806L;
    public static final String stackTraceTag = "stack trace = ";
    public static final String unknownTag = "Unknown";
    private Vector sourceExceptions = null;
    private static final short QOS_NONE = 0;
    private static final short QOS_MIBS = 1;
    private static final short QOS_NOTIFICATIONS = 2;
    private static final short QOS_MG = 4;
    private static final short QOS_HOPPER_SL = 8;
    private static final short QOS_FINEGRAINED = 16;
    private static final short QOS_DISTRIBUTION = 32;

    public BaseException(String message) {
        super(message);
        this.initialize();
    }

    public BaseException(Exception source, String sourceInfo) {
        super("");
        this.initialize();
        this.addSourceException(source, sourceInfo);
    }

    public BaseException(String message, Exception source, String sourceInfo) {
        super(message);
        this.initialize();
        this.addSourceException(source, sourceInfo);
    }

    public void addSourceException(Exception source, String sourceInfo) {
        if (source != null) {
            this.sourceExceptions.addElement(new SourceException(source, sourceInfo));
        }
    }

    public Exception getException() {
        Exception e = null;
        Enumeration enumeration = this.sourceExceptions.elements();
        if (enumeration.hasMoreElements()) {
            e = ((SourceException)enumeration.nextElement()).exception;
        }
        return e;
    }

    public String getExceptionTag() {
        Exception e = this.getException();
        String tag = unknownTag;
        if (e instanceof ProcessingFailure) {
            ProcessingFailure ePF = (ProcessingFailure)((Object)e);
            String reason = ePF.reason;
            int index = reason.indexOf("TAG");
            if (index > 0) {
                String tmpString = reason.substring(index + 6);
                index = tmpString.indexOf(34);
                tag = tmpString.substring(0, index);
            } else {
                tag = "ProcessingFailure";
            }
        } else if (e instanceof NotDefined) {
            tag = "NotDefined";
        } else if (e instanceof AlreadyDefined) {
            tag = "AlreadyDefined";
        } else if (e instanceof SecurityViolation) {
            tag = "SecurityViolation";
        } else if (e instanceof NotAccepted) {
            tag = "NotAccepted";
        } else if (e instanceof UnsupportedQoS) {
            tag = "UnsupportedQos";
        } else if (e instanceof TransactionFailure) {
            tag = "TransactionFailure";
        }
        return tag;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringBuffer buffer = new StringBuffer();
        String result = "";
        buffer.append(this.getMessage());
        buffer.append("\n");
        Enumeration enumeration = this.sourceExceptions.elements();
        while (enumeration.hasMoreElements()) {
            SourceException se = (SourceException)enumeration.nextElement();
            se.exception.printStackTrace(pw);
            buffer.append(se.exception.toString());
            buffer.append("\n");
            buffer.append(se.info);
            String r = this.getReason(se.exception);
            if (-1 == buffer.toString().indexOf(r)) {
                buffer.append("\n");
                buffer.append(r);
            }
            buffer.append("\n");
            buffer.append(stackTraceTag);
            buffer.append(sw.toString());
        }
        result = buffer.toString();
        return result;
    }

    public String getReason(Exception e) {
        String reason = "";
        if (e instanceof ProcessingFailure) {
            reason = ((ProcessingFailure)((Object)e)).reason;
        } else if (e instanceof NotDefined) {
            reason = ((NotDefined)((Object)e)).info;
        } else if (e instanceof AlreadyDefined) {
            reason = ((AlreadyDefined)((Object)e)).info;
        } else if (e instanceof SecurityViolation) {
            reason = ((SecurityViolation)((Object)e)).reason;
        } else if (e instanceof NotAccepted) {
            reason = ((NotAccepted)((Object)e)).info;
        } else if (e instanceof TransactionFailure) {
            reason = ((TransactionFailure)((Object)e)).reason;
        } else if (e instanceof UnsupportedQoS) {
            reason = "Supported QoS:";
            short[] suppQs = ((UnsupportedQoS)((Object)e)).supportedQoS;
            block9: for (int i = 0; i < suppQs.length; ++i) {
                switch (suppQs[i]) {
                    case 0: {
                        reason = reason + " QOS_NONE";
                        continue block9;
                    }
                    case 1: {
                        reason = reason + " QOS_MIBS";
                        continue block9;
                    }
                    case 2: {
                        reason = reason + " QOS_NOTIFICATIONS";
                        continue block9;
                    }
                    case 4: {
                        reason = reason + " QOS_MG";
                        continue block9;
                    }
                    case 8: {
                        reason = reason + " QOS_HOPPER_SL";
                        continue block9;
                    }
                    case 16: {
                        reason = reason + " QOS_FINEGRAINED";
                        continue block9;
                    }
                    case 32: {
                        reason = reason + " QOS_DISTRIBUTION";
                    }
                }
            }
        }
        return reason;
    }

    private void initialize() {
        this.sourceExceptions = new Vector();
    }

    private static class SourceException {
        public Exception exception;
        public String info;

        public SourceException(Exception exception, String exceptionInfo) {
            this.exception = exception;
            this.info = exceptionInfo;
        }
    }
}

