/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.AlreadyDefined;
import BasicConfig.AttrIterRef;
import BasicConfig.AttrMORefSeqHolder;
import BasicConfig.Filter;
import BasicConfig.MGRef;
import BasicConfig.MIBInfo;
import BasicConfig.MIBRef;
import BasicConfig.MOAssociation;
import BasicConfig.MORef;
import BasicConfig.MOidpair;
import BasicConfig.NameValueSeqHolder;
import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import BasicConfig.ProcessingFailure;
import BasicConfig.SecurityViolation;
import BasicConfig.Session;
import BasicConfig.TransactionFailure;
import BasicConfig.UnsupportedQoS;
import ConfigExtended.AVCNotification;
import ConfigExtended.ConfigNotification;
import ConfigExtended.ConfigurationExtended;
import ConfigExtended.ConfigurationExtendedHelper;
import ConfigExtended.MOInfo;
import ConfigExtended.MOInfoSeqHolder;
import ConfigExtended.NotificationConsumer;
import ConfigExtended.NotificationConsumerHelper;
import ConfigExtended.NotificationConsumerPOA;
import ConfigExtended.NotificationKind;
import ConfigExtended.NotificationProducer;
import ConfigExtended.NotificationProducerPackage.NotificationFilter;
import ConfigExtended.RequestedAttributes;
import ConfigExtended.ReturnedAttributes;
import ConfigExtended.TopologyNotification;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.Logger;
import se.ericsson.cello.support.proxy.AnyMapping;
import se.ericsson.cello.support.proxy.CORBAManager;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.ExceptionHandler;
import se.ericsson.cello.support.proxy.LocalObjectManagerException;
import se.ericsson.cello.support.proxy.MOName;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.RemoteObjectManagerException;
import se.ericsson.cello.support.proxy.RequestedAttributeSeq;
import se.ericsson.cello.support.proxy.ThreadQueue;

public class CSFacade {
    public static final String CS_NAME = "CelloConfigurationService";
    private boolean securityMessage = false;
    private static CORBAManager corbaManager;
    private static ConfigurationExtended config;
    private static NotificationProducer producer;
    private static boolean exitNow;
    private Consumer consumer = new Consumer();
    private ThreadQueue notificationQueue = new ThreadQueue();
    private final int numNotificationThreads = 10;
    private NotificationThread[] notificationThreads = new NotificationThread[10];
    private static final java.lang.Object NO_MORE_WORK;
    private static NotificationConsumer narrowed_consumer;
    private Poller poller = new Poller();
    private static IntHolder subscriptionId;
    private static NotificationFilter Notfilter;
    private static final int POLLPERIOD = 20000;
    private static final int TIMEOUT = 60;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int DEFAULT_BULKSIZE = 100;
    private static MOName moName;
    private static int bulkSize;
    private static Session session;
    private static MIBRef mib;
    private static MIBInfo mibInfo;
    private static String mibPrefix;
    private static String impl;
    private static CSFacade theCSFacade;
    private static Vector overflowSubscribers;
    private static Hashtable subscribers;
    private static Vector unspecifiedSubscribers;
    private static Logger attributesLog;
    private static Logger createDeleteLog;
    private static Logger notifyLog;
    private static Logger actionLog;
    private static Logger moLog;
    private static Logger moExceptionLog;
    private boolean notificationDown = false;
    private static final String AUTH_WRITE_ERROR = "A Configuration Management write operation was not authorized. This problem may be caused by one of the following reasons:\n    - Not sufficient user privileges. Please contact your System Administrator.\n    - Other security reason.";
    private static final String AUTH_READ_ERROR = "A Configuration Management read operation was not authorized. This problem may be caused by one of the following reasons:\n    - Not sufficient user privileges. Please contact your System Administrator.\n    - Other security reason.";
    private static final String OTHER_CORBA_ERROR = "An error occured while communicating with the node.";

    public void subscribeOverflow(OverflowSubscriber os) {
        overflowSubscribers.addElement(os);
    }

    public void unsubscribeOverflow(OverflowSubscriber os) {
        overflowSubscribers.removeElement(os);
    }

    public void subscribe(Subscriber s, MOName aLDN) {
        Vector<Subscriber> v = (Vector<Subscriber>)subscribers.get(aLDN);
        if (v == null) {
            v = new Vector<Subscriber>();
            subscribers.put(aLDN, v);
        }
        v.addElement(s);
        if (notifyLog.isLoggable(Level.FINE)) {
            notifyLog.log(Level.FINE, "add notify subscriber", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "subscribe", new Long(-1L), this.whoCalled()});
        }
    }

    public void unsubscribe(Subscriber s, MOName aLDN) {
        Vector v = (Vector)subscribers.get(aLDN);
        if (v != null) {
            v.removeElement(s);
        }
        if (notifyLog.isLoggable(Level.FINE)) {
            notifyLog.log(Level.FINE, "delete notify subscriber", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "unsubscribe", new Long(-1L), this.whoCalled()});
        }
    }

    public void subscribe(Subscriber s) {
        unspecifiedSubscribers.add(s);
    }

    public void unsubscribe(Subscriber s) {
        unspecifiedSubscribers.remove(s);
    }

    public void createMO(MOName aLDN) throws CSException {
        this.createMO(aLDN, new NameValue[0]);
    }

    public void createMO(MOName aLDN, Session aSession) throws CSException {
        this.createMO(aLDN, new NameValue[0], aSession);
    }

    public void createMO(MOName aLDN, NameValue[] someAttributes) throws CSException {
        this.createMO(aLDN, someAttributes, session);
    }

    public void createMO(MOName aLDN, NameValue[] someAttributes, Session aSession) throws CSException {
        long startTime = System.currentTimeMillis();
        String logString = "";
        String moId = aLDN.getId();
        String moType = aLDN.getType();
        MOName baseName = aLDN.getParentName();
        MOidpair baseId = baseName.getMOidpair();
        MORef objRef = null;
        MOidpair sourceId = MOName.NULL_ID;
        MOAssociation[] associations = new MOAssociation[]{};
        BasicConfig.NameValue[] attributes = new BasicConfig.NameValue[someAttributes.length];
        logString = logString + "\nAttributes \n";
        for (int i = 0; i < attributes.length; ++i) {
            String name = someAttributes[i].name.equals("guiName") ? "userLabel" : someAttributes[i].name;
            java.lang.Object o = someAttributes[i].value;
            if (o == null) {
                someAttributes[i].value = new MORef(0L, null, "");
            }
            if (o instanceof MOProxy) {
                try {
                    objRef = null;
                    String ldn = ((MOProxy)someAttributes[i].value).getDN();
                    MOName ref = new MOName(ldn);
                    MOidpair refId = ref.getMOidpair();
                    BasicConfig.MOInfo moInfo = config.basic_get_MO_info(refId, aSession);
                    objRef = moInfo.ref;
                    someAttributes[i].value = objRef;
                }
                catch (SecurityViolation e) {
                    Log.logError("Security Violation Exception ", (Throwable)((java.lang.Object)e));
                }
                catch (ProcessingFailure ex) {
                    Log.logError("ProcessingFailure Exception ", (Throwable)((java.lang.Object)ex));
                }
                catch (NotDefined exp) {
                    Log.logError("NotDefined Exception", (Throwable)((java.lang.Object)exp));
                }
            }
            if (o instanceof MOProxy[]) {
                MOProxy[] temp = (MOProxy[])o;
                MORef[] tempObjRef = new MORef[temp.length];
                try {
                    for (int k = 0; k < temp.length; ++k) {
                        objRef = null;
                        String ldn = temp[k].getDN();
                        MOName moName = new MOName(ldn);
                        MOidpair moidpair = moName.getMOidpair();
                        BasicConfig.MOInfo moInfo = config.basic_get_MO_info(moidpair, aSession);
                        tempObjRef[k] = objRef = moInfo.ref;
                    }
                }
                catch (SecurityViolation e) {
                    Log.logError("Security Violation Exception ", (Throwable)((java.lang.Object)e));
                }
                catch (ProcessingFailure ex) {
                    Log.logError("ProcessingFailure Exception ", (Throwable)((java.lang.Object)ex));
                }
                catch (NotDefined exp) {
                    Log.logError("NotDefined Exception", (Throwable)((java.lang.Object)exp));
                }
                someAttributes[i].value = tempObjRef;
            }
            Any value = AnyMapping.object2any(someAttributes[i].value);
            logString = someAttributes[i].name.toLowerCase().equals("password") ? logString + name + " = *****\n" : logString + name + " = " + someAttributes[i].value + "\n";
            attributes[i] = new BasicConfig.NameValue(name, value);
        }
        try {
            config.basic_create_MO(moId, moType, baseId, sourceId, attributes, associations, aSession);
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "createMO", new Long(-1L), this.whoCalled(), someAttributes, "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "createMO", new Long(-1L), this.whoCalled(), someAttributes, "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "createMO", new Long(-1L), this.whoCalled(), someAttributes, "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (AlreadyDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "AlreadyDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "createMO", new Long(-1L), this.whoCalled(), someAttributes, "AlreadyDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "createMO", new Long(-1L), this.whoCalled(), someAttributes, "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_WRITE_ERROR);
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to create " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        long logTime = System.currentTimeMillis() - startTime;
        if (createDeleteLog.isLoggable(Level.FINE)) {
            createDeleteLog.log(Level.FINE, logString, new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "createMO", new Long(logTime), this.whoCalled(), someAttributes});
        }
    }

    public void deleteMO(MOName aLDN, int aScope, Filter aFilter) throws CSException {
        this.deleteMO(aLDN, aScope, aFilter, session);
    }

    public void deleteMO(MOName aLDN, int aScope, Filter aFilter, Session aSession) throws CSException {
        long startTime = System.currentTimeMillis();
        MOidpair moId = aLDN.getMOidpair();
        MGRef mgRef = new MGRef(0L);
        try {
            config.basic_delete_MO(moId, mgRef, aScope, aFilter, aSession);
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "deleteMO", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "deleteMO", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "deleteMO", new Long(-1L), this.whoCalled(), "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "deleteMO", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_WRITE_ERROR);
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to delete " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        long logTime = System.currentTimeMillis() - startTime;
        if (createDeleteLog.isLoggable(Level.FINE)) {
            createDeleteLog.log(Level.FINE, "delete MO", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "deleteMO", new Long(logTime), this.whoCalled()});
        }
    }

    public java.lang.Object action(MOName aLDN, String anAction, NameValue[] someParameters) throws CSException {
        return this.action(aLDN, anAction, someParameters, session);
    }

    private NameValue[] convertGuinameToRDNValue(BasicConfig.NameValue[] attrSeq, RequestedAttributeSeq requestedAttributes) throws CSException {
        NameValue[] attrArray = new NameValue[attrSeq.length];
        for (int i = 0; i < attrSeq.length; ++i) {
            java.lang.Object object = AnyMapping.any2object(attrSeq[i].value);
            String attribute = attrSeq[i].name;
            if (requestedAttributes.attributes[i].equals("guiName")) {
                String ldn = requestedAttributes.getLdn();
                object = ldn.substring(ldn.lastIndexOf(44) + 1);
            }
            attrArray[i] = new NameValue(attrSeq[i].name, object);
        }
        return attrArray;
    }

    public java.lang.Object action(MOName aLDN, String anAction, NameValue[] someParameters, Session aSession) throws CSException {
        long startTime = System.currentTimeMillis();
        MOidpair moId = aLDN.getMOidpair();
        BasicConfig.NameValue[] parameters = new BasicConfig.NameValue[someParameters.length];
        NameValueSeqHolder parametersHolder = new NameValueSeqHolder(parameters);
        MORef objRef = null;
        for (int i = 0; i < parameters.length; ++i) {
            String name = someParameters[i].name;
            java.lang.Object o = someParameters[i].value;
            if (o == null) {
                someParameters[i].value = new MORef(0L, null, "");
            }
            if (o instanceof MOProxy) {
                try {
                    objRef = null;
                    String ldn = ((MOProxy)someParameters[i].value).getDN();
                    MOName moName = new MOName(ldn);
                    MOidpair moidpair = moName.getMOidpair();
                    BasicConfig.MOInfo moInfo = config.basic_get_MO_info(moidpair, aSession);
                    objRef = moInfo.ref;
                    someParameters[i].value = objRef;
                }
                catch (SecurityViolation e) {
                    Log.logError("Security Violation Exception ", (Throwable)((java.lang.Object)e));
                }
                catch (ProcessingFailure ex) {
                    Log.logError("ProcessingFailure Exception ", (Throwable)((java.lang.Object)ex));
                }
                catch (NotDefined exp) {
                    Log.logError("NotDefined Exception", (Throwable)((java.lang.Object)exp));
                }
            }
            if (o instanceof MOProxy[]) {
                MOProxy[] temp = (MOProxy[])o;
                MORef[] tempObjRef = new MORef[temp.length];
                try {
                    for (int k = 0; k < temp.length; ++k) {
                        objRef = null;
                        String ldn = temp[k].getDN();
                        MOName moName = new MOName(ldn);
                        MOidpair moidpair = moName.getMOidpair();
                        BasicConfig.MOInfo moInfo = config.basic_get_MO_info(moidpair, aSession);
                        objRef = moInfo.ref;
                        if (objRef == null) continue;
                        tempObjRef[k] = objRef;
                    }
                }
                catch (SecurityViolation e) {
                    Log.logError("Security Violation Exception ", (Throwable)((java.lang.Object)e));
                }
                catch (ProcessingFailure ex) {
                    Log.logError("ProcessingFailure Exception ", (Throwable)((java.lang.Object)ex));
                }
                catch (NotDefined exp) {
                    Log.logError("NotDefined Exception", (Throwable)((java.lang.Object)exp));
                }
                someParameters[i].value = tempObjRef;
            }
            Any value = AnyMapping.object2any(someParameters[i].value);
            parameters[i] = new BasicConfig.NameValue(name, value);
        }
        Any value = null;
        try {
            value = config.action(moId, anAction, parametersHolder, aSession);
        }
        catch (NotAccepted e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotAccepted exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(-1L), this.whoCalled(), someParameters, anAction, "NotAccepted exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(-1L), this.whoCalled(), someParameters, anAction, "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(-1L), this.whoCalled(), someParameters, anAction, "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(-1L), this.whoCalled(), someParameters, anAction, "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (UnsupportedQoS e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "UnsupportedQoS exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(-1L), this.whoCalled(), someParameters, anAction, "UnsupportedQoS exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_WRITE_ERROR);
        }
        catch (COMM_FAILURE e) {
            Log.logError("Error initializing Corba services", e);
            return null;
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to execute an action on " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        java.lang.Object returnValue = AnyMapping.any2object(value);
        BasicConfig.NameValue[] outParam = parametersHolder.value;
        for (int i = 0; i < someParameters.length; ++i) {
            java.lang.Object object;
            Any any = outParam[i].value;
            someParameters[i].value = object = AnyMapping.any2object(any);
        }
        long actionTime = System.currentTimeMillis() - startTime;
        actionLog.log(Level.FINE, "action", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "action", new Long(actionTime), this.whoCalled(), someParameters, anAction, returnValue});
        return returnValue;
    }

    public NameValue[] getMOAttributes(MOName aLDN) {
        return new NameValue[0];
    }

    public java.lang.Object[] getMOAttributes(MOName aLDN, String[] someAttributeNames, Filter aFilter) throws CSException {
        return this.getMOAttributes(aLDN, someAttributeNames, aFilter, session);
    }

    public java.lang.Object[] getMOAttributes(MOName aLDN, String[] someAttributeNames, Filter aFilter, Session aSession) throws CSException {
        if (someAttributeNames.length == 1 && someAttributeNames[0].equals("guiName")) {
            java.lang.Object[] returnArr = new String[]{aLDN.getLastRDN()};
            return returnArr;
        }
        long startTime = System.currentTimeMillis();
        int attrNumOfGuiName = 0;
        boolean isGuiName = false;
        String[] attributeNames = new String[someAttributeNames.length];
        for (int cnt = 0; cnt < someAttributeNames.length; ++cnt) {
            if (someAttributeNames[cnt].equals("guiName")) {
                attrNumOfGuiName = cnt;
                isGuiName = true;
                attributeNames[cnt] = "userLabel";
                continue;
            }
            attributeNames[cnt] = someAttributeNames[cnt];
        }
        NameValueSeqHolder holder = new NameValueSeqHolder();
        try {
            config.basic_get_MO_attributes(aLDN.getMOidpair(), attributeNames, holder, aSession);
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOAttributes", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOAttributes", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOAttributes", new Long(-1L), this.whoCalled(), "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOAttributes", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to get MO attributes for " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        BasicConfig.NameValue[] attrSeq = holder.value;
        NameValue[] logAttrArray = new NameValue[attrSeq.length];
        java.lang.Object[] attributeValues = new java.lang.Object[attrSeq.length];
        for (int i = 0; i < attrSeq.length; ++i) {
            java.lang.Object object = AnyMapping.any2object(attrSeq[i].value);
            String attribute = attrSeq[i].name;
            if (attribute.equals("userLabel") && isGuiName && attrNumOfGuiName == i) {
                object = aLDN.getLastRDN();
            }
            attributeValues[i] = object;
            logAttrArray[i] = new NameValue(attrSeq[i].name, object);
        }
        long getAttrTime = System.currentTimeMillis() - startTime;
        if (attributesLog.isLoggable(Level.FINE)) {
            attributesLog.log(Level.FINE, "getAttributes", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getAttributes", new Long(getAttrTime), this.whoCalled(), logAttrArray});
        }
        return attributeValues;
    }

    public NameValue[][] getMOAttributes(RequestedAttributeSeq[] someAttributes) throws CSException {
        return this.getMOAttributes(someAttributes, session);
    }

    public NameValue[][] getMOAttributes(RequestedAttributeSeq[] someAttributes, Session aSession) throws CSException {
        int i;
        long startTime = System.currentTimeMillis();
        NameValue[][] attributeValues = null;
        ReturnedAttributes[] toReturn = new ReturnedAttributes[someAttributes.length];
        RequestedAttributes[] attributes = null;
        for (i = 0; i < someAttributes.length; ++i) {
            int position = i % bulkSize;
            if (position == 0) {
                if (i > 0) {
                    this.getFromServer(toReturn, attributes, i - bulkSize, aSession);
                }
                if (someAttributes.length - i > bulkSize) {
                    if (attributes == null) {
                        attributes = new RequestedAttributes[bulkSize];
                    }
                } else {
                    attributes = new RequestedAttributes[someAttributes.length - i];
                }
            }
            String ldn = someAttributes[i].getLdn();
            String[] reqAttrForMo = new String[someAttributes[i].attributes.length];
            for (int j = 0; j < someAttributes[i].attributes.length; ++j) {
                reqAttrForMo[j] = someAttributes[i].attributes[j].equals("guiName") ? "userLabel" : someAttributes[i].attributes[j];
            }
            attributes[position] = new RequestedAttributes(ldn, reqAttrForMo);
        }
        this.getFromServer(toReturn, attributes, someAttributes.length - attributes.length, aSession);
        attributeValues = new NameValue[toReturn.length][];
        for (i = 0; i < toReturn.length; ++i) {
            attributeValues[i] = this.convertGuinameToRDNValue(toReturn[i].attributes, someAttributes[i]);
        }
        if (attributesLog.isLoggable(Level.FINE)) {
            long getAttrTime = System.currentTimeMillis() - startTime;
            attributesLog.log(Level.FINE, "getAttributes", new java.lang.Object[]{"Multiple MOs", "", "CSFacade", "getAttributes-bulk", new Long(getAttrTime), this.whoCalled()});
        }
        return attributeValues;
    }

    private void getFromServer(ReturnedAttributes[] toReturn, RequestedAttributes[] attributes, int begin, Session aSession) throws CSException {
        ReturnedAttributes[] partToReturn = null;
        try {
            partToReturn = config.get_MO_attributes(attributes, aSession);
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NotAccepted e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        System.arraycopy(partToReturn, 0, toReturn, begin, attributes.length);
    }

    public java.lang.Object getMOAttribute(MOName aLDN, String anAttributeName, Filter aFilter) throws CSException {
        return this.getMOAttribute(aLDN, anAttributeName, aFilter, session);
    }

    public java.lang.Object getMOAttribute(MOName aLDN, String anAttributeName, Filter aFilter, Session aSession) throws CSException {
        if (anAttributeName.equals("guiName")) {
            return aLDN.getLastRDN();
        }
        String[] nameSeq = new String[]{anAttributeName};
        java.lang.Object[] valueSeq = this.getMOAttributes(aLDN, nameSeq, aFilter, aSession);
        java.lang.Object attributeValue = valueSeq[0];
        return attributeValue;
    }

    public void setMOAttribute(MOName aLDN, String anAttributeName, java.lang.Object anAttributeValue) throws CSException {
        this.setMOAttribute(aLDN, anAttributeName, anAttributeValue, session);
    }

    public void setMOAttribute(MOName aLDN, String anAttributeName, java.lang.Object anAttributeValue, Session aSession) throws CSException {
        NameValue[] attrSeq = new NameValue[]{new NameValue(anAttributeName, anAttributeValue)};
        this.setMOAttributes(aLDN, attrSeq, aSession);
    }

    public void setMOAttributes(MOName aLDN, NameValue[] someAttributes) throws CSException {
        this.setMOAttributes(aLDN, someAttributes, session);
    }

    public void setMOAttributes(MOName aLDN, NameValue[] someAttributes, Session aSession) throws CSException {
        long startTime = System.currentTimeMillis();
        MOidpair moId = aLDN.getMOidpair();
        BasicConfig.NameValue[] attributes = new BasicConfig.NameValue[someAttributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            String name = someAttributes[i].name.equals("guiName") ? "userLabel" : someAttributes[i].name;
            MORef objRef = null;
            java.lang.Object o = someAttributes[i].value;
            if (o == null) {
                someAttributes[i].value = new MORef(0L, null, "");
            }
            if (o instanceof MOProxy) {
                try {
                    String ldn = ((MOProxy)someAttributes[i].value).getDN();
                    MOName moName = new MOName(ldn);
                    MOidpair moidpair = moName.getMOidpair();
                    BasicConfig.MOInfo moInfo = config.basic_get_MO_info(moidpair, aSession);
                    objRef = moInfo.ref;
                    someAttributes[i].value = objRef;
                }
                catch (SecurityViolation e) {
                }
                catch (ProcessingFailure ex) {
                }
                catch (NotDefined exp) {
                    // empty catch block
                }
            }
            if (o instanceof MOProxy[]) {
                MOProxy[] temp = (MOProxy[])o;
                MORef[] tempObjRef = new MORef[temp.length];
                try {
                    for (int k = 0; k < temp.length; ++k) {
                        objRef = null;
                        String ldn = temp[k].getDN();
                        MOName moName = new MOName(ldn);
                        MOidpair moidpair = moName.getMOidpair();
                        BasicConfig.MOInfo moInfo = config.basic_get_MO_info(moidpair, aSession);
                        tempObjRef[k] = objRef = moInfo.ref;
                    }
                }
                catch (SecurityViolation e) {
                    Log.logError("Security Violation Exception ", (Throwable)((java.lang.Object)e));
                }
                catch (ProcessingFailure ex) {
                    Log.logError("ProcessingFailure Exception ", (Throwable)((java.lang.Object)ex));
                }
                catch (NotDefined exp) {
                    Log.logError("NotDefined Exception", (Throwable)((java.lang.Object)exp));
                }
                someAttributes[i].value = tempObjRef;
            }
            Any value = AnyMapping.object2any(someAttributes[i].value);
            attributes[i] = new BasicConfig.NameValue(name, value);
        }
        try {
            config.basic_set_MO_attributes(moId, attributes, aSession);
        }
        catch (NotAccepted e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotAccepted exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "setMOAttributes", new Long(-1L), this.whoCalled(), someAttributes, "NotAccepted exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "setMOAttributes", new Long(-1L), this.whoCalled(), someAttributes, "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "setMOAttributes", new Long(-1L), this.whoCalled(), someAttributes, "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "setMOAttributes", new Long(-1L), this.whoCalled(), someAttributes, "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "setMOAttributes", new Long(-1L), this.whoCalled(), someAttributes, "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_WRITE_ERROR);
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to set MO attributes for " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        long setAttrTime = System.currentTimeMillis() - startTime;
        if (attributesLog.isLoggable(Level.FINE)) {
            attributesLog.log(Level.FINE, "setAttributes", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "setAttributes", new Long(setAttrTime), this.whoCalled(), someAttributes});
        }
    }

    public String getMIBPrefix() {
        return mibPrefix;
    }

    public MOName[] getMOChildren(MOName aLDN, int aScope, Filter aFilter) throws CSException {
        return this.getMOChildren(aLDN, aScope, aFilter, session);
    }

    public MOName[] getMOChildren(MOName aLDN, int aScope, Filter aFilter, Session aSession) throws CSException {
        MOName[] moDNs;
        long startTime = System.currentTimeMillis();
        String moId = aLDN.toString();
        MOInfoSeqHolder result = new MOInfoSeqHolder();
        boolean found = true;
        Vector<MOName> resultVector = new Vector<MOName>();
        try {
            int iter = config.get_MO_containment(moId, aScope, aFilter, aSession);
            while (found) {
                found = config.next_MO_info(iter, 1000, aSession, result);
                MOInfo[] info = result.value;
                moDNs = new MOName[info.length];
                for (int i = 0; i < info.length; ++i) {
                    resultVector.add(new MOName(info[i].localDN));
                }
            }
            moDNs = resultVector.toArray(new MOName[resultVector.size()]);
            config.delete_MO_info_iter(iter, null);
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        catch (COMM_FAILURE e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "CORBA::COMM_FAILURE exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (TRANSIENT e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "CORBA::TRANSIENT exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (OBJECT_NOT_EXIST e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(-1L), this.whoCalled(), "CORBA::OBJECT_NOT_EXIST exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to get MO children of " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        long duration = System.currentTimeMillis() - startTime;
        if (moLog.isLoggable(Level.FINE)) {
            moLog.log(Level.FINE, "getMOChildren", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "getMOChildren", new Long(duration), this.whoCalled()});
        }
        return moDNs;
    }

    public boolean moHasChildren(MOName aLDN, int aScope, Filter aFilter, Session aSession) throws CSException {
        String moId = aLDN.toString();
        MOInfoSeqHolder result = new MOInfoSeqHolder();
        boolean found = false;
        try {
            int iter = config.get_MO_containment(moId, aScope, aFilter, aSession);
            found = config.next_MO_info(iter, 1, aSession, result);
            config.delete_MO_info_iter(iter, null);
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        return found;
    }

    public boolean moHasChildren(MOName aLDN, int aScope, Filter aFilter) throws CSException {
        return this.moHasChildren(aLDN, aScope, aFilter, session);
    }

    public MOName getRootMOName() throws CSException {
        return this.getRootMOName(session);
    }

    public MOName getRootMOName(Session aSession) throws CSException {
        if (moName == null) {
            long startTime = System.currentTimeMillis();
            try {
                MOInfo moInfo = config.get_root_MO(aSession);
                moName = new MOName(moInfo.localDN);
            }
            catch (ProcessingFailure e) {
                if (moExceptionLog.isLoggable(Level.FINE)) {
                    moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{"", "", "CSFacade", "getRootMOName", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
                }
                throw ExceptionHandler.map(e, "");
            }
            catch (SecurityViolation e) {
                if (moExceptionLog.isLoggable(Level.FINE)) {
                    moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{"", "", "CSFacade", "getRootMOName", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
                }
                throw ExceptionHandler.map(e, "");
            }
            catch (NotDefined e) {
                if (moExceptionLog.isLoggable(Level.FINE)) {
                    moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{"", "", "CSFacade", "getRootMOName", new Long(-1L), this.whoCalled(), "NotDefined exception"});
                }
                throw ExceptionHandler.map(e, "");
            }
            catch (NO_PERMISSION e) {
                if (moExceptionLog.isLoggable(Level.FINE)) {
                    moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{"", "", "CSFacade", "getRootMOName", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
                }
                throw ExceptionHandler.map(e, AUTH_READ_ERROR);
            }
            catch (SystemException e) {
                Log.logError("CORBA exception when trying to get root MO name", e);
                throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
            }
            long duration = System.currentTimeMillis() - startTime;
            if (moLog.isLoggable(Level.FINE)) {
                moLog.log(Level.FINE, "getRootMOName", new java.lang.Object[]{"", "", "CSFacade", "getRootMOName", new Long(duration), this.whoCalled()});
            }
        }
        return moName;
    }

    public boolean isMO(MOName aLDN) throws CSException {
        return this.isMO(aLDN, session);
    }

    public boolean isMO(MOName aLDN, Session aSession) throws CSException {
        long startTime = System.currentTimeMillis();
        boolean moExists = false;
        try {
            MOidpair idPair = new MOidpair();
            CosNaming.NameComponent[] nameSeq = aLDN.getNameComponentSeq();
            idPair.name(nameSeq);
            moExists = config.basic_is_existing(idPair, aSession);
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "isMO", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "isMO", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "isMO", new Long(-1L), this.whoCalled(), "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "isMO", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to verify that the MO exist: " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        long duration = System.currentTimeMillis() - startTime;
        if (moLog.isLoggable(Level.FINE)) {
            moLog.log(Level.FINE, "isMO", new java.lang.Object[]{aLDN, aLDN.getType(), "CSFacade", "isMO", new Long(duration), this.whoCalled()});
        }
        return moExists;
    }

    public void beginTransaction() throws CSException {
        try {
            session.restart();
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
    }

    public void endTransaction(boolean aCommit) throws CSException {
        try {
            if (aCommit) {
                session.commit();
            } else {
                session.rollback();
            }
        }
        catch (TransactionFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
    }

    public static CSFacade getInstance() {
        return theCSFacade;
    }

    public static void cleanup() {
        Log.logNotify("cleanup of CSFacade called");
        config = null;
        corbaManager = null;
        narrowed_consumer = null;
        producer = null;
        subscriptionId = null;
        if (CSFacade.getInstance() != null) {
            CSFacade.getInstance().closeNotificationThreads();
        }
        theCSFacade = null;
        subscriptionId = new IntHolder();
    }

    public void dispose() {
        Log.logNotify("dispose of CSFacade called");
        exitNow = true;
        config = null;
        corbaManager = null;
        this.closeNotificationThreads();
        narrowed_consumer = null;
        subscriptionId = null;
        this.consumer = null;
        this.poller = null;
        this.notificationQueue = null;
        attributesLog = null;
        createDeleteLog = null;
        notifyLog = null;
        actionLog = null;
        moLog = null;
        moExceptionLog = null;
        theCSFacade = null;
    }

    public static synchronized void init(NamingContext aNamingContext) throws CSException, LocalObjectManagerException, RemoteObjectManagerException {
        if (theCSFacade != null) {
            theCSFacade = null;
        }
        theCSFacade = new CSFacade(aNamingContext);
    }

    public static synchronized void init(CORBAManager aCORBAManager) throws CSException, LocalObjectManagerException, RemoteObjectManagerException {
        theCSFacade = new CSFacade(aCORBAManager);
    }

    public static void init(CSFacade anImplementation) {
        theCSFacade = anImplementation;
    }

    public MOName getDN(MORef anMORef) throws CSException {
        return this.getDN(anMORef, session);
    }

    MOName getDN(MORef anMORef, Session aSession) throws CSException {
        if (CSFacade.isRefNull(anMORef)) {
            return new MOName("");
        }
        MOidpair idPair = new MOidpair();
        idPair.ref(anMORef);
        BasicConfig.MOInfo moInfo = null;
        try {
            moInfo = config.basic_get_MO_info(idPair, aSession);
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{"aLDN", "aLDN.getType()", "CSFacade", "getDN", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{"aLDN", "aLDN.getType()", "CSFacade", "getDN", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{"aLDN", "aLDN.getType()", "CSFacade", "getDN", new Long(-1L), this.whoCalled(), "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{"aLDN", "aLDN.getType()", "CSFacade", "getDN", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to get the LDN for an MO reference.", e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        if (moExceptionLog.isLoggable(Level.FINE)) {
            moLog.log(Level.FINE, "getDN", new java.lang.Object[]{"aLDN", "aLDN.getType()", "CSFacade", "getDN", new Long(-1L), this.whoCalled()});
        }
        MOName dn = new MOName(moInfo.localDN);
        return dn;
    }

    protected CSFacade() {
    }

    private CSFacade(CORBAManager aCORBAManager) throws RemoteObjectManagerException, LocalObjectManagerException, CSException {
        corbaManager = aCORBAManager;
        CORBAManager.NamingContext root = corbaManager.getRootContext();
        Object cs = root.resolveObject(CS_NAME);
        config = ConfigurationExtendedHelper.narrow(cs);
        this.initMore();
    }

    private CSFacade(NamingContext root) throws RemoteObjectManagerException, LocalObjectManagerException, CSException {
        NameComponent nameComponent = new NameComponent(CS_NAME, "");
        NameComponent[] path = new NameComponent[]{nameComponent};
        Object cs = null;
        try {
            cs = root.resolve(path);
        }
        catch (InvalidName e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (CannotProceed e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NotFound e) {
            throw ExceptionHandler.map(e, "");
        }
        config = ConfigurationExtendedHelper.narrow(cs);
        this.initMore();
    }

    public void initSession() throws CSException {
        try {
            session = config.create_session("EMAS_session", 3600);
            session.restart();
            session.commit();
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (TransactionFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
    }

    private void initMore() throws CSException {
        bulkSize = Integer.getInteger("CSFacade.Bulksize", 100);
        attributesLog.log(Level.INFO, "initMore called");
        this.initSession();
        try {
            mib = config.get_MIBs(session)[0];
            mibInfo = config.get_MIB_info(mib, session);
            MOName nameSeq = new MOName(CSFacade.mibInfo.prefix);
            mibPrefix = nameSeq.getRDNSeq();
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (SecurityViolation e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NotDefined e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (UnsupportedQoS e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        producer = config.get_notification_producer();
        try {
            this.consumer = null;
            this.consumer = new Consumer();
            EmasFramework.connect(this.consumer);
            narrowed_consumer = NotificationConsumerHelper.narrow(EmasFramework.servant_to_reference(this.consumer));
            producer.subscribe(narrowed_consumer, Notfilter, 60, subscriptionId);
            this.notificationQueue.removeAllWork();
            this.createNotificationThreads();
            if (exitNow) {
                exitNow = false;
                this.poller.start();
            }
        }
        catch (Exception e) {
            Log.logError("CSFacade()", e);
        }
    }

    protected Session createSession(String sessionId, int timeout) throws CSException {
        Session newSession = null;
        try {
            newSession = config.create_session(sessionId, timeout);
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        return newSession;
    }

    public synchronized void setnotificationDown(boolean notification_down) {
        this.notificationDown = notification_down;
    }

    public boolean getnotificationDown() {
        return this.notificationDown;
    }

    public static boolean isRefNull(MORef ref) {
        return ref.oid == 0L;
    }

    private void createNotificationThreads() {
        for (int i = 0; i < this.notificationThreads.length; ++i) {
            this.notificationThreads[i] = new NotificationThread(this.notificationQueue);
            this.notificationThreads[i].start();
        }
    }

    private void closeNotificationThreads() {
        for (int i = 0; i < this.notificationThreads.length; ++i) {
            this.notificationQueue.addWork(NO_MORE_WORK);
            this.notificationThreads[i] = null;
        }
    }

    private String whoCalled() {
        Throwable th = new Throwable();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        StringTokenizer st = new StringTokenizer(sw.toString(), "\n");
        boolean found = false;
        String token = null;
        if (st.hasMoreTokens()) {
            token = st.nextToken();
        }
        while (st.hasMoreTokens() && !found) {
            token = st.nextToken();
            if (token.indexOf("se.ericsson.cello.support.proxy") != -1) continue;
            token = token.trim();
            found = true;
        }
        try {
            sw.close();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return token;
    }

    public static void dropAllSubscriptions() {
        subscribers.clear();
        unspecifiedSubscribers.clear();
        overflowSubscribers.clear();
    }

    public boolean tryToReconnect() {
        try {
            producer = config.get_notification_producer();
        }
        catch (Exception exp) {
            boolean clientSecurity = EmasFramework.getSecurityOnClient();
            boolean serverSecurity = EmasFramework.getSecurityOnNode();
            if (clientSecurity != serverSecurity) {
                String msg = null;
                msg = clientSecurity && !serverSecurity ? "The  Element Manager has the security  enabled,  \n while the node has the security disabled.\n This inconsistency is not allowed.  \n The Element Manager will be closed\n Please, restart the Element Manager. " : "The  Element Manager has the security  disabled,  \n while the node has the security enabled.\n This inconsistency is not allowed.  \n The Element Manager will be closed\n Please, restart the Element Manager. ";
                if (!this.securityMessage) {
                    this.securityMessage = true;
                    if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("false")) {
                        JOptionPane.showMessageDialog(null, msg, " Security Error ", 0);
                    }
                    return false;
                }
            }
            Log.logNotify("Trying to reconnect..." + exp.getMessage());
            return false;
        }
        try {
            Thread.sleep(20000L);
            if (exitNow) {
                Log.logNotify("exiting poller thread since exitNow is true");
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            if (producer != null && !producer.get_subscription_status(CSFacade.subscriptionId.value)) {
                try {
                    producer.subscribe(narrowed_consumer, Notfilter, 60, subscriptionId);
                }
                catch (Exception e) {}
            } else {
                this.setnotificationDown(false);
            }
        }
        catch (Exception e) {
            this.setnotificationDown(true);
            return false;
        }
        return true;
    }

    public Hashtable getMosWithAttributes(String aLDN, String moType, String[] attrNames, int scope) throws CSException {
        Log.trace("getMosWithAttributes: moType: " + moType);
        MOName rootName = new MOName(aLDN);
        Hashtable mosTable = new Hashtable();
        try {
            MOidpair moIdPair = rootName.getMOidpair();
            Filter filter = new Filter(moType, "");
            AttrMORefSeqHolder holder = new AttrMORefSeqHolder();
            LinkedList<String> attrsList = new LinkedList<String>();
            String aAttr = null;
            for (int i = 0; i < attrNames.length; ++i) {
                aAttr = attrNames[i];
                if (aAttr == null || aAttr.length() == 0) continue;
                attrsList.add(aAttr);
            }
            String[] attrSeq = attrsList.isEmpty() ? new String[]{} : attrsList.toArray(new String[0]);
            HashMap<Long, String> oidLdnMap = new HashMap<Long, String>();
            MOInfoSeqHolder resultLdn = new MOInfoSeqHolder();
            boolean found = true;
            int iter = config.get_MO_containment(aLDN, scope, filter, null);
            while (found) {
                found = config.next_MO_info(iter, 1000, null, resultLdn);
                for (int i = 0; i < resultLdn.value.length; ++i) {
                    oidLdnMap.put(new Long(resultLdn.value[i].moId), resultLdn.value[i].localDN);
                }
            }
            config.delete_MO_info_iter(iter, null);
            Log.trace("Start calling basic_get_attr_MO_containment...");
            AttrIterRef iter2 = null;
            iter2 = config.basic_get_attr_MO_containment(moIdPair, scope, filter, attrSeq, null);
            Log.trace("Success calling basic_get_attr_MO_containment.");
            String aName = "";
            boolean more = true;
            boolean lastRead = false;
            do {
                more = config.attr_next_MOs(iter2, 1000, holder, null);
                for (int i = 0; i < holder.value.length; ++i) {
                    HashMap<String, java.lang.Object> attributeMap = new HashMap<String, java.lang.Object>();
                    for (int j = 0; j < holder.value[i].nvs.length; ++j) {
                        aName = holder.value[i].nvs[j].name;
                        Any anAny = holder.value[i].nvs[j].value;
                        attributeMap.put(aName, AnyMapping.any2object(anAny));
                    }
                    mosTable.put(oidLdnMap.get(new Long(holder.value[i].oid)), attributeMap);
                }
            } while (more);
            config.attr_delete_Iter(iter2, null);
        }
        catch (NotAccepted e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotAccepted exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "NotAccepted exception"});
            }
            throw ExceptionHandler.map(e, "NotAccepted exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (ProcessingFailure e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            }
            throw ExceptionHandler.map(e, "ProcessingFailure exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (SecurityViolation e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "SecurityViolation exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "SecurityViolation exception"});
            }
            throw ExceptionHandler.map(e, "SecurityViolation exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (NotDefined e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "NotDefined exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "NotDefined exception"});
            }
            throw ExceptionHandler.map(e, "NotDefined exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (NO_PERMISSION e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            }
            throw ExceptionHandler.map(e, AUTH_READ_ERROR);
        }
        catch (COMM_FAILURE e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "CORBA::COMM_FAILURE exception"});
            }
            throw ExceptionHandler.map(e, "org.omg.CORBA.COMM_FAILURE exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (TRANSIENT e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "CORBA::TRANSIENT exception"});
            }
            throw ExceptionHandler.map(e, "org.omg.CORBA.TRANSIENT exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (OBJECT_NOT_EXIST e) {
            if (moExceptionLog.isLoggable(Level.FINE)) {
                moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new java.lang.Object[]{aLDN, "", "CSFacade", "getMosWithAttributes", new Long(-1L), this.whoCalled(), "CORBA::OBJECT_NOT_EXIST exception"});
            }
            throw ExceptionHandler.map(e, "org.omg.CORBA.OBJECT_NOT_EXIST exception while trying to getMosWithAttributes, of the MO type " + moType + ". ");
        }
        catch (SystemException e) {
            Log.logError("CORBA exception when trying to get MOs with attributes below " + aLDN, e);
            throw ExceptionHandler.map(e, OTHER_CORBA_ERROR);
        }
        Log.trace("Returning from getMosWithAttributes: moType: " + moType);
        return mosTable;
    }

    static {
        config = null;
        exitNow = true;
        NO_MORE_WORK = new java.lang.Object();
        narrowed_consumer = null;
        subscriptionId = new IntHolder();
        Notfilter = new NotificationFilter(new String[0], true, true, "", -1);
        moName = null;
        bulkSize = 100;
        overflowSubscribers = new Vector();
        subscribers = new Hashtable();
        unspecifiedSubscribers = new Vector();
        attributesLog = Logger.getLogger("se.ericsson.cello.support.moproxy.attributesLog");
        createDeleteLog = Logger.getLogger("se.ericsson.cello.support.moproxy.createDeleteLog");
        notifyLog = Logger.getLogger("se.ericsson.cello.support.moproxy.notifyLog");
        actionLog = Logger.getLogger("se.ericsson.cello.support.moproxy.actionLog");
        moLog = Logger.getLogger("se.ericsson.cello.support.moproxy.moLog");
        moExceptionLog = Logger.getLogger("se.ericsson.cello.support.moproxy.moExceptionLog");
    }

    private class Poller
    extends Thread {
        public Poller() {
            this.setName("Poller thread");
        }

        public void run() {
            Log.logNotify("                                      start of RUN.... ");
            if (!exitNow) {
                Log.logNotify("                                      start of RUN.... exitNow = false");
            } else {
                Log.logNotify("                                      start of RUN.... exitNow = true");
            }
            this.setPriority(1);
            while (!exitNow) {
                if (producer == null) {
                    Log.logNotify("exiting poller thread since produce in null");
                }
                try {
                    Thread.sleep(20000L);
                    if (exitNow) {
                        Log.logNotify("exiting poller thread since exitNow is true");
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                try {
                    if (producer != null && !producer.get_subscription_status(subscriptionId.value)) {
                        try {
                            producer.subscribe(narrowed_consumer, Notfilter, 60, subscriptionId);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    CSFacade.this.setnotificationDown(false);
                }
                catch (Exception e) {
                    CSFacade.this.setnotificationDown(true);
                    try {
                        producer = config.get_notification_producer();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private class Consumer
    extends NotificationConsumerPOA {
        private Consumer() {
        }

        public void push(ConfigNotification[] notifications) {
            CSFacade.this.notificationQueue.addWork(notifications);
        }

        public void pushNotification(ConfigNotification[] notifications) {
            NotificationKind discr;
            ConfigNotification notification;
            int i;
            for (i = 0; i < notifications.length; ++i) {
                notification = notifications[i];
                discr = notification.discriminator();
                if (discr == NotificationKind.MOCreatedType) {
                    this.notifyMOCreated(unspecifiedSubscribers, notification);
                    continue;
                }
                if (discr == NotificationKind.MODeletedType) {
                    this.notifyMODeleted(unspecifiedSubscribers, notification);
                    continue;
                }
                if (discr != NotificationKind.AVCType) continue;
                this.notifyAVC(unspecifiedSubscribers, notification);
            }
            for (i = 0; i < notifications.length; ++i) {
                Vector v;
                MOName name;
                TopologyNotification top;
                notification = notifications[i];
                discr = notification.discriminator();
                if (discr == NotificationKind.MOCreatedType) {
                    top = notification.createdMO();
                    name = new MOName(top.moInformation.localDN);
                    v = (Vector)subscribers.get(name.getParentName());
                    if (v != null) {
                        this.notifyMOCreated(v, notification);
                    }
                    if (!notifyLog.isLoggable(Level.FINE)) continue;
                    notifyLog.log(Level.FINE, "MOCreated notification", new java.lang.Object[]{name, name.getType(), "CSFacade", "MOCreated notification", new Long(-1L), CSFacade.this.whoCalled()});
                    continue;
                }
                if (discr == NotificationKind.MODeletedType) {
                    top = notification.deletedMO();
                    name = new MOName(top.moInformation.localDN);
                    v = (Vector)subscribers.get(name.getParentName());
                    if (v != null) {
                        this.notifyMODeleted(v, notification);
                    }
                    if (!notifyLog.isLoggable(Level.FINE)) continue;
                    notifyLog.log(Level.FINE, "MODeleted notification", new java.lang.Object[]{name, name.getType(), "CSFacade", "MODeleted notification", new Long(-1L), CSFacade.this.whoCalled()});
                    continue;
                }
                if (discr == NotificationKind.AVCType) {
                    AVCNotification attrs = notification.updatedMO();
                    name = new MOName(attrs.moInformation.localDN);
                    v = (Vector)subscribers.get(name);
                    if (v != null) {
                        this.notifyAVC(v, notification);
                    }
                    if (!notifyLog.isLoggable(Level.FINE)) continue;
                    notifyLog.log(Level.FINE, "AVC notification", new java.lang.Object[]{name, name.getType(), "CSFacade", "AVC notification", new Long(-1L), CSFacade.this.whoCalled()});
                    continue;
                }
                if (discr != NotificationKind.OverflowType) continue;
                this.notifyOverflow(overflowSubscribers, notification);
                if (!notifyLog.isLoggable(Level.FINE)) continue;
                notifyLog.log(Level.FINE, "Overflow notification", new java.lang.Object[]{"", "", "CSFacade", "Overflow notification", new Long(-1L), CSFacade.this.whoCalled()});
            }
        }

        private void notifyMOCreated(Vector v, ConfigNotification notification) {
            TopologyNotification top = notification.createdMO();
            MOName name = new MOName(top.moInformation.localDN);
            Iterator j = ((Vector)v.clone()).iterator();
            while (j.hasNext()) {
                try {
                    Subscriber s = (Subscriber)j.next();
                    s.childCreated(name);
                }
                catch (Exception e) {
                    Log.logError("Error notifying listener of childCreated", e);
                }
            }
        }

        private void notifyMODeleted(Vector v, ConfigNotification notification) {
            TopologyNotification top = notification.deletedMO();
            MOName name = new MOName(top.moInformation.localDN);
            Iterator j = ((Vector)v.clone()).iterator();
            while (j.hasNext()) {
                try {
                    Subscriber s = (Subscriber)j.next();
                    s.childDeleted(name);
                }
                catch (Exception e) {
                    Log.logError("Error notifying listener of childDeleted", e);
                }
            }
        }

        private void notifyAVC(Vector v, ConfigNotification notification) {
            AVCNotification attrs = notification.updatedMO();
            MOName name = new MOName(attrs.moInformation.localDN);
            NameValue[] attributes = new NameValue[attrs.changedAttributes.length];
            try {
                for (int j = 0; j < attributes.length; ++j) {
                    String attribute = attrs.changedAttributes[j].name;
                    java.lang.Object object = AnyMapping.any2object(attrs.changedAttributes[j].newValue);
                    attributes[j] = new NameValue(attrs.changedAttributes[j].name, object);
                }
                Iterator j = ((Vector)v.clone()).iterator();
                while (j.hasNext()) {
                    try {
                        Subscriber s = (Subscriber)j.next();
                        s.attributesChanged(name, attributes);
                    }
                    catch (Exception e) {
                        Log.logError("Error notifying listener of attributesChanged", e);
                    }
                }
            }
            catch (Exception e) {
                Log.logError("Error notifying listener of attributesChanged", e);
            }
        }

        private void notifyOverflow(Vector v, ConfigNotification notification) {
            Iterator j = ((Vector)v.clone()).iterator();
            while (j.hasNext()) {
                try {
                    OverflowSubscriber s = (OverflowSubscriber)j.next();
                    s.overflow();
                }
                catch (Exception e) {
                    Log.logError("Error notifying listener of overflow", e);
                }
            }
        }
    }

    private class NotificationThread
    extends Thread {
        private ThreadQueue notifQueue;

        NotificationThread(ThreadQueue q) {
            this.notifQueue = q;
        }

        public void run() {
            try {
                java.lang.Object notif;
                while ((notif = this.notifQueue.getWork()) != NO_MORE_WORK) {
                    ConfigNotification[] myNotifics = (ConfigNotification[])notif;
                    CSFacade.this.consumer.pushNotification(myNotifics);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface Subscriber {
        public void childCreated(MOName var1);

        public void childDeleted(MOName var1);

        public void attributesChanged(MOName var1, NameValue[] var2);
    }

    public static interface OverflowSubscriber {
        public void overflow();
    }
}

