/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.MOidpair;
import CosNaming.NameComponent;
import java.util.StringTokenizer;
import se.ericsson.cello.support.proxy.Trace;

public class MOName {
    public static final String RDN_DELIMITER = ",";
    public static final String TYPE_DELIMITER = "=";
    public static final MOName NULL_NAME = new MOName();
    public static final MOidpair NULL_ID = NULL_NAME.getMOidpair();
    private String rdnSeq;

    public MOName() {
        Trace.enter(MOName.class, "MOName()");
    }

    public MOName(String anRDNSeq) {
        Trace.enter(MOName.class, "MOName(String)", anRDNSeq);
        this.rdnSeq = anRDNSeq;
    }

    public MOName(NameComponent[] anRDNSeq) {
        Trace.enter(MOName.class, "MOName(NameComponent[])", anRDNSeq);
        if (anRDNSeq == null || anRDNSeq.length == 0) {
            this.rdnSeq = null;
            return;
        }
        StringBuffer seq = new StringBuffer(anRDNSeq[0].id);
        for (int i = 1; i < anRDNSeq.length; ++i) {
            seq.append(RDN_DELIMITER);
            seq.append(anRDNSeq[i].id);
        }
        this.rdnSeq = seq.toString();
    }

    public MOidpair getMOidpair() {
        Trace.enter(MOName.class, "getMOidpair()");
        NameComponent[] nameSequence = this.rdnSeq == null ? new NameComponent[]{} : this.getNameComponentSeq();
        MOidpair idPair = new MOidpair();
        idPair.name(nameSequence);
        Trace.exit(MOName.class, "getMOidpair()", idPair);
        return idPair;
    }

    public NameComponent[] getNameComponentSeq() {
        Trace.enter(MOName.class, "getNameComponentSeq()");
        if (this.rdnSeq == null) {
            return new NameComponent[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(this.rdnSeq, RDN_DELIMITER);
        int nTokens = tokenizer.countTokens();
        if (nTokens == 0) {
            throw new IllegalArgumentException("rdnSeq is null or empty");
        }
        NameComponent[] seq = new NameComponent[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            NameComponent nameComponent;
            String rdn = tokenizer.nextToken();
            seq[i] = nameComponent = new NameComponent(rdn, "");
        }
        Trace.exit(MOName.class, "getNameComponentSeq()", seq);
        return seq;
    }

    public String getRDNSeq() {
        Trace.enter(MOName.class, "getRDNSeq()");
        Trace.exit(MOName.class, "getRDNSeq()", this.rdnSeq);
        return this.rdnSeq;
    }

    public MOName getParentName() {
        Trace.enter(MOName.class, "getParentName()");
        if (this.rdnSeq == null) {
            return NULL_NAME;
        }
        int rdnIdx = this.rdnSeq.lastIndexOf(RDN_DELIMITER);
        if (rdnIdx == -1) {
            return NULL_NAME;
        }
        String parentRDNSeq = this.rdnSeq.substring(0, rdnIdx);
        MOName parentName = new MOName(parentRDNSeq);
        Trace.exit(MOName.class, "getParentName()", parentName);
        return parentName;
    }

    public int getNoOfRDNs() {
        Trace.enter(MOName.class, "getNoOfRDNs()");
        Trace.msg(MOName.class, "getNoOfRDNs()", "this.rdnSeq = " + this.rdnSeq);
        int no = 0;
        if (this.rdnSeq != null) {
            no = 1;
            int i = this.rdnSeq.indexOf(RDN_DELIMITER) + 1;
            int j = this.rdnSeq.length();
            while (i != 0 && i < j) {
                ++no;
                i = this.rdnSeq.indexOf(RDN_DELIMITER, i) + 1;
            }
        }
        Trace.exit(MOName.class, "getNoOfRDNs()", new Integer(no));
        return no;
    }

    public String getFirstRDN() {
        Trace.enter(MOName.class, "getFirstRDN()");
        if (this.rdnSeq == null) {
            return null;
        }
        int rdnIdx = this.rdnSeq.indexOf(RDN_DELIMITER);
        if (rdnIdx == -1) {
            return this.rdnSeq;
        }
        String rdn = this.rdnSeq.substring(0, rdnIdx);
        Trace.exit(MOName.class, "getFirstRDN()", rdn);
        return rdn;
    }

    public String getLastRDN() {
        Trace.enter(MOName.class, "getLastRDN()");
        if (this.rdnSeq == null) {
            return null;
        }
        int rdnIdx = this.rdnSeq.lastIndexOf(RDN_DELIMITER) + 1;
        String rdn = this.rdnSeq.substring(rdnIdx);
        Trace.exit(MOName.class, "getLastRDN()", rdn);
        return rdn;
    }

    public MOName getSubName(int aFromRDNIndex, int aToRDNIndex) {
        int from = 0;
        while (aFromRDNIndex-- > 0) {
            from = this.rdnSeq.indexOf(RDN_DELIMITER, from) + 1;
        }
        int to = 0;
        while (aToRDNIndex-- > 0) {
            to = this.rdnSeq.indexOf(RDN_DELIMITER, to) + 1;
        }
        if (to > 0) {
            --to;
        }
        String subSeq = this.rdnSeq.substring(from, to);
        MOName subName = new MOName(subSeq);
        return subName;
    }

    public String getType() {
        Trace.enter(MOName.class, "getType()");
        if (this.rdnSeq == null) {
            return null;
        }
        String rdn = this.getLastRDN();
        String type = rdn.substring(0, rdn.indexOf(TYPE_DELIMITER));
        Trace.exit(MOName.class, "getType()", type);
        return type;
    }

    public String getId() {
        Trace.enter(MOName.class, "getId()");
        if (this.rdnSeq == null) {
            return null;
        }
        int idIdx = this.rdnSeq.lastIndexOf(TYPE_DELIMITER) + 1;
        String id = this.rdnSeq.substring(idIdx);
        Trace.exit(MOName.class, "getId()", id);
        return id;
    }

    public boolean isParentOf(MOName anRDNSeq) {
        Trace.enter(MOName.class, "isParentOf(MOName)", anRDNSeq);
        boolean isTrue = false;
        if (this.isIndirectParentOf(anRDNSeq)) {
            int anNoOfRDNs = anRDNSeq.getNoOfRDNs();
            int noOfRDNs = this.getNoOfRDNs();
            isTrue = noOfRDNs + 1 == anNoOfRDNs;
        }
        Trace.exit(MOName.class, "isParentOf(MOName)", Boolean.valueOf(String.valueOf(isTrue)));
        return isTrue;
    }

    public boolean isChildOf(MOName anRDNSeq) {
        Trace.enter(MOName.class, "isChildOf(MOName)", anRDNSeq);
        Trace.msg(MOName.class, "isChildOf(MOName)", "this.rdnSeq = " + this.rdnSeq);
        boolean isTrue = false;
        if (this.isIndirectChildOf(anRDNSeq)) {
            int anNoOfRDNs = anRDNSeq.getNoOfRDNs();
            int noOfRDNs = this.getNoOfRDNs();
            isTrue = noOfRDNs == anNoOfRDNs + 1;
        }
        Trace.exit(MOName.class, "isChildOf(MOName)", Boolean.valueOf(String.valueOf(isTrue)));
        return isTrue;
    }

    public boolean isIndirectParentOf(MOName anRDNSeq) {
        Trace.enter(MOName.class, "isIndirectParentOf(MOName)", anRDNSeq);
        boolean isTrue = this.rdnSeq == null || anRDNSeq.rdnSeq == null ? false : anRDNSeq.rdnSeq.startsWith(this.rdnSeq + RDN_DELIMITER);
        Trace.exit(MOName.class, "isIndirectParentOf(MOName)", Boolean.valueOf(String.valueOf(isTrue)));
        return isTrue;
    }

    public boolean isIndirectChildOf(MOName anRDNSeq) {
        Trace.enter(MOName.class, "isIndirectChildOf(MOName)", anRDNSeq);
        boolean isTrue = this.rdnSeq == null || anRDNSeq.rdnSeq == null ? false : this.rdnSeq.startsWith(anRDNSeq.rdnSeq + RDN_DELIMITER);
        Trace.exit(MOName.class, "isIndirectChildOf(MOName)", Boolean.valueOf(String.valueOf(isTrue)));
        return isTrue;
    }

    public String toString() {
        return this.rdnSeq;
    }

    public int hashCode() {
        return this.rdnSeq.hashCode();
    }

    public boolean equals(Object anObject) {
        boolean equality = false;
        if (this == anObject) {
            equality = true;
        } else if (anObject instanceof MOName) {
            MOName moName = (MOName)anObject;
            equality = this.rdnSeq == null && moName.rdnSeq == null || this.rdnSeq != null && this.rdnSeq.equals(moName.rdnSeq);
        } else {
            equality = this.rdnSeq != null && this.rdnSeq.equals(anObject);
        }
        return equality;
    }
}

