/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.StringTokenizer;
import se.ericsson.cello.managedelement.HealthCheckResult;
import se.ericsson.cello.managedelement.HealthCheckResultCode;
import se.ericsson.cello.managedelement.HealthCheckResultObserver;
import se.ericsson.cello.managedelement.StartTime;
import se.ericsson.cello.managedelement.fropxy.FroHealthCheckResultObserver;
import se.ericsson.cello.managedelement.fropxy.FroHealthCheckResultProvider;
import se.ericsson.cello.managedelement.meaccess.UpgradePackageChecksumVerifier;
import se.ericsson.cello.support.debug.MessageLog;

public class HealthCheckCoordinator
implements Runnable,
FroHealthCheckResultObserver {
    private HealthCheckResult froResult = null;
    private HealthCheckResult upResult = null;
    private StartTime startTime;
    private FroHealthCheckResultProvider provider;
    private UpgradePackageChecksumVerifier verifier;
    private HealthCheckResultObserver observer;
    private long requestId;
    private String finalString = "";

    public HealthCheckCoordinator(StartTime startTime, FroHealthCheckResultProvider froHealthCheckResultProvider, UpgradePackageChecksumVerifier upgradePackageChecksumVerifier, HealthCheckResultObserver healthCheckResultObserver) {
        this.startTime = startTime;
        this.provider = froHealthCheckResultProvider;
        this.verifier = upgradePackageChecksumVerifier;
        this.observer = healthCheckResultObserver;
        this.requestId = startTime.toLong() & 0xFFFFFFFFL;
        froHealthCheckResultProvider.addFroHealthCheckResultObserver(this);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public Runnable getRunnable() {
        return this;
    }

    public void run() {
        MessageLog.info(this.getClass(), (String)"Starting UP health check.");
        this.performUPHealthCheck();
        MessageLog.info(this.getClass(), (String)"Completed UP health check.");
        this.compareResults();
    }

    public void cancel() {
        this.provider.removeFroHealthCheckResultObserver(this);
    }

    private void performUPHealthCheck() {
        boolean bl = true;
        this.verifier.setHealthCheckStatus(true);
        this.upResult = new HealthCheckResult();
        this.upResult.setResultCode(4);
        try {
            bl = this.verifier.verifyAllLoadModuleChecksums("HealthCheck");
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Unable to verify load module checksums", (Throwable)exception);
            bl = false;
        }
        int n = bl ? 0 : 1;
        this.upResult.setResultCode(n);
        this.compareResults();
        this.verifier.setHealthCheckStatus(false);
    }

    public void froHealthCheckResultUpdated(long l, int n, String string) {
        this.provider.removeFroHealthCheckResultObserver(this);
        if (l == this.getRequestId()) {
            MessageLog.info(this.getClass(), (String)"Received health check result from FRO");
            HealthCheckResult healthCheckResult = new HealthCheckResult();
            healthCheckResult.setResultCode(n);
            healthCheckResult.setMessage(string);
            this.froResult = healthCheckResult;
            StringTokenizer stringTokenizer = new StringTokenizer(this.froResult.getMessage(), ";");
            while (stringTokenizer.hasMoreTokens()) {
                this.finalString = this.finalString + stringTokenizer.nextToken() + '\n';
            }
            this.compareResults();
        } else {
            MessageLog.info(this.getClass(), (String)("Received a FRO health check result for a different request (expected id " + this.getRequestId() + ", was " + l + ")"));
        }
    }

    private synchronized void compareResults() {
        if (this.froResult != null && this.upResult != null) {
            HealthCheckResult healthCheckResult = new HealthCheckResult();
            healthCheckResult.setStartTime(this.startTime);
            healthCheckResult.setResultCode(HealthCheckResultCode.merge(this.froResult.getResultCode(), this.upResult.getResultCode()));
            healthCheckResult.setMessage(this.finalString);
            MessageLog.info(this.getClass(), (String)"Compiled final health check results. Notifying observers.");
            this.observer.healthCheckResultUpdated(healthCheckResult);
        }
    }
}

