/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import se.ericsson.cello.managedelement.InvalidTimeFormatException;
import se.ericsson.cello.managedelement.ScheduleEntry;
import se.ericsson.cello.managedelement.WeekdayOutOfRangeException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.support.scheduler.ScheduleTime;

public class HealthCheckSchedule {
    private Attribute[] attrs;
    private Struct[] structs;
    private ScheduleTime[] times;
    public static final HealthCheckSchedule EMPTY_SCHEDULE = new HealthCheckSchedule();

    private HealthCheckSchedule() {
        this.attrs = new Attribute[0];
        this.structs = new Struct[0];
        this.times = new ScheduleTime[0];
    }

    public HealthCheckSchedule(Struct[] structArray) throws MoAccessException, InvalidTimeFormatException, WeekdayOutOfRangeException {
        this.structs = structArray;
        this.attrs = new Attribute[structArray.length];
        this.times = new ScheduleTime[structArray.length];
        ScheduleEntry scheduleEntry = null;
        for (int i = 0; i < structArray.length; ++i) {
            scheduleEntry = new ScheduleEntry(structArray[i]);
            this.times[i] = scheduleEntry.toScheduleTime();
            this.attrs[i] = scheduleEntry.toAttribute();
        }
    }

    public HealthCheckSchedule(SequenceAttribute sequenceAttribute) throws InvalidTimeFormatException, WeekdayOutOfRangeException {
        this.attrs = sequenceAttribute.getValue(null);
        this.structs = new Struct[this.attrs.length];
        this.times = new ScheduleTime[this.attrs.length];
        StructAttribute structAttribute = null;
        ScheduleEntry scheduleEntry = null;
        for (int i = 0; i < this.structs.length; ++i) {
            structAttribute = (StructAttribute)this.attrs[i];
            scheduleEntry = new ScheduleEntry(structAttribute);
            this.times[i] = scheduleEntry.toScheduleTime();
            this.structs[i] = scheduleEntry.toStruct();
        }
    }

    public Struct[] toStructs() {
        return this.structs;
    }

    public Attribute[] toAttributes() {
        return this.attrs;
    }

    public ScheduleTime[] toScheduleTimes() {
        return this.times;
    }
}

