/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.scheduler.ScheduledTask;

public class ScheduledHealthCheck
implements ScheduledTask {
    private ManagedElementMo me;

    public ScheduledHealthCheck(ManagedElementMo managedElementMo) {
        this.me = managedElementMo;
    }

    public boolean runScheduledTask(String string) {
        try {
            this.waitForConfigService();
            int n = this.me.actionStartHealthCheck(null);
            if (n == 0) {
                MessageLog.info(this.getClass(), (String)"Scheduled health check was started successfully");
            } else {
                MessageLog.info(this.getClass(), (String)("Scheduled health check was not started. Result code is " + n));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)("Exception occurred trying to start scheduled health check: " + (Object)((Object)moAccessException)));
        }
        catch (Throwable throwable) {
            MessageLog.traceError(this.getClass(), (String)"Unexpected error trying to start scheduled health check", (Throwable)throwable);
        }
        return true;
    }

    protected void waitForConfigService() throws MoAccessException {
        block4: while (true) {
            try {
                while (true) {
                    NamingContext namingContext;
                    if ((namingContext = CelloOrb.instance().getRootNamingContext()) != null) {
                        NameComponent nameComponent = new NameComponent("CelloConfigurationService", "");
                        NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
                        namingContext.resolve(nameComponentArray);
                        break block4;
                    }
                    MessageLog.info(this.getClass(), (String)"Configuration Service not ready, trying again after 7 seconds.");
                    this.sleep(7000L);
                }
            }
            catch (UserException userException) {
                MessageLog.info(this.getClass(), (String)"Configuration Service not ready (org.omg.CORBA.UserException caught), trying again after 7 seconds.");
                this.sleep(7000L);
                continue;
            }
            catch (SystemException systemException) {
                MessageLog.info(this.getClass(), (String)"Configuration Service not ready (org.omg.CORBA.SystemException caught), trying again after 7 seconds.");
                this.sleep(7000L);
                continue;
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)"Throwable caught when trying to look up the Configuration Service from the Corba name server.", (Throwable)throwable);
                throw new SoftwareErrorException();
            }
            break;
        }
    }

    protected void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Exception caught when trying to sleep for " + l), (Throwable)exception);
        }
    }
}

