/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import se.ericsson.cello.emas.sm.elements.ConfigurationVersionElement;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class ConfigurationVersionAddToListAction
extends AbstractAction {
    private static final long serialVersionUID = 2668362590304499405L;
    private ConfigurationVersionElement element;
    private MainWindowController mainWindow = EmasGuilibMediator.getReference().getMainWindowReference();

    public ConfigurationVersionAddToListAction(String action, EmasViewElementInterface element) {
        this.element = (ConfigurationVersionElement)element;
        this.putValue("Name", element.getProperty(action + ".tag"));
    }

    public boolean isEnabled() {
        return this.element.getRollbackListPos() == null;
    }

    public void actionPerformed(ActionEvent event) {
        Transaction tid = null;
        try {
            tid = new Transaction();
            MOProxy cvMO = new MOProxy(this.element.getDN());
            NameValue[] startArgs = new NameValue[]{new NameValue("param", (Object)this.element.getName())};
            cvMO.action("setFirstRollbackList", startArgs, tid.session);
            tid.commit();
            tid.end();
        }
        catch (CSException e) {
            try {
                tid.rollback();
                tid.end();
            }
            catch (CSException be) {
                Log.logError((String)"Unable to rollback transaction", (Throwable)be);
            }
            this.mainWindow.reportException((Exception)((Object)e), "ERROR_ADD_TO_ROLLBACKLIST", null);
        }
    }
}

