/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JList;
import se.ericsson.cello.emas.sm.applications.EmasDialogController;
import se.ericsson.cello.emas.sm.applications.FanSelectView;
import se.ericsson.cello.emas.sm.services.FanNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Transaction;

public class FanSelectController
extends EmasDialogController
implements ActionListener {
    private FanSelectView view;
    private TreeMap availableFansTable = null;
    private TreeMap selectedFansTable = new TreeMap();
    private int selectionMode = 2;
    private boolean selectionMandatory = false;
    private static final int AVAILABLE_FANS = 0;
    private static final int SELECTED_FANS = 1;
    private static final int NO_SELECTION = 2;
    private static final int TIME_OUT_PERIOD = 600;
    private CSException error;

    protected void init() {
        this.view = (FanSelectView)this.getView();
        this.view.setActionListener(this);
        this.getFansFromServer();
        this.updateTables();
        this.setSelections(2);
        this.setDialogTitle("FAN_SELECT_TITLE", null);
    }

    protected void afterVisible() {
        if (this.error != null) {
            this.reportException((Exception)((Object)this.error), "ERROR_EDIT_FANS", null);
            this.notifyAll(new ActionEvent(this, 0, "ERROR"));
        } else {
            ((JList)this.view.availableFans.getFieldComponent()).setSelectionMode(this.selectionMode);
            ((JList)this.view.selectedFans.getFieldComponent()).setSelectionMode(this.selectionMode);
        }
    }

    private void getFansFromServer() {
        String fanName = null;
        String key = null;
        Transaction transaction = null;
        this.availableFansTable = new TreeMap();
        try {
            transaction = new Transaction(600);
            Hashtable fans = FanNameFactory.getAllFans(transaction);
            Enumeration keys = fans.keys();
            while (keys.hasMoreElements()) {
                fanName = (String)keys.nextElement();
                this.availableFansTable.put(fanName, fans.get(fanName));
            }
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            this.error = e;
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException e1) {
                Log.logError((String)"Error rolling back transaction");
            }
            return;
        }
        TreeMap selectedFans = (TreeMap)((TreeMap)this.getParameter("FAN_LIST")).clone();
        for (Map.Entry elem : selectedFans.entrySet()) {
            key = (String)elem.getKey();
            this.availableFansTable.remove(key);
            this.selectedFansTable.put(key, elem.getValue());
        }
    }

    public void actionPerformed(ActionEvent event) {
        JList availableFansList = (JList)this.view.availableFans.getFieldComponent();
        JList selectedFansList = (JList)this.view.selectedFans.getFieldComponent();
        if (event.getActionCommand().equals("ENTRYFIELD_FILLEDIN")) {
            if (availableFansList.hasFocus()) {
                selectedFansList.clearSelection();
                this.view.shiftRightButton.setEnabled(true);
                this.view.shiftLeftButton.setEnabled(false);
            } else if (selectedFansList.hasFocus()) {
                availableFansList.clearSelection();
                this.view.shiftRightButton.setEnabled(false);
                this.view.shiftLeftButton.setEnabled(true);
            }
        } else if (event.getActionCommand().equals("SHIFT_RIGHT")) {
            Object[] selectedItems = availableFansList.getSelectedValues();
            if (this.selectionMode == 0) {
                Object[] selectedFans = new Object[this.selectedFansTable.size()];
                this.removeFromSelectedItems(this.selectedFansTable.keySet().toArray());
            }
            this.addToSelectedItems(selectedItems);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.okButton.setEnabled(this.canDismiss());
        } else if (event.getActionCommand().equals("SHIFT_LEFT")) {
            Object[] selectedItems = selectedFansList.getSelectedValues();
            this.removeFromSelectedItems(selectedItems);
            this.view.applyButton.setEnabled(this.canDismiss());
            this.view.okButton.setEnabled(this.canDismiss());
        } else if (event.getActionCommand().equals("APPLY")) {
            if (this.askTheUserToConfirm() == 0) {
                this.updateTables();
                this.view.applyButton.setEnabled(false);
                this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
            }
        } else if (event.getActionCommand().equals("OK")) {
            if (this.view.applyButton.isEnabled()) {
                if (this.askTheUserToConfirm() == 0) {
                    this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
                }
            } else {
                this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
            }
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
        }
    }

    public void enableApplyButton(boolean flag) {
        this.view.applyButton.setEnabled(flag);
    }

    private void updateTables() {
        String[] items = this.availableFansTable.keySet().toArray(new String[0]);
        this.view.availableFans.removeAllItems();
        this.view.availableFans.addItems(items);
        items = this.selectedFansTable.keySet().toArray(new String[0]);
        this.view.selectedFans.removeAllItems();
        this.view.selectedFans.addItems(items);
        ((JList)this.view.availableFans.getFieldComponent()).setSelectionMode(this.selectionMode);
        ((JList)this.view.selectedFans.getFieldComponent()).setSelectionMode(this.selectionMode);
    }

    private void setSelections(int type) {
        JList availableFansList = (JList)this.view.availableFans.getFieldComponent();
        JList selectedFansList = (JList)this.view.selectedFans.getFieldComponent();
        if (type == 2) {
            availableFansList.clearSelection();
            selectedFansList.clearSelection();
            this.view.shiftLeftButton.setEnabled(false);
            this.view.shiftRightButton.setEnabled(false);
        } else if (type == 0) {
            if (this.availableFansTable.size() > 0) {
                availableFansList.setSelectedIndex(1);
                selectedFansList.clearSelection();
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(true);
            } else {
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(false);
            }
        } else if (type == 1) {
            if (this.selectedFansTable.size() > 0) {
                selectedFansList.setSelectedIndex(1);
                availableFansList.clearSelection();
                this.view.shiftLeftButton.setEnabled(true);
                this.view.shiftRightButton.setEnabled(false);
            } else {
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(false);
            }
        }
    }

    public void setSelectionMode(int selectionMode, boolean mandatory) {
        this.selectionMode = selectionMode;
        this.selectionMandatory = mandatory;
        ((JList)this.view.availableFans.getFieldComponent()).setSelectionMode(selectionMode);
        ((JList)this.view.selectedFans.getFieldComponent()).setSelectionMode(selectionMode);
    }

    public boolean canDismiss() {
        boolean retVal = true;
        if (this.selectionMandatory && this.selectedFansTable.isEmpty()) {
            retVal = false;
        } else if (this.selectionMode == 0 && this.selectedFansTable.size() > 1) {
            retVal = false;
        }
        return retVal;
    }

    public TreeMap getSelectedFans() {
        return (TreeMap)this.selectedFansTable.clone();
    }

    private void addToSelectedItems(Object[] selection) {
        int numberOfItems = selection.length;
        MOProxy fan = null;
        String fanName = null;
        for (int i = 0; i < numberOfItems; ++i) {
            fanName = (String)selection[i];
            fan = (MOProxy)this.availableFansTable.get(fanName);
            this.selectedFansTable.put(fanName, fan);
            this.availableFansTable.remove(fanName);
        }
        this.updateTables();
    }

    private void removeFromSelectedItems(Object[] selection) {
        int numberOfItems = selection.length;
        MOProxy fan = null;
        String fanName = null;
        for (int i = 0; i < numberOfItems; ++i) {
            fanName = (String)selection[i];
            fan = (MOProxy)this.selectedFansTable.get(fanName);
            this.availableFansTable.put(fanName, fan);
            this.selectedFansTable.remove(fanName);
        }
        this.updateTables();
    }

    private int askTheUserToConfirm() {
        return this.showConfirmDialog("CONFIRM_EDIT_FANS_SOFTWARE_ALLOCATION", null, "SOFTWARE_ALLOCATIONS", null, 0, 3, null);
    }
}

