/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JTextField;
import se.ericsson.cello.emas.sm.applications.ReliableProgramPropertiesView;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.gengui.InputVerifier;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.cellomom.RPUNormalisationMode;
import se.ericsson.cello.support.mgr.cellomom.RPUOperationalMode;
import se.ericsson.cello.support.mgr.cellomom.RPUReplicationMode;
import se.ericsson.cello.support.mgr.cellomom.RPUSwitchOverMode;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class ReliableProgramPropertiesController
extends AbstractApplicationController
implements ActionListener {
    private Exception error = null;
    private ReliableProgramPropertiesView view;
    private MOProxy rpu = null;
    private AttributeBuffer changedValues = new AttributeBuffer();
    private Hashtable slots = new Hashtable();
    private String activeSlotName;
    private String passiveSlotName;
    private String myLDN = null;
    private MOProxy myActiveSlotMO = null;
    private static Object NULL_WORKAROUND = "AttributeBuffer cannot take NULL";
    protected static final String NO_SLOTS = "No slot is available";
    private static final int PROGRAM_SEARCH_DEPTH = 8;
    private static final int LM_SEARCH_DEPTH = 2;
    private static final int TIME_OUT_PERIOD = 600;
    private boolean somethingChanged = false;
    private Hashtable loadModules = new Hashtable();

    protected void init() {
        String title;
        this.view = (ReliableProgramPropertiesView)this.getView();
        this.myLDN = (String)this.getParameter("LDNLIST");
        if (this.myLDN != null) {
            title = "RPPROGRAM_APPLICATION_TITLE";
        } else {
            title = "ADD_RELIABLEPROGRAMUNITER_TITLE";
            this.view.switchButton.setEnabled(false);
        }
        this.getApplication().setTitle(title, null);
        try {
            String[] normalisationStates = this.normalisationValues();
            this.view.normalisationCombobox.removeAllItems();
            this.view.normalisationCombobox.addItems(normalisationStates);
            this.view.normalisationCombobox.setValue(RPUNormalisationMode.AUTOMATIC.toString());
            String[] replicationStates = this.replicationValues();
            this.view.replicationCombobox.removeAllItems();
            this.view.replicationCombobox.addItems(replicationStates);
            this.view.replicationCombobox.setValue(RPUReplicationMode.APPL_CONTROLLED.toString());
            String[] switchOverstates = this.switchOverValues();
            this.view.switchoverCombobox.removeAllItems();
            this.view.switchoverCombobox.addItems(switchOverstates);
            this.view.switchoverCombobox.setValue(RPUSwitchOverMode.AT_PIU_FAULT.toString());
            this.view.passiveSlot.setVisible(false);
            this.setButtonListeners();
            this.setActionListeners();
            MOProxy[] modules = MOProxy.getRoot().getChildren(2, "LoadModule", "");
            ArrayList<String> tmpList = new ArrayList<String>();
            for (int count = 0; count < modules.length; ++count) {
                String tmpString = (String)modules[count].getAttribute("reliableProgramLabel");
                if (tmpString.equals("")) continue;
                tmpList.add(tmpString);
                this.loadModules.put(tmpString, modules[count]);
            }
            String[] labels = new String[]{};
            labels = tmpList.toArray(labels);
            this.view.rpuLabel.removeAllItems();
            this.view.rpuLabel.addItems(labels);
            this.getRPUData();
            if (this.getParameter("LDNLIST") != null) {
                this.view.applyButton.setEnabled(false);
                this.view.okButton.setEnabled(true);
            } else {
                this.view.reliableProgramLabelId.setInputVerifier(new InputVerifier(){

                    public boolean verify(JComponent input) {
                        String text = ((JTextField)((ReliableProgramPropertiesController)ReliableProgramPropertiesController.this).view.reliableProgramLabelId.getFieldComponent()).getText();
                        if (text.lastIndexOf(" ") > -1) {
                            return false;
                        }
                        return text.lastIndexOf("=") <= -1;
                    }
                });
                this.view.applyButton.setEnabled(this.view.canDismiss());
                this.view.okButton.setEnabled(this.view.canDismiss());
            }
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void beforeVisible() {
        this.view.setToolTipsOnLabels();
    }

    protected void afterVisible() {
        if (this.error != null) {
            this.reportException(this.error, "ERROR_GET", null);
            this.getApplication().stopApplication();
        }
    }

    private void getRPUData() {
        block9: {
            if (this.myLDN != null) {
                this.view.rpuLabel.setEditable(false);
                this.view.replicationCombobox.setEditable(false);
                JTextField idText = (JTextField)this.view.reliableProgramLabelId.getFieldComponent();
                idText.setBorder(null);
                idText.setOpaque(false);
                idText.setEditable(false);
                this.view.ldn.setValue(this.myLDN);
                this.view.ldn.setVisible(true);
                this.view.applyButton.setVisible(true);
                this.view.switchButton.setVisible(true);
                String[] rpuAttributes = new String[]{"operationalMode", "normalisation", "replication", "switchOver", "userLabel", "reliableProgramLabel", "admActiveSlot", "admPassiveSlot", "ReliableProgramUniterId"};
                try {
                    MOProxy passiveSlot;
                    MOProxy activeSlot;
                    this.rpu = new MOProxy(this.myLDN);
                    Object[] rpuValues = this.rpu.getAttributes(rpuAttributes);
                    AttributeBuffer values = new AttributeBuffer(rpuAttributes, rpuValues);
                    String name = (String)values.getAttribute("userLabel");
                    this.view.nameField.setValue(name);
                    String rplabel = (String)values.getAttribute("reliableProgramLabel");
                    this.view.rpuLabel.setValue(rplabel);
                    this.view.reliableProgramLabelId.setVisible(true);
                    this.view.reliableProgramLabelId.setValue((String)values.getAttribute("ReliableProgramUniterId"));
                    this.getSlotsFromServer();
                    this.myActiveSlotMO = activeSlot = (MOProxy)values.getAttribute("admActiveSlot");
                    if (activeSlot != null && activeSlot.getDN() != null) {
                        this.activeSlotName = SlotNameFactory.getSlotName(activeSlot);
                        this.view.activeSlot.setValue(this.activeSlotName);
                    }
                    if ((passiveSlot = (MOProxy)values.getAttribute("admPassiveSlot")) != null && passiveSlot != NULL_WORKAROUND && passiveSlot.getDN() != null) {
                        this.passiveSlotName = SlotNameFactory.getSlotName(passiveSlot);
                        this.view.passiveSlot.setVisible(true);
                        this.view.enablePassiveSlot.setValue(Boolean.valueOf("true"));
                        this.view.passiveSlot.setValue(this.passiveSlotName);
                    } else {
                        this.view.passiveSlot.setVisible(false);
                        this.view.enablePassiveSlot.setValue(Boolean.valueOf("false"));
                    }
                    Integer operational = (Integer)values.getAttribute("operationalMode");
                    this.view.operationalState.setValue(RPUOperationalMode.get((Object)operational).toString());
                    Integer replication = (Integer)values.getAttribute("replication");
                    this.view.replicationCombobox.setValue(RPUReplicationMode.get((Object)replication).toString());
                    Integer switchover = (Integer)values.getAttribute("switchOver");
                    this.view.switchoverCombobox.setValue(RPUSwitchOverMode.get((Object)switchover).toString());
                    Integer normalisation = (Integer)values.getAttribute("normalisation");
                    this.view.normalisationCombobox.setValue(RPUNormalisationMode.get((Object)normalisation).toString());
                    if (this.view.passiveSlot.getValue() != null && this.view.enablePassiveSlot.getValue().equals(Boolean.valueOf("true"))) {
                        this.view.switchButton.setEnabled(true);
                        break block9;
                    }
                    this.view.switchButton.setEnabled(false);
                }
                catch (CSException e) {
                    this.reportException((Exception)((Object)e), "ERROR_GET", null);
                }
                catch (SyntaxException se) {
                    Log.logError((String)"Initialisation of comboxes failed", (Throwable)se);
                }
            } else {
                this.getSlotsFromServer();
            }
        }
    }

    private void setButtonListeners() {
        this.view.okButton.setActionListener((ActionListener)this, "OK");
        this.view.applyButton.setActionListener((ActionListener)this, "APPLY");
        this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL");
    }

    private void setActionListeners() {
        this.view.activeSlot.setActionListener((ActionListener)this, "SELECT1");
        this.view.passiveSlot.setActionListener((ActionListener)this, "SELECT2");
        this.view.enablePassiveSlot.setActionListener((ActionListener)this, "PASSIVE_SLOT_AVAILABLE");
        this.view.switchButton.setActionListener((ActionListener)this, "SWITCH");
        this.view.switchoverCombobox.setActionListener((ActionListener)this, "SWITCHOVER_CHANGED");
        this.view.nameField.setActionListener((ActionListener)this, "USERLABEL_CHANGED");
        this.view.normalisationCombobox.setActionListener((ActionListener)this, "NORMALISATION_CHANGED");
        this.view.rpuLabel.setActionListener((ActionListener)this, "RPULABEL");
        this.view.reliableProgramLabelId.setActionListener((ActionListener)this, "RPUID");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand.equals("OK")) {
            if (this.updateRPUData()) {
                this.getApplication().stopApplication();
            }
        } else if (actionCommand.equals("APPLY")) {
            if (this.updateRPUData()) {
                this.view.applyButton.setEnabled(false);
                this.view.enableRPULabel(false);
                this.view.enableReplicationMode(false);
                this.getRPUData();
                this.somethingChanged = false;
            }
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.getApplication().stopApplication();
        } else if (actionCommand.equals("SELECT1")) {
            this.somethingChanged = true;
            MOProxy activeSlot = null;
            activeSlot = (MOProxy)this.slots.get(this.view.activeSlot.getValue());
            this.activeSlotName = SlotNameFactory.getSlotName(activeSlot);
            this.changedValues.setAttribute("admActiveSlot", (Object)activeSlot);
        } else if (actionCommand.equals("PASSIVE_SLOT_AVAILABLE")) {
            Boolean comparator = Boolean.valueOf("true");
            if (this.view.enablePassiveSlot.getValue().equals(comparator)) {
                this.view.passiveSlot.setVisible(true);
                if (!this.view.passiveSlot.getValue().equals(NO_SLOTS)) {
                    MOProxy passiveSlot = null;
                    passiveSlot = (MOProxy)this.slots.get(this.view.passiveSlot.getValue());
                    this.changedValues.setAttribute("admPassiveSlot", (Object)passiveSlot);
                    this.passiveSlotName = SlotNameFactory.getSlotName(passiveSlot);
                    this.somethingChanged = true;
                }
            } else {
                this.view.passiveSlot.setVisible(false);
                this.changedValues.setAttribute("admPassiveSlot", NULL_WORKAROUND);
                this.passiveSlotName = null;
                this.somethingChanged = true;
            }
        } else if (actionCommand.equals("SELECT2")) {
            this.somethingChanged = true;
            MOProxy passiveSlot = null;
            passiveSlot = (MOProxy)this.slots.get(this.view.passiveSlot.getValue());
            this.passiveSlotName = SlotNameFactory.getSlotName(passiveSlot);
            this.changedValues.setAttribute("admPassiveSlot", (Object)passiveSlot);
        } else if (actionCommand.equals("SWITCH")) {
            this.switchSlots();
        } else if (actionCommand.equals("NORMALISATION_CHANGED")) {
            this.somethingChanged = true;
            String normalisation = this.view.normalisationCombobox.getValue();
            this.changedValues.setAttribute("normalisation", (Object)RPUNormalisationMode.get((Object)normalisation).toInteger());
        } else if (actionCommand.equals("SWITCHOVER_CHANGED")) {
            this.somethingChanged = true;
            String switchover = this.view.switchoverCombobox.getValue();
            this.changedValues.setAttribute("switchOver", (Object)RPUSwitchOverMode.get((Object)switchover).toInteger());
        } else if (actionCommand.equals("USERLABEL_CHANGED")) {
            this.somethingChanged = true;
            this.changedValues.setAttribute("userLabel", (Object)this.view.nameField.getValue());
        } else if (actionCommand.equals("RPULABEL")) {
            this.somethingChanged = true;
            boolean slotsAvailable = this.getSlotsFromServer();
            this.view.passiveSlot.setEnabled(slotsAvailable);
            this.view.activeSlot.setEnabled(slotsAvailable);
        } else if (actionCommand.equals("RPUID")) {
            this.somethingChanged = true;
        }
        this.view.applyButton.setEnabled(this.view.canDismiss() && this.somethingChanged);
        this.view.okButton.setEnabled(this.view.canDismiss());
    }

    private boolean updateRPUData() {
        boolean success;
        block11: {
            success = true;
            Transaction transaction = null;
            Object changedValuesBackup = null;
            boolean createMode = this.rpu == null;
            try {
                NameValue[] nvs;
                if (!this.somethingChanged) break block11;
                MOProxy newActiveSlot = (MOProxy)this.changedValues.getAttribute("admActiveSlot");
                MOProxy newPassiveSlot = null;
                try {
                    newPassiveSlot = (MOProxy)this.changedValues.getAttribute("admPassiveSlot");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (newActiveSlot != null && newPassiveSlot != null && newPassiveSlot.equals((Object)this.myActiveSlotMO)) {
                    transaction = new Transaction();
                    nvs = new NameValue[]{new NameValue("admActiveSlot", (Object)newActiveSlot)};
                    this.rpu.setAttributes(nvs, transaction.session);
                    transaction.commit();
                    transaction.end();
                    this.changedValues.remove((Object)"admActiveSlot");
                }
                transaction = new Transaction();
                if (this.rpu == null) {
                    MOProxy activeSlot = null;
                    activeSlot = (MOProxy)this.slots.get(this.view.activeSlot.getValue());
                    this.rpu = this.createRPU(this.view.rpuLabel.getValue(), activeSlot, this.view.replicationCombobox.getValue(), this.view.reliableProgramLabelId.getValue(), transaction);
                }
                nvs = this.changedValues.getNameValues();
                for (int i = 0; i < nvs.length; ++i) {
                    if (nvs[i].value != NULL_WORKAROUND) continue;
                    MOProxy activeSlot = null;
                    activeSlot = (MOProxy)this.rpu.getAttribute("admActiveSlot");
                    nvs[i].value = activeSlot;
                }
                this.rpu.setAttributes(nvs, transaction.session);
                transaction.commit();
                transaction.end();
            }
            catch (CSException e) {
                success = false;
                try {
                    transaction.rollback();
                    transaction.end();
                }
                catch (CSException be) {
                    Log.logError((String)"Rollback of transaction failed", (Throwable)be);
                }
                this.reportException((Exception)((Object)e), "ERROR_SET", null);
                if (changedValuesBackup != null) {
                    this.changedValues.clear();
                    for (int i = 0; i < (changedValuesBackup).length; ++i) {
                        this.changedValues.setAttribute(changedValuesBackup[i].name, changedValuesBackup[i].value);
                    }
                }
                if (!createMode) break block11;
                this.rpu = null;
            }
        }
        this.changedValues = new AttributeBuffer();
        return success;
    }

    private void switchSlots() {
        Transaction transaction = null;
        try {
            MOProxy passiveSlot;
            transaction = new Transaction();
            this.rpu.action("switch", new NameValue[0], transaction.session);
            MOProxy activeSlot = (MOProxy)this.rpu.getAttribute("admActiveSlot", transaction.session);
            if (activeSlot != null && activeSlot.getDN() != null) {
                this.activeSlotName = SlotNameFactory.getSlotName(activeSlot);
                this.view.activeSlot.setValue(this.activeSlotName);
            }
            if ((passiveSlot = (MOProxy)this.rpu.getAttribute("admPassiveSlot", transaction.session)) != null && passiveSlot != NULL_WORKAROUND && passiveSlot.getDN() != null) {
                this.passiveSlotName = SlotNameFactory.getSlotName(passiveSlot);
                this.view.passiveSlot.setValue(this.passiveSlotName);
            } else {
                this.view.passiveSlot.setValue("");
                this.view.switchButton.setEnabled(false);
            }
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException be) {
                Log.logError((String)"Rollback of transaction failed", (Throwable)be);
            }
            this.reportException((Exception)((Object)e), "ERROR_SET", null);
        }
        catch (SyntaxException se) {
            Log.logError((String)" Error in setting value ", (Throwable)se);
        }
    }

    protected boolean canStop() {
        return true;
    }

    private String[] normalisationValues() {
        String[] normalisationstates = new String[]{RPUNormalisationMode.AUTOMATIC.toString(), RPUNormalisationMode.MANUAL.toString()};
        return normalisationstates;
    }

    private String[] replicationValues() {
        String[] replicationstates = new String[]{RPUReplicationMode.ALWAYS.toString(), RPUReplicationMode.APPL_CONTROLLED.toString(), RPUReplicationMode.AT_SHUTDOWN.toString(), RPUReplicationMode.NEVER.toString()};
        return replicationstates;
    }

    private String[] switchOverValues() {
        String[] switchOverstates = new String[]{RPUSwitchOverMode.AT_PIU_FAULT.toString(), RPUSwitchOverMode.AT_PIU_RESTART.toString()};
        return switchOverstates;
    }

    private boolean getSlotsFromServer() {
        Object slotName = null;
        Object key = null;
        this.slots.clear();
        try {
            String[] rSlotString;
            MOProxy rLM = (MOProxy)this.loadModules.get(this.view.rpuLabel.getValue());
            Hashtable progsWithAttributes = MOProxy.getRoot().getChildrenWithAttributes("Program", new String[]{"loadModule"}, 8);
            Enumeration progsKeys = progsWithAttributes.keys();
            while (progsKeys.hasMoreElements()) {
                MOProxy aProg;
                MOProxy aSlot;
                String ldn = (String)progsKeys.nextElement();
                HashMap attrs = (HashMap)progsWithAttributes.get(ldn);
                MOProxy tmpLM = (MOProxy)attrs.get("loadModule");
                if (!rLM.equals((Object)tmpLM) || null == (aSlot = this.findSlotForProgram(aProg = new MOProxy(ldn)))) continue;
                this.slots.put(SlotNameFactory.getSlotName(aSlot), aSlot);
            }
            if (0 == this.slots.size()) {
                rSlotString = new String[]{NO_SLOTS};
            } else {
                rSlotString = new String[this.slots.size()];
                Enumeration enumSlots = this.slots.elements();
                for (int count = 0; count < this.slots.size(); ++count) {
                    rSlotString[count] = SlotNameFactory.getSlotName((MOProxy)enumSlots.nextElement());
                }
            }
            this.view.activeSlot.removeAllItems();
            this.view.activeSlot.addItems(rSlotString);
            this.view.passiveSlot.removeAllItems();
            this.view.passiveSlot.addItems(rSlotString);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
        }
        return this.slots.size() > 0;
    }

    private MOProxy findSlotForProgram(MOProxy aProgram) {
        if (!"Program".equals(aProgram.getType())) {
            return null;
        }
        MOProxy aParent = aProgram;
        String aType = aParent.getType();
        while (!aType.equals("Slot")) {
            aType = (aParent = aParent.getParent()).getType();
            if (null != aType && 0 != aType.length()) continue;
            aParent = null;
            break;
        }
        return aParent;
    }

    private MOProxy createRPU(String rpuLabel, MOProxy activeSlot, String replicationCombobox, String reliableProgramLabelId, Transaction transaction) throws CSException {
        String ldn = null == reliableProgramLabelId || 0 == reliableProgramLabelId.trim().length() ? MOProxy.genLDN((String)"ManagedElement=1,SwManagement=1", (String)"ReliableProgramUniter") : "ManagedElement=1,SwManagement=1,ReliableProgramUniter=" + reliableProgramLabelId;
        MOProxy rpu = new MOProxy(ldn);
        NameValue[] createArgs = new NameValue[]{new NameValue("reliableProgramLabel", (Object)rpuLabel), new NameValue("admActiveSlot", (Object)activeSlot), new NameValue("replication", (Object)RPUReplicationMode.get((Object)replicationCombobox).toInteger())};
        rpu.create(createArgs, transaction.session);
        return rpu;
    }
}

