/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.Color;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import se.ericsson.cello.emas.sm.applications.CorruptedUPsTable;
import se.ericsson.cello.emas.sm.applications.RestoreWizardView;
import se.ericsson.cello.emas.sm.applications.ResultPrintoutHelper;
import se.ericsson.cello.support.gui.gengui.GenGroupBox;
import se.ericsson.cello.support.gui.gengui.GenGui;
import se.ericsson.cello.support.gui.gengui.GenLabel;
import se.ericsson.cello.support.gui.gengui.GenTabbedPane;
import se.ericsson.cello.support.gui.gengui.TabNotDefinedException;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class RestoreSlide3VerificationResultsWizardView
extends RestoreWizardView {
    private static final long serialVersionUID = 1L;
    protected JPanel mainResultJPanel = new JPanel();
    protected JTextArea resultJTextArea = new JTextArea();
    protected JEditorPane actionResultTabJEditorPane = new JEditorPane();
    protected JTextPane additionalActionResultDataTabJTextPane = new JTextPane();
    protected GenGroupBox corruptedUPsGenGroupBox = new GenGroupBox("EMPTY");
    protected GenGroupBox missingUPsGenGroupBox = new GenGroupBox("EMPTY");
    private JEditorPane[] myHyperlinkCorruptedUP = null;
    private Integer numberOfCorruptedUPs = null;
    private Integer numberOfMissingUPs = null;
    private String[] upgradePackageIdentifer = null;
    private JTextArea[] myCorruptedUPsJTextArea = null;
    private JTextArea[] myMissingUPsJTextArea = null;
    private Color color;
    private boolean hyperlinkForCorruptedUpgradePackage_showVisible = true;

    protected void init() {
        super.init();
        this.buildGUI();
    }

    protected void buildGUI() {
        this.resultJTextArea.setEditable(false);
        this.resultJTextArea.setColumns(120);
        this.resultJTextArea.setRows(1);
        this.add((Component)new GenLabel(" "));
        this.add(this.mainResultJPanel);
        this.basePanel = new GenGui(this.getApplication().getLanguageBundleName());
        this.add((Component)this.basePanel);
        this.basePanel.add((Component)new GenLabel(" "));
        String[] tabbs = new String[]{"ACTION_RESULT_VERIFY_RESTORE_LIST", "ADDITIONAL_INFORMATION_VERIFY_RESTORE_LIST", "MISSING_UPs_VERIFY_RESTORE_LIST", "CORRUPTED_UPs_VERIFY_RESTORE_LIST"};
        GenTabbedPane tabbedPane = this.basePanel.addGenTabbedPane(tabbs);
        this.actionResultTabJEditorPane.setEditable(false);
        this.additionalActionResultDataTabJTextPane.setEditable(false);
        this.actionResultTabJEditorPane.setContentType("text/html");
        this.additionalActionResultDataTabJTextPane.setContentType("text/plain");
        this.actionResultTabJEditorPane.setBackground(this.basePanel.getBackground());
        this.additionalActionResultDataTabJTextPane.setBackground(this.basePanel.getBackground());
        try {
            tabbedPane.addComponent(tabbs[0], (Component)this.actionResultTabJEditorPane);
            tabbedPane.addComponent(tabbs[1], (Component)this.additionalActionResultDataTabJTextPane);
            tabbedPane.addComponent(tabbs[2], (Component)this.missingUPsGenGroupBox);
            tabbedPane.addComponent(tabbs[3], (Component)this.corruptedUPsGenGroupBox);
        }
        catch (TabNotDefinedException e) {
            Log.logError((String)"Error creating the tabbs", (Throwable)e);
        }
        this.color = this.basePanel.getBackground();
        this.basePanel.add((Component)tabbedPane);
    }

    protected void setMainResultText(String result) {
        this.resultJTextArea.setText(result);
        this.mainResultJPanel.add(this.resultJTextArea);
    }

    protected void setMainResultBackgroundColor(Color color) {
        this.resultJTextArea.setBackground(color);
        this.mainResultJPanel.setBackground(color);
    }

    protected void showVerificationResults() {
        ResourceBundle myBundle = this.getBundle();
        this.actionResultTabJEditorPane.setText(ResultPrintoutHelper.processActionResult(myBundle, true));
        this.additionalActionResultDataTabJTextPane.setText("\n" + ResultPrintoutHelper.processAdditionalActionResultData(myBundle));
        this.setTextInMissingUPstabb();
        this.setTextInCorruptedUPsTabb();
    }

    private void setTextInMissingUPstabb() {
        String[] missingUPs = ResultPrintoutHelper.processMissingUPs();
        JTextArea myJTextArea = new JTextArea();
        myJTextArea.setEditable(false);
        myJTextArea.setBackground(this.color);
        this.missingUPsGenGroupBox.removeAll();
        if (missingUPs != null) {
            this.numberOfMissingUPs = new Integer(missingUPs.length);
            this.myMissingUPsJTextArea = new JTextArea[this.numberOfMissingUPs.intValue()];
            myJTextArea.setText("missingUpgradePackages [" + this.numberOfMissingUPs + "]:\n\n");
            this.missingUPsGenGroupBox.add((Component)myJTextArea);
            for (int i = 0; i < this.numberOfMissingUPs; ++i) {
                this.myMissingUPsJTextArea[i] = new JTextArea();
                this.myMissingUPsJTextArea[i].setLineWrap(true);
                this.myMissingUPsJTextArea[i].setWrapStyleWord(true);
                this.myMissingUPsJTextArea[i].setEditable(false);
                this.myMissingUPsJTextArea[i].setBackground(this.color);
                this.myMissingUPsJTextArea[i].setText(missingUPs[i]);
                this.missingUPsGenGroupBox.add((Component)this.myMissingUPsJTextArea[i]);
            }
        } else {
            myJTextArea.setText("\nmissingUpgradePackages is null\n");
            this.missingUPsGenGroupBox.add((Component)myJTextArea);
        }
    }

    private void setTextInCorruptedUPsTabb() {
        CorruptedUPsTable[] corruptedUPs = ResultPrintoutHelper.processCorruptedUPs();
        JTextArea myJTextArea = new JTextArea();
        myJTextArea.setEditable(false);
        myJTextArea.setBackground(this.color);
        this.corruptedUPsGenGroupBox.removeAll();
        if (corruptedUPs != null) {
            this.numberOfCorruptedUPs = new Integer(corruptedUPs.length);
            this.myCorruptedUPsJTextArea = new JTextArea[this.numberOfCorruptedUPs.intValue()];
            this.myHyperlinkCorruptedUP = new JEditorPane[this.numberOfCorruptedUPs.intValue()];
            this.upgradePackageIdentifer = new String[this.numberOfCorruptedUPs.intValue()];
            String hyperlinkTextForCorruptedUPs = this.getApplication().getLanguageBundle().getString("GO_TO_UPGRADE_PACKAGE_PROPERTIES_WINDOW");
            myJTextArea.setText("corruptedUpgradePackages [" + this.numberOfCorruptedUPs + "]:\n\n");
            this.corruptedUPsGenGroupBox.add((Component)myJTextArea);
            for (int i = 0; i < this.numberOfCorruptedUPs; ++i) {
                this.myCorruptedUPsJTextArea[i] = new JTextArea();
                this.myCorruptedUPsJTextArea[i].setLineWrap(true);
                this.myCorruptedUPsJTextArea[i].setWrapStyleWord(true);
                this.myCorruptedUPsJTextArea[i].setEditable(false);
                this.myCorruptedUPsJTextArea[i].setBackground(this.color);
                this.myCorruptedUPsJTextArea[i].setText(corruptedUPs[i].corruptedUP_data);
                this.corruptedUPsGenGroupBox.add((Component)this.myCorruptedUPsJTextArea[i]);
                this.myHyperlinkCorruptedUP[i] = new JEditorPane();
                this.myHyperlinkCorruptedUP[i].setContentType("text/html");
                this.myHyperlinkCorruptedUP[i].setEditable(false);
                this.myHyperlinkCorruptedUP[i].setBackground(this.color);
                this.upgradePackageIdentifer[i] = corruptedUPs[i].upIdentifier;
                if (this.hyperlinkForCorruptedUpgradePackage_showVisible) {
                    String hyperlinkDescription = "openUPpropertiesWindow_" + i;
                    this.myHyperlinkCorruptedUP[i].setText("<a href=" + hyperlinkDescription + ">" + hyperlinkTextForCorruptedUPs + "</a><br>");
                } else {
                    this.myHyperlinkCorruptedUP[i].setText("<br>");
                }
                this.corruptedUPsGenGroupBox.add((Component)this.myHyperlinkCorruptedUP[i]);
            }
        } else {
            myJTextArea.setText("\ncorruptedUpgradePackages is null\n");
            this.corruptedUPsGenGroupBox.add((Component)myJTextArea);
        }
    }

    protected String getUP_productNumberAndProductRevision(int linkNumber) {
        if (linkNumber == -1) {
            return null;
        }
        return this.upgradePackageIdentifer[linkNumber];
    }

    protected void addHyperlinkListenerForPathToDetailedInfo(HyperlinkListener myHyperlinkListener) {
        if (this.actionResultTabJEditorPane != null) {
            this.actionResultTabJEditorPane.addHyperlinkListener(myHyperlinkListener);
        }
    }

    protected void addHyperlinkListenerForCorruptedUpgradePackagesTabb(HyperlinkListener myHyperlinkListener) {
        if (this.myHyperlinkCorruptedUP != null) {
            for (int i = 0; i < this.numberOfCorruptedUPs; ++i) {
                this.myHyperlinkCorruptedUP[i].addHyperlinkListener(myHyperlinkListener);
            }
        }
    }

    protected void removeHyperlinkListenerForPathToDetailedInfo(HyperlinkListener myHyperlinkListener) {
        if (this.actionResultTabJEditorPane != null) {
            this.actionResultTabJEditorPane.removeHyperlinkListener(myHyperlinkListener);
        }
    }

    protected void removeHyperlinkListenerForCorruptedUpgradePackagesTabb(HyperlinkListener myHyperlinkListener) {
        if (this.myHyperlinkCorruptedUP != null) {
            for (int i = 0; i < this.numberOfCorruptedUPs; ++i) {
                this.myHyperlinkCorruptedUP[i].removeHyperlinkListener(myHyperlinkListener);
            }
        }
    }

    protected void hyperlinkForCorruptedUpgradePackagesSetVisible(boolean visible) {
        this.hyperlinkForCorruptedUpgradePackage_showVisible = visible;
    }
}

