/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.SlotSelectController;
import se.ericsson.cello.emas.sm.applications.SlotSelectView;
import se.ericsson.cello.emas.sm.services.SlotNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Transaction;

public class SetSlotActionController
extends AbstractApplicationController
implements ActionListener {
    SlotSelectController controller = null;

    protected void init() {
        Boolean activeMode = (Boolean)this.getParameter("SET_ACTIVE_SLOT");
        MOProxy slot = null;
        MOProxy rpu = new MOProxy((String)this.getParameter("LDNLIST"));
        TreeMap<String, MOProxy> selectedSlot = new TreeMap<String, MOProxy>();
        Transaction transaction = null;
        try {
            transaction = new Transaction();
            slot = activeMode != false ? (MOProxy)rpu.getAttribute("admActiveSlot", transaction.session) : (MOProxy)rpu.getAttribute("admPassiveSlot", transaction.session);
            if (slot.getDN() != null) {
                selectedSlot.put(SlotNameFactory.getSlotName(slot), slot);
            }
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException e2) {
                Log.logError((String)"Error rolling handling transaction", (Throwable)e2);
            }
            this.reportException((Exception)((Object)e), "ERROR_EDIT_SLOTS", null);
            this.stopApp();
            return;
        }
        Object[][] params = new Object[][]{{"SLOT_LIST", selectedSlot}};
        this.controller = activeMode != false ? (SlotSelectController)this.startDialog(false, "SLOT_SELECT_ACTIVE_TITLE", null, SlotSelectView.class, SlotSelectController.class, params) : (SlotSelectController)this.startDialog(false, "SLOT_SELECT_PASSIVE_TITLE", null, SlotSelectView.class, SlotSelectController.class, params);
        this.controller.setSelectionMode(0, activeMode);
        this.controller.addActionListener(this);
        this.controller.setDialogMessage("CONFIRM_EDIT_SLOTS_RELIABLE_PROGRAM_UNITER");
    }

    public boolean setSelectedSlots(TreeMap selectedSlots) {
        boolean success = true;
        MOProxy slot = null;
        Iterator slots = selectedSlots.values().iterator();
        if (slots.hasNext()) {
            slot = (MOProxy)slots.next();
        }
        String ldn = (String)this.getParameter("LDNLIST");
        MOProxy rpu = new MOProxy(ldn);
        Boolean activeSlotMode = (Boolean)this.getParameter("SET_ACTIVE_SLOT");
        Transaction transaction = null;
        try {
            transaction = new Transaction();
            if (activeSlotMode.booleanValue()) {
                if (slot != null) {
                    rpu.setAttribute("admActiveSlot", (Object)slot, transaction.session);
                } else {
                    Log.logError((String)"Internal error: attempting to clear mandatory attribute activeSlot.");
                }
            } else {
                if (slot == null) {
                    slot = (MOProxy)rpu.getAttribute("admActiveSlot");
                }
                rpu.setAttribute("admPassiveSlot", (Object)slot, transaction.session);
            }
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            success = false;
            String errorMsg = activeSlotMode != false ? "ERROR_SET_ACTIVE_SLOT" : "ERROR_SET_PASSIVE_SLOT";
            this.reportException((Exception)((Object)e), errorMsg, null);
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException cs) {
                Log.logError((String)"Rollback of the transaction failed", (Throwable)cs);
            }
        }
        return success;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("OK") && this.setSelectedSlots(this.controller.getSelectedSlots()) && this.controller.canDismiss()) {
            this.controller.stopDialog();
            this.getApplication().stopApplicationNoCheck();
        }
        if (event.getActionCommand().equals("APPLY") && !this.setSelectedSlots(this.controller.getSelectedSlots())) {
            this.controller.enableApplyButton(true);
        }
        if (event.getActionCommand().equals("CANCEL")) {
            this.getApplication().stopApplicationNoCheck();
        }
        if (event.getActionCommand().equals("ERROR")) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    private void stopApp() {
        final AbstractApplication application = this.getApplication();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                application.stopApplicationNoCheck();
            }
        });
    }
}

