/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.EmasProgressMonitor;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AbstractConfirmApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;
import se.ericsson.cello.support.proxy.Transaction;

public class UpgradePackageDeleteController
extends AbstractConfirmApplicationController {
    public String ldnList = null;
    public MOProxy upgradePackageMo = null;
    private boolean deleting = false;
    private String progressBarTitle;
    private String progressBarMessage;
    private String message;

    public void init() {
        super.init();
        this.ldnList = (String)this.getParameter("LDNLIST");
        this.selectMessage();
        this.setConfirmationMessage(this.message, new Object[]{this.ldnList});
    }

    public void selectMessage() {
        this.message = "UP_DELETE_MESSAGE";
    }

    public void performAction() {
        this.ldnList = (String)this.getParameter("LDNLIST");
        this.upgradePackageMo = new MOProxy(this.ldnList);
        this.progressBarTitle = this.getString("PROGRESS_BAR_TITLE_UP", null);
        this.progressBarMessage = this.getString("PROGRESS_BAR_MESSAGE_UP", null);
        try {
            boolean isDeletable = (Boolean)this.upgradePackageMo.getAttribute("isDeletable", null);
            if (isDeletable) {
                new DeleteThread().start();
            } else {
                this.showNotDeletableMessage();
            }
        }
        catch (CSException e) {
            MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
            refMainWindowController.reportException((Exception)((Object)e), this.myApplication.getErrorMessage((Exception)((Object)e)), null);
            Log.logError((String)"Error getting attribute. ", (Throwable)e);
        }
    }

    private void showNotDeletableMessage() {
        try {
            String[] deletePreventingCVs = (String[])this.upgradePackageMo.getAttribute("deletePreventingCVs");
            StringBuffer message = new StringBuffer();
            StringBuffer message2 = new StringBuffer();
            for (int i = 0; i < deletePreventingCVs.length; ++i) {
                String delPrevCV = "\t" + deletePreventingCVs[i] + "\n";
                message.append(delPrevCV);
            }
            Struct[] adminData = (Struct[])this.upgradePackageMo.getAttribute("deletePreventingUPs");
            if (adminData != null && adminData.length != 0) {
                for (int i = 0; i < adminData.length; ++i) {
                    message2.append("\t" + (String)adminData[i].getElementValue("productName") + " " + (String)adminData[i].getElementValue("productNumber") + " " + (String)adminData[i].getElementValue("productRevision") + "\n");
                }
            }
            Object[] messageArgs = new String[]{message.toString(), message2.toString()};
            this.showMessageDialog("UP_DELETE_ERROR_REFERENCED_BY_CV_MSG", messageArgs, "GSL_ERROR", null, 0, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
            Log.logError((String)"Error getting attribute", (Throwable)e);
        }
        catch (Exception e) {
            Log.logError((String)"Error getting attribute", (Throwable)e);
        }
    }

    private void handleException(Exception e, Transaction transactionId) {
        try {
            transactionId.rollback();
            transactionId.end();
        }
        catch (CSException rollbackE) {
            Log.logError((String)"Error rolling back transaction.", (Throwable)rollbackE);
        }
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        refMainWindowController.reportException(e, this.myApplication.getErrorMessage(e), null);
    }

    private class ProgressThread
    extends Thread {
        public void run() {
            EmasProgressMonitor pm = new EmasProgressMonitor(null, (Object)UpgradePackageDeleteController.this.progressBarTitle, (Object)UpgradePackageDeleteController.this.progressBarMessage, UpgradePackageDeleteController.this.upgradePackageMo.getDN(), 0, 100);
            int progressCount = 0;
            pm.setMsToPopup(0);
            pm.setMillisToDecideToPopup(0);
            while (UpgradePackageDeleteController.this.deleting) {
                if (progressCount == 99) {
                    progressCount = 0;
                    pm.resetProgressBar();
                }
                pm.setProgress(progressCount++);
                try {
                    ProgressThread.sleep(12L);
                }
                catch (InterruptedException interruptedException) {}
            }
            pm.dialogClose();
        }
    }

    private class DeleteThread
    extends Thread {
        public void run() {
            Transaction transactionId = null;
            try {
                transactionId = new Transaction(1800000);
                if (UpgradePackageDeleteController.this.ldnList == null) {
                    throw new IllegalArgumentException();
                }
                if (!UpgradePackageDeleteController.this.upgradePackageMo.getType().equals("UpgradePackage")) {
                    throw new IllegalArgumentException();
                }
                NameValue[] args = new NameValue[]{};
                UpgradePackageDeleteController.this.deleting = true;
                new ProgressThread().start();
                UpgradePackageDeleteController.this.upgradePackageMo.delete(transactionId.session);
                transactionId.commit();
                transactionId.end();
            }
            catch (CSException e) {
                UpgradePackageDeleteController.this.deleting = false;
                UpgradePackageDeleteController.this.handleException((Exception)((Object)e), transactionId);
            }
            catch (IllegalArgumentException e) {
                UpgradePackageDeleteController.this.deleting = false;
                UpgradePackageDeleteController.this.handleException(e, transactionId);
            }
            UpgradePackageDeleteController.this.deleting = false;
        }
    }
}

